.TH Concept "Introduction to Empire"
What is Empire?
.in +0.3i
.s3
Empire is an military/economic simulation of make-believe
countries in a make-believe world.
In this version (UCSD Empire),
the military part is emphasized.
The economic part is still there,
but as a prerequisite to a working military.
.in
.s1
What part do I play?
.in +0.3i
.s3
Each player is the ruler of a country.
As leader of your country,
you give commands that affect your country
(e.g., move people around,
re-designate sectors, etc).
You also handle all of your country's foreign policy.
.s1
Empire lets you get reports on the status of your country
(``info census'' and others),
find out what's going on in other parts of the world
(``info news''),
and communicate with other countries
(``info telegram'').
.s1
Although no goal is explicitly stated,
most players rapidly derive their own,
ranging from the mundane desire to be the biggest,
strongest country in the game,
to the more refined goals of
having the most efficient land use possible,
or having the lowest ratio of military to civilians while
still surviving.
.in
.s1
The World of Empire
.in +0.3i
.s3
Empire is played on a hexagonal map
partitioned into a rectangular grid of \*(iFM\*(pF\ \(mu\ \*(iFN\*(pF
sectors (where \*(iFM\*(pF and \*(iFN\*(pF are typically,
but not necessarily,
powers of two, usually 64, 128, or 256).
The world is made up of approximately
50% sea, 45% habitable land and 5% uninhabitable mountains.
This \*Qmap\*U is generated by a program that
simulates the processes that may have occurred on Earth.
.s1
Sectors can be assigned a specific sector type.
These types range from banks to nuclear fuel processing plants.
See ``info sector-types'' for more detail.
.s1
Your personal coordinate system is based on your capital,
which is a type of sector.
Your capital is generally marked by the coordinates 0,\ 0.
.in
.s1
The Empire Time Scale
.in +0.3i
.s3
The Empire world both does and does not match the real-time world.
To better explain this, let us examine the concept of an update.
.s1
At regular intervals (usually around four hours),
the entire Empire world is updated.
When the world updates, new population is added,
ores are dug up and added to stockpiles,
food and other commodities are distributed to sectors,
the educational and technological levels are updated,
and so on.
It can be thought of as the minimum quantum for growth.
.s1
On this time scale, an update could be considered
to be approximately one generation.
Thus the difference from the time scale of the real world.
.s1
However, certain commands are issued in real-time,
such as attacks.
These commands have instantaneous effects on the state of your country.
Dedicated (or merely experienced) Empire players will often
log on to monitor their country.
And most attackers will wait until the small hours of the morning
to carry out their attacks, for obvious reasons.
.s1
If you do not log in to Empire,
any automatic policies you have set up will be carried out.
However, Empire will not try to fix any mistakes you have made;
unless you are very careful,
it's probably not a good idea to rely on these automatics.
.in
.s1
Bureaucratic Time Units (BTU's)
.in +0.3i
.s3
To prevent the more fanatical Empire players
from staying logged on all the time,
Empire places a limit on the amount of time you may be logged in
per day.
This limit is usually 120 minutes.
If you run out of time, too bad!
You can't log in again until the counter resets itself
(usually at midnight).
.s1
The other control on the number of commands that you may issue
are called ``Bureaucratic Time Units'' or BTU's.
A BTU is an arbitrary amount of bureaucratic bookkeeping that
your government must spend to perform a certain function.
Most commands that are not merely informative cost BTU's.
.s1
BTU's are generated by your country's capital.
The more efficient your capital, the more BTU's that are generated.
A 100% efficient capital generates 255 BTU's every 24 hours.
However, you may have a maximum of 255 BTU's at any one time.
And once your BTU's reach zero, you may not issue any commands
that use BTU's.
.s1
Three things to note about BTU's:
.in +\w'00)\0\0'u
.s3
.L 1)
Since commands use up BTU's,
this limits the number of commands
that a player may issue over a particular time period.
This has the effect of preventing the Empire fanatic
from overruning other players with less free time to log on.
.s3
.L 2)
The build-up of BTU's is constant and does not depend on being
logged in.
This allows players to participate when it is convenient rather
than at some fixed time
(such as most board games, or the stock market).
.s3
.L 3)
The BTU concept helps compensate for the fact that,
in concept, the governments of each country are always
``playing'' although the player representing that country
may only log in periodically.
.in -\w'00)\0\0'u
.in 0
.s1
How long will a game take?
.in +0.3i
.s3
Probably from one to four months.
You should expect to spend one to four hours a day playing.
Also expect that if you do spend this amount of time playing,
your grades or work will suffer.
You just can't spend that much time playing and either
study or be productive.
.in
.s1
What should I do now?
.in +0.3i
.s3
When a new country enters the game,
it starts out with an amount of money and two sectors.
These sectors are sanctuaries
and have an initial amount of people and commodities.
Until you \*Qbreak sanctuary\*U,
your country is effectively in stasis.
Nothing will change until you actually log in and
force a change
(such as designating a capital to begin accumulating BTU's).
.s1
The absolutely minimal set of information pages you should read are:
capital,
census,
deliver,
designate,
education,
food,
map,
move,
novice,
populace,
products,
realm,
and
sector-types.
.in
.s1
Tools to help you play:
.in +0.3i
.s3
Ve, or Visual Empire helps examine your country.
Note: ve is not easy to use;
if you have time, paper is much better. 
Ve should be available from the same place you got your Empire client.
.in
.s1
A Comment from Peter S. Langston
.in +0.3i
.s3
It should be remembered that Empire is mearly an interesting pastime;
in the vernacular, \*Qit's just a game\*U.
There are many amusing stories of people
that took the game too seriously;
one tells of a corporate Vice President
who walked into the computer room and flipped the main
circuit breaker in order to stop an attack on his country;
another tells of the Harvard student
that refused to go to bed until everyone logged out of Empire
and of the other players who took turns staying up late....
.s1
While many players take Empire very seriously,
an equal number of players use it as a safe environment
in which they can act out their fantasies.
On occasion the fantasies involved are remarkably aggressive or hostile.
It has been my experience that the people with the most belligerent
countries are often the people with the kindest hearts;
anti-social game play doesn't necessarily reflect the \*Qtrue\*U
being underneath
(or else I have some VERY weird friends).
.in
.s1
A Brief History
.in +0.3i
.s3
The game \*QEmpire\*U is the most recent in a series
of territorial conquest, political/economic simulation games
initially inspired by a board game of the same name
played at Reed College (Portland, Oregon).
Earlier versions were written at Reed by Peter Langston
and at The Evergreen State College (Olympia, Washington)
by Chas Douglas, Peter Langston, Ben Norton, Mike Rainwater and others;
of particular note are the games \*QGalaxy\*U (Langston)
and \*QCivil\*U (Norton).
The previous version was written partly on the HRSTS Unix system at
the Harvard Science Center, (Cambridge, Mass.),
partly on the Unix system at Commercial Union
Leasing Corporation, (New York, N.\ Y.)
and partly on the Unix system at Davis Polk & Wardwell,
(New York, N.\ Y.)
by Peter Langston with invaluable goading from
Joe Stetson, Robert Bradbury, Nat Howard, Brian Redman, Adam Buchsbaum,
and a myriad of others.
Since Langston never released source code for his version,
Dave Pare and friends de-compiled it and have created this version
which is very different.
.in
.s3
See also : novice, expert
