#ifndef lint
static char *RCSid = "$Header: host.c,v 1.3 89/09/28 02:00:52 mr-frog Exp $";
#endif /* not lint */

/*
 * host.c
 *
 * make stream connection to empire
 *
 * Dave Pare, 1989
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ctype.h>

int
hostaddr(name, addr)
	char	*name;
	struct	sockaddr_in *addr;
{
	extern	u_long inet_addr();
	struct	hostent *hp;

	if (name == 0 || *name == 0)
		return 0;
	if (isdigit(*name)) {
		addr->sin_addr.s_addr = inet_addr(name);
	} else {
		hp = gethostbyname(name);
		if (hp == NULL) {
			fprintf(stderr, "%s: No such host\n", name);
			return 0;
		}
		bcopy(hp->h_addr, (char *)&addr->sin_addr,
			sizeof(addr->sin_addr));
	}
	return 1;
}

int
hostport(name, addr)
	char	*name;
	struct	sockaddr_in *addr;
{
	struct	servent *sp;

	if (name == 0 || *name == 0)
		return 0;
	if (isdigit(*name)) {
		addr->sin_port = htons(atoi(name));
	} else {
		sp = getservbyname(name, "tcp");
		if (sp == NULL)
			return 0;
		addr->sin_port = sp->s_port;
	}
	return 1;
}

int
hostconnect(addr)
	struct	sockaddr_in *addr;
{
	int	s;

	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		return -1;
	}
	addr->sin_family = AF_INET;
	if (connect(s, addr, sizeof(*addr)) < 0) {
		perror("connect");
		(void) close(s);
		return -1;
	}
	return s;
}
