/*
    $Header: /usr/local/src/et/work/xemp5.0/termc/RCS/event.c,v 5.1 93/03/14 16:37:14 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:37:14 $
    $Author: etienne $
    $Id: event.c,v 5.1 93/03/14 16:37:14 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	event.c,v $
 * Revision 5.1  93/03/14  16:37:14  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:28:03  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:11:33  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "tc_type.h"
#include "event.h"
#include "window.h"
#include "char.h"
#include "sector.h"

extern IPixel ** screen_image;
extern char intrchar;

WinInfo EventWindow (event)
Event event;
{
	return event-> win;
}

void NextEvent (event)
Event event;
{
	char ch;
	char * ptr;
	int i;
	bool cont;

	Refresh ();
 	for (;;)
	{
		ShowCursor ();
		ch = getchar ();
		HideCursor ();

		ptr = index (button_chars, ch);
		if (ptr != (char *) 0)
		{
			event-> type = ButtonPress;
			event-> button = ptr - button_chars;
			event-> win = screen_image [current_y]
						   [current_x]-> parent;
			event-> x = current_x - event-> win-> offset_x
					      - event-> win-> si_start_x;
			event-> y = current_y - event-> win-> offset_y
					      - event-> win-> si_start_y;
			return;
		}

		ptr = index (move_chars, ch);
		if (ptr != (char *) 0)	/* Move cursor */
		{
			i = ptr - move_chars;

			switch (i)
			{

			case CH_LEFT:
				current_x --;
				break;

			case CH_RIGHT:
				current_x ++;
				break;

			case CH_UP:
				current_y --;
				break;

			case CH_DOWN:
				current_y ++;
				break;

			case CH_SH_LEFT:
				current_x -= 6;
				break;

			case CH_SH_RIGHT:
				current_x += 6;
				break;

			case CH_SH_UP:
				current_y -= 4;
				break;

			case CH_SH_DOWN:
				current_y += 4;
				break;

			}

			if (current_x < 0)
				current_x += screen_cols;
			else if (current_x >= screen_cols)
				current_x -= screen_cols;

			if (current_y < 0)
				current_y += screen_rows;
			else if (current_y >= screen_rows)
				current_y -= screen_rows;

			continue;
		}

		if (ch == move_prefix)
		{
			cont = True;
			while (cont)
			{
				ch = getchar ();

				if (StandardChar (ch, E_INTR | E_REDRAW))
				{
					if (interrupt)
					{
						interrupt = False;
						cont = False;
					}

					continue;
				}

				ptr = index (move_chars, ch);
				if (ptr != (char *) 0)
				{
					switch (ptr - move_chars)
					{

					case CH_LEFT:
						ShiftField (- 1, 0);
						break;

					case CH_RIGHT:
						ShiftField (1, 0);
						break;

					case CH_UP:
						ShiftField (0, - 1);
						break;

					case CH_DOWN:
						ShiftField (0, 1);
						break;
					}

					FlushWindow (map_win);
					Refresh ();
					cont = False;
					continue;
				}

				if (ch == move_to_map)
				{
					current_x = CENSUS_WIDTH + (screen_cols
							- CENSUS_WIDTH) / 2;
					current_y = screen_rows / 2;
					cont = False;
					continue;
				}

				if (ch == move_to_census)
				{
					current_x = CENSUS_WIDTH / 2;
					current_y = screen_rows / 2;
					cont = False;
					continue;
				}
				
				if (ch == move_to_empire)
				{
					current_x = CENSUS_WIDTH + (screen_cols
							- CENSUS_WIDTH) / 2;
					current_y = screen_rows - 2;
					cont = False;
					continue;
				}

				if (ch == move_to_lower_left)
				{
					current_x = 3;
					current_y = screen_rows - 2;
					cont = False;
					continue;
				}

				if (ch == ESCAPE)
				{
					cont = False;
					continue;
				}

				Bell ();
			}

			continue;
		}

		event-> type = KeyPress;
		event-> ch = ch;
		event-> win = screen_image [current_y][current_x]-> parent;
		event-> x = current_x - event-> win-> offset_x
				      - event-> win-> si_start_x;
		event-> y = current_y - event-> win-> offset_y -
				      - event-> win-> si_start_y;
		return;
	}
}

bool StandardEvent (event)
Event event;
{
	char * ptr;

	if (event-> type == KeyPress)
	{
		if (event-> ch == CNTR ('L'))
		{
			Redraw ();
			return True;
		}

		if (event-> ch == intrchar)
		{
			interrupt = True;
			return True;
		}
#ifdef DEBUG

		if (event-> ch == '\004')	/* ^D: Dump window */
		{
			DumpWindow (event-> win);
			return True;
		}

#endif /* DEBUG */

		/* Scroll window ? */

		if (event-> win-> scrollbar)
		{
			ptr = index (scroll_chars, event-> ch);
			if (ptr != (char *) 0)
			{
				WinInfo win;
				int dy;

				dy = 0;
				win = event-> win;

				switch (ptr - scroll_chars)
				{

				case CH_SCROLL_1U:
					dy = -1;
					break;

				case CH_SCROLL_1D:
					dy = 1;
					break;

				case CH_SCROLL_5U:
					dy = -5;
					break;

				case CH_SCROLL_5D:
					dy = 5;
					break;
				}

				win-> wd_start_y += dy;
				if (win-> wd_start_y > win-> savelines)
					win-> wd_start_y = win-> savelines;
				else if (win-> wd_start_y < 0)
					win-> wd_start_y = 0;
				
				DrawScrollBar (win);
				RefreshWindow (win);

				return True;
			}
		}
	}

	return False;
}

bool StandardChar (ch, which_events)
char ch;
int which_events;
{
	char * ptr;
	WinInfo win;
	int dy;

	if (which_events & E_REDRAW)
	{
		if (ch == CNTR ('L') || ch == CNTR ('R'))
		{
			Redraw ();
			return True;
		}
	}

	if (which_events & E_SCROLL)
	{
		ptr = index (scroll_chars, ch);
		win = screen_image [current_y][current_x]-> parent;
		if ((ptr != (char *) 0) && win-> scrollbar)
		{
			dy = 0;
			switch (ptr - scroll_chars)
			{

			case CH_SCROLL_1U:
				dy = -1;
				break;

			case CH_SCROLL_1D:
				dy = 1;
				break;

			case CH_SCROLL_5U:
				dy = -5;
				break;

			case CH_SCROLL_5D:
				dy = 5;
				break;
			}

			win-> wd_start_y += dy;

			if (win-> wd_start_y > win-> savelines)
				win-> wd_start_y = win-> savelines;
			else if (win-> wd_start_y < 0)
				win-> wd_start_y = 0;
			
			DrawScrollBar (win);
			RefreshWindow (win);
			return True;
		}
	}

	if (which_events & E_INTR)
	{
		if (ch == intrchar)
		{
			interrupt = True;
			return True;
		}
	}
		
	return False;
}

int CharToButton (ch)
char ch;
{
	char * ptr;

	ptr = index (button_chars, ch);
	if (ptr != (char *) 0)
			return ptr - button_chars;
	
	return -1;
}

	/*
	 *	Using termcap, just wait for a [Return]
	 *	or a [Space].
	 */

void WaitButtonPress ()
{
	char ch;

	do {
		ch = getchar ();
	}
	while (ch != ' ' & ch != '\n');
}

Sector SelectSector (button)
int * button;
{
	Sector sct;
	int x, y;

	sct = (Sector) 0;

	for (;;)
	{
		if (SelectSctCrd (& x, & y, button))
		{
			return World (x, y, S_EXIST);
		}
		else
			return (Sector) 0;
	}
}

bool SelectSctCrd (x, y, button)
int * x, * y, * button;
{
	EVENT event;

	for (;;)
	{
		NextEvent (& event);

		if (StandardEvent (& event))
		{
			if (interrupt)
			{
				interrupt = False;
				* x = 0;
				* y = 0;
				if (button != (int *) 0)
					* button = MIDDLE_BUTTON;
				return False;
			}

			continue;
		}

		if (event. type == ButtonPress)
		{
			if (event. win != map_win)
				continue;

			* x = event. x;
			* y = event. y;

			if (button != (int *) 0)
				* button = event. button;
			
			if (! ConvertToSctCrd (x, y))
				continue;

			return True;
		}
	}
}

static void MapButton (pevent)
Event pevent;
{
	int button;
	Sector sct;
	int x, y;
	
	button = pevent-> button;

	x = pevent-> x;
	y = pevent-> y;

	if (button == LEFT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		SetCurrent (sct);
		return;
	}
	else if (button == MIDDLE_BUTTON)
	{
		GlobalCommands (x, y);
		return;
	}
	else if (button == RIGHT_BUTTON)
	{
		sct = FindSector (x, y);

		if (sct == (Sector) 0 || NO_INFO (sct))
			return;

		if (sct != cursct)
		{
			SetCurrent (sct);
			Census ();
			Refresh ();
		}
 
		SectorCommands (x, y);
		return;
	}
}

static void EmpireButton (pevent)
Event pevent;
{
	if (pevent-> button == LEFT_BUTTON)
		InputToEmpire ();

	Census ();
}

void MainLoop ()
{
	EVENT event;
	WinInfo win;

	for (;;)
	{
		FreeFmts ();

		NextEvent (& event);

		/* since interrupt is a standard event nothing will happen
		 * when interrupted at this level
		 */

		if (! StandardEvent (& event))
		{

			win = event. win;

			switch (event. type)
			{

			case ButtonPress:

				if (win == map_win)
					MapButton (& event);
				else if (win == empire_win)
					EmpireButton (& event);
				else if (win == census_win)
				{
					if (event. button == MIDDLE_BUTTON)
						GlobalCommands (event. x,
								event. y);
					else
						CensusButton (event. x,
							      event. y);
				}
				break;

			case KeyPress:
				GlobalKey (event. ch);
			}
		}

		interrupt = False;
	}
}

bool SelButtonAtWin (win, x, y, button)
WinInfo win;
int * x, * y, * button;
{
 	EVENT event;
 
 	for (;;)
 	{
 		NextEvent (& event);
 
 		if (StandardEvent (& event))
 		{
 			if (interrupt)
 			{
 				interrupt = False;
 				return False;
 			}
 
 			continue;
 		}
 
 		switch (event. type)
 		{
 
 		case ButtonPress:

 			if (event. win != win)
 				return False;
 
 			if (button != (int *) 0)
 				* button = event. button;
 			
 			if (x != (int *) 0)
 				* x = event. x;
 			
 			if (y != (int *) 0)
 				* y = event. y;
 
 			return True;
		}
	}
}

void SelectButtonChar (button, ch, x, y, fmt)
int * button, * x, * y;
char * ch, * fmt;
{
	EVENT event;

	for (;;)
	{
		NextEvent (& event);

		if (StandardEvent (& event))
		{
			if (interrupt)
				return;
			
			continue;
		}

		if (event. type == ButtonPress)
		{
			* ch = '\0';
			* x = event. x;
			* y = event. y;
			if (button != (int *) 0)
				* button = event. button;
			
			return;
		}

		if (event. type == KeyPress)
		{
			if (CharInFormat (event. ch, fmt))
			{
				* ch = event. ch;
				return;
			}
		}
	}
}
