/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/util/RCS/prog.c,v 5.1 93/03/14 16:52:59 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:52:59 $
    $Author: etienne $
    $Id: prog.c,v 5.1 93/03/14 16:52:59 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	prog.c,v $
 * Revision 5.1  93/03/14  16:52:59  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "parser.h"
#include "xrc.h"
#include "func.h"

	/*
	 *	usage: xemp -u prog:land.p:#1
	 */

void UtilRunProg (arg)
char * arg;
{
	char * ptr, * progf, * realm;
	int sx, sy, ex, ey;
	register int x;
	register int y;
	Strings prog_str, outp_str, send_str;
	Program program;
	Sector sct;

	ptr = index (arg, ':');
		
	if (ptr == (char *) 0)
	{
		realm = "#";
		progf = arg;
	}
	else
	{
		realm = ptr + 1;
		progf = Str (arg);
		ptr = index (progf, ':');
		* ptr = '\0';
	}
		
	if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
	{
		fprintf (stderr, "xemp run prog: Illegal realm specified\n");
		return;
	}

	prog_str = InitStrings ();
	if (! LoadStrings (prog_str, progf))
	{
		fprintf (stderr, "xemp run prog: Can't open %s\n", progf);
		return;
	}

	program = ParseProgram (prog_str);
	if (program == (Program) 0)
	{
		fprintf (stderr,
			"xemp run prog: Program '%s' contains errors\n",
			progf);
		FreeStrings (prog_str);
		return;
	}
	
	printf ("Running program\n");

	send_str = InitStrings ();
	outp_str = InitStrings ();

	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x ++)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
				continue;
			
			if (RunProgram (sct, program, outp_str, send_str)
								== P_ABORTED)
			{
				fprintf (stderr,
					"xemp run prog: program aborted");
				printf ("\nOutput of program:\n\n");
				DumpStrings (outp_str);
				printf ("\nEnd output\n");
				printf ("\nSend of program:\n\n");
				DumpStrings (send_str);
				printf ("\nSend output\n");
				FreeStrings (outp_str);
				FreeStrings (send_str);
				FreeStrings (prog_str);
				return;
			}
		}

	if (StringsSize (outp_str) == 0)
	{
		printf ("No output");
	}
	else
	{
		printf ("\nOutput of program:\n\n");
		DumpStrings (outp_str);
		printf ("\nEnd output\n");
	}

	if (StringsSize (send_str) > 0)
		AddMail (send_str, Fmt ("=== Output of '%s' (%s)", progf,
				DateFmt (time ((time_t *) 0))));

	FreeStrings (outp_str);
	FreeStrings (send_str);
	FreeStrings (prog_str);
	return;
}

char * selprog_strs [] = 
{
	"Run from program directory",
	"Edit program",
	"Edit new"
};

#define	SP_RUNDIR	0
#define	SP_EDITDIR	1
#define	SP_EDITNEW	2

#define	SP_MAX		3

#define PC_RUN		0
#define	PC_EDIT		1
#define	PC_SAVE		2
#define	PC_CANCEL	3

#define PC_MAX		4

static char * prog_choices [] =
{
	"Run program",
	"Edit program",
	"Save program",
	"Cancel"
};

int ProgChoice (x, y)
int x, y;
{
	Pager pager;
	Strings strings;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, prog_choices, PC_MAX, 0);
	pager = InitPager (strings, "What next?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	return (int) (i < 0 ? PC_CANCEL : i);
}

char * ProgFile (file)
char * file;
{
	if (* file == '/')
		return file;

	if (xrc. progdir == (char *) 0)
		return file;
	else
		return Fmt ("%s/%s", xrc. progdir, file);
}

bool FileExists (file)
char * file;
{
	return (access (file, 0) == 0);
}

char * SelectProgramFromDir (x, y)
int x, y;
{
	Strings strings;
	char * ret;
	int i;
	Pager pager;

	strings = PopenStrings (Fmt ("ls -1 %s", xrc. progdir));
	pager = InitPager (strings, "Which program?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	if (i < 0)
	{
		FreeStrings (strings);
		return (char *) 0;
	}

	ret = Fmt ("%s", GiveIdString (strings, i));
	FreeStrings (strings);
	return ret;
}

Program SelectProgram (x, y)
int x, y;
{
	Strings strings, prog_strings, stripped;
	Pager pager;
	Program program;
	bool cont;
	char * ans, * file;
	int i, choice;

	strings = InitStrings ();
	AddStringsID (strings, selprog_strs, SP_MAX, 0);
	pager = InitPager (strings, "Which?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
		return (Program) 0;

	switch (i)
	{

	case SP_RUNDIR:
		file = SelectProgramFromDir (x + 2, y + 2);
		if (file == (char *) 0)
			return (Program) 0;

		prog_strings = InitStrings ();
		if (! LoadStrings (prog_strings, ProgFile (file)))
		{
			Message ("Load failed");
			Bell ();
			return (Program) 0;
		}
		program = ParseProgram (prog_strings);
		FreeStrings (prog_strings);
		return program;
	
	case SP_EDITDIR:
		file = SelectProgramFromDir (x + 2, y + 2);
		if (file == (char *) 0)
			return (Program) 0;

		prog_strings = InitStrings ();
#ifdef TERMC_VERSION
		if (! LoadStrings (prog_strings, ProgFile (file)))
#else
		if (! LoadEditStrings (prog_strings, ProgFile (file)))
#endif
		{
			Message ("Load failed");
			Bell ();
			FreeStrings (prog_strings);
			return (Program) 0;
		}
		break;

	case SP_EDITNEW:
		file = InputAtMessage ("Filename: ", 16, GS_TEXT);

		if (file == (char *) 0 || interrupt)
		{
			Message ("Edit Cancelled");
			return (Program) 0;
		}

		if (* file != '\0' && FileExists (ProgFile (file)))
		{
			Message ("This file already exists");
			Bell ();
			return (Program) 0;
		}

#ifdef TERMC_VERSION
		prog_strings = InitStrings ();
#else /* X_VERSION */
		prog_strings = EditStrings (80, 25);
#endif
		break;
	}

#ifdef X_VERSION

	pager = InitPager (prog_strings, "Enter your program");
	AddPagerFunc (pager, "Save", SAVEFUNC);
	/* AddPagerFunc (pager, "Read", READFUNC); */
	AddPagerFunc (pager, "Run", DONEFUNC);
	AddPagerFunc (pager, "Compile", COMPILEFUNC);
	AddPagerFunc (pager, "Cancel", CANCEL);
	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		i = EditPager (pager);

		if (i == COMPILEFUNC || i == DONEFUNC || i == SAVEFUNC)
		{
			program = ParseProgram (prog_strings);
			if (program != (Program) 0)
			{
				Message ("Program OK");
				
				if (i == DONEFUNC)
					break;

				if (i == SAVEFUNC)
				{
					ans = InputAtMessage (
					    Fmt ("Filename%s: ",
						file == (char *) 0
					     	    ? ""
						    : Fmt (" [%s]", file)),
						16,
						GS_TEXT);
				
					if (ans == (char *) 0 || interrupt ||
						(* ans == '\0' &&
						 file == (char *) 0))
					{
						Message ("Save cancelled");
						continue;
					}

					if (* ans == '\0')
						ans = file;

					stripped = StripStrings (prog_strings);
					WriteStrings (stripped,
						Fmt ("!%s", ProgFile (ans)));
					Message (Fmt (
						"%s saved in your progdir",
						ans));
					FreeStrings (stripped);
					file = ans;
				}

				DestroyProgram (& program);
			}

			continue;
		}

		if (i == CANCELFUNC || i == CANCEL || i == CANCELALL)
		{
			FreePager (pager);
			FreeStrings (prog_strings);
			Message ("Edit Cancelled");
			return (Program) 0;
		}

		break;
	}

	FreePager (pager);
	return program;

#else /* TERMC_VERSION */

	pager = InitPager (prog_strings, "Program");
	SetEditPager (pager);
	for (;;)
	{
		(void) EditPager (pager);
		prog_strings = PagerStrings (pager);
		program = ParseProgram (prog_strings);

		for (;;)
		{
			choice = ProgChoice (x, y);

			if (choice == PC_CANCEL)
			{
				if (program != (Program) 0)
					DestroyProgram (& program);
				FreePager (pager);
				FreeStrings (prog_strings);
				return (Program) 0;
			}

			if (choice == PC_EDIT)
				break;

			if (program == (Program) 0)
			{
				Message ("Write a correct program first");
				continue;
			}

			if (choice == PC_SAVE)
			{

				ans = InputAtMessage (
					Fmt ("Filename%s: ",
						file == (char *) 0
							? ""
							: Fmt (" [%s]", file)),
					16,
					GS_TEXT);
				
				if (ans == (char *) 0 || interrupt ||
					(* ans == '\0' && file == (char *) 0))
				{
					Message ("Save cancelled");
					continue;
				}

				if (* ans == '\0')
					ans = file;

				WriteStrings (prog_strings, 
					Fmt ("!%s", ProgFile (ans)));
				Message (Fmt ( "%s saved in your progdir",
						ans));
				continue;
			}

			/* else choice = PC_RUN */

			FreePager (pager);
			FreeStrings (prog_strings);
			return program;
		}
	}
#endif
}
