/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/update/RCS/distribute.c,v 5.1 93/03/14 16:51:59 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:59 $
    $Author: etienne $
    $Id: distribute.c,v 5.1 93/03/14 16:51:59 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	distribute.c,v $
 * Revision 5.1  93/03/14  16:51:59  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:58  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:44:42  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "version.h"

void UpdDistribute (from, strings, what)
Sector from;
Strings strings;
int what;
{
	double pathcost;
	Sector ware;
	int amt;
	int thresh;
	int amt_ware  ;
	int amt_from;
	int packing;
	double imcost;
	double excost;
	int wh_packing;
	int diff;
	int item;
	char itemchar;

	if ((land_units && (s_dxc (from) == s_xcd (from) && s_dyc (from) == s_ycd (from))) || (!land_units && (s_pat (from) == (char *) 0 || * s_pat (from) == '_')))
		return;

	if (land_units) {
		ware = World ( s_dxc (from) , s_dyc (from) , S_DESIG);
		pathcost = RealPathCost (from, BestTmpDistPath (from, ware));
	} else {
		ware = FollowPath (from, s_pat (from));
		pathcost = RealPathCost (from, s_pat (from));
	}
	if (pathcost < 0.0 || ware == (Sector) 0 || ! s_owned (ware))
	{
		AddString (strings, Fmt ("Bad dist path in %s", CrdStr (from)));
		return;
	}
			

	wh_packing = SectorPacking (s_des (ware));
	packing = SectorPacking (s_des (from));

	for (item = 1; item < V_MAX; item ++)
	{
	        if ((item == V_CIVIL) || (item == V_MILIT)) 
		        continue;
		itemchar = ItemChar (item);
		thresh = GetThreshold (from, itemchar);
		if (thresh == 0)
			continue;

		/*
		 * calculate costs for importing and exporting.
		 * the div 2.0 is because delivering straight through
		 * ware the dist sect is cheaper than stopping at each
		 * sector along the way (processor-timewise)
		 */

		excost = (pathcost * ItemWeight (item, packing)) / 2.0;
		imcost = (pathcost * ItemWeight (item, wh_packing)) / 4.0;
		amt_from = GiveQuant (from, itemchar);
		amt_ware = GiveQuant (ware,   itemchar);
		diff = amt_from - thresh;
			
		if (diff < 0 && (what == DBOTH || what == DIMPORT))
		{
			/*
			 *	ware-> from	(import)
			 */

			if (s_mob (ware) <= 0)
				continue;

			amt = - diff;

			if (amt > amt_ware)
				amt = amt_ware;

			if (s_mob (ware) < (int) (imcost * amt))
				amt = (int) (s_mob (ware) / imcost);

			if (amt + amt_from > 9999)
				amt = 9999 - amt_from;

			if (amt == 0)
				continue;

			SetQuant (from, itemchar, amt_from + amt);
			SetQuant (ware, itemchar, amt_ware - amt);
			set_mob (ware, s_mob (ware) - (int) (imcost * amt));
		}
		else {
			if (diff > 0 && (what == DBOTH || what == DEXPORT)) {
			/*
			 *	from-> ware	(export)
			 */

				if (s_mob (from) <= 0)
					continue;

				amt = diff;

				if (amt_from < amt)	/* should be impossible */
				{
					amt = amt_from;
					if (amt_from == 0)
						continue;
				}

				if (s_mob (from) < excost * amt)
					amt = (int) (s_mob (from) / excost);

				SetQuant (from, itemchar, amt_from - amt);
				SetQuant (ware, itemchar, amt_ware + amt);
				set_mob (from, s_mob (from) - (int) (excost * amt));
				}
		}
	}
}
