/*
	$Header: /usr/local/src/et/work/xemp5.0/lib/update/RCS/land.c,v 1.1 93/03/14 16:52:07 etienne Exp Locker: etienne $
	$Date: 93/03/14 16:52:07 $
	$Author: etienne $
	$Id: land.c,v 1.1 93/03/14 16:52:07 etienne Exp Locker: etienne $
	$Locker: etienne $
	$Log:	land.c,v $
 * Revision 1.1  93/03/14  16:52:07  etienne
 * Initial revision
 * 
*/

#include "type.h"
#include "main.h"
#include "var.h"
#include "land.h"
#include "sector.h"
#include "nation.h"

extern double upd_land_eff;
extern double upd_land_main;
extern long upd_totalmil;

bool UpdLandRepair(land, etus)
register Land land;
int etus;
{
	Sector sct;
	register int delta;
	int	wf;
	int	left;
	int	avail;
	int	w_p_eff;
	int mult;

	mult = 1;
	if (n_tech (nation) < ld_tech (land) * 0.85)
		mult = 2;

	upd_land_main += mult * etus *
		dmin (-1.0, money_land * landtypes [ld_type (land)]. cos);

	if (ld_eff (land) == 100)
		return True;

	sct = LandSector (land);

	left = 100 - ld_eff (land);
	wf = 0;

	if (s_des (sct) == '!' || s_des (sct) == 'f')
	{
		if (! s_owned (sct))
			return True;

		avail = wf + s_ava (sct) * 100;
	} 

	w_p_eff = 20 + (landtypes [ld_type (land)]. lcm +
			2 * landtypes [ld_type (land)]. hcm);

	delta = roundavg ((double) avail / w_p_eff);
	if (delta <= 0)
		return True;
	if (delta > etus)
		delta = etus;
	if (delta > left)
		delta = left;

	wf -= delta * w_p_eff;

	if (wf < 0)
	{
		avail = (s_owned (sct) ?  s_ava (sct) * 100 : 0 + wf) / 100;
		if (avail < 0)
			avail = 0;
		if (s_owned (sct))
			set_ava (sct, avail);
	}

	upd_land_eff -= mult * landtypes [ld_type (land)]. cos *
			delta / 100.0;

	inc_ld_eff (land, delta);

	return True;
}

static void UpdLand (land, landno, etus, strings)
register Land land;
int landno;
int etus;
Strings strings;
{
	Sector sct;
	int	max_food;
	struct	pchrstr *product;
	int	n;

	(void) UpdLandRepair (land, etus);

	if (ld_eff (land) < 10)
	{
		AddString (strings, 
			Fmt ("Lost %s #%d (eff < 20)",
				LandName (land), landno));
		DeleteLand (land);
		return;
	}

	if ((n = FeedLandPeople (land, etus, True)) > 0)
		AddString (strings,
			Fmt ("%d starved on %s #%d",
				n, LandName (land), landno));
	
	max_food = MaxLandCargo (land, 'f');
	if (ld_foo (land) > max_food)
		set_ld_foo (land, max_food);
		
		/*
		 *	XXX:	Xemp doesn't handle plagues
		 */
}

void UpdProdLand (realm, etus, strings)
char * realm;
int etus;
Strings strings;
{
	Land ptr;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_LANDS (ptr)
	{
		if (! ld_owned (ptr) ||
		    ld_xcd (ptr) < sx || ld_xcd (ptr) > ex ||
		    ld_ycd (ptr) < sy || ld_ycd (ptr) > ey)
			continue;

		UpdLand(ptr, ld_nr (ptr), etus, strings);
	}
}
