/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/ship/RCS/mine.c,v 5.1 93/03/14 16:51:36 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:36 $
    $Author: etienne $
    $Id: mine.c,v 5.1 93/03/14 16:51:36 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	mine.c,v $
 * Revision 5.1  93/03/14  16:51:36  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

#define DEF_MINES	10

static int last_quant = 0;

void Mine (what)
char * what;
{
	DoMine (what, 0);
}

void RedoMine ()
{
	if (last_layout == SHIP_MODE)
		DoMine (Fmt ("%d", sh_nr (curship)), last_quant);
	else if (last_layout == FLEET_MODE)
		DoMine (Fmt ("%c", curfleet), last_quant);
	else
	{
		Message ("No current ship/fleet selected");
		Bell ();
		return;
	}
}

	/* ARGSUSED */
void BindMine (x, y, str)
int x, y;
char * str;
{
	int quant;

	if (str != (char *) 0 && sscanf (str, " ( %d )", & quant) == 1)
		last_quant = quant;
	
	RedoMine ();
}

void DoMine (what, quant)
char * what;
int quant;
{
	char * ans;
	register Ship ptr;
	int nr, n;
	int total;

	if (s_des (cursct) != '.' && s_des (cursct) != '=')
	{
		Message ("You can't lay mines here!");
		Bell ();
		return;
	}

	UnmarkAllShips ();
	MarkShips (what);

	nr = 0;
	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			if (! sh_owned (ptr) || ! ShipHas (ptr, M_MINE) ||
						      sh_she (ptr) == 0)
				set_sh_marked (ptr, False);
			else
				nr ++;
		}

	if (nr == 0)
	{
		Message ("No selected ship with mine-capability / shells");
		Bell ();
		return;
	}

	if (quant <= 0)
	{
		ans = InputAtMessage (Fmt ("How many mines%s %s:",
				nr == 1 ? "" : " from each ship",
#ifndef lint
				DEF_MINES < 0 ? "" :
#endif
					Fmt ("[%d]", DEF_MINES)),
			3, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt ||
					(* ans == '\0' && DEF_MINES < 0))
		{
			Message ("mine cancelled");
			Bell ();
			return;
		}

		if (* ans == '\0')
			quant = DEF_MINES;
		else
			quant = atoi (ans);
	}

	SetAgain (RedoMine);
	last_quant = quant;
	
	if (quant == 0)
	{
		Message ("mine cancelled");
		Bell ();
		return;
	}

	total = 0;
	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			n = sh_she (ptr);
			if (n == 0)
				continue;

			if (n > quant)
				n = quant;
			
			total += n;
		}
	
	if (total == 0)
	{
		Message ("No mines layed");
		Bell ();
		return;
	}

	inc_mines (cursct, total);
	if (command_state < FORCE_BUF_STATE)
	{
		FeedEmpire (Fmt ("mine %s %d", what, quant), PRINT);
		(void) WaitForPrompt (PRINT);
	}
	else if (command_state == FORCE_BUF_STATE)
		FeedCommand (Fmt ("mine %s %d", what, quant), PRINT);

	Message (Fmt ("%d mines layed", total));
	Census ();
}
