/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/parse/RCS/symtab.h,v 5.1 93/03/14 16:50:54 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:54 $
    $Author: etienne $
    $Id: symtab.h,v 5.1 93/03/14 16:50:54 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	symtab.h,v $
 * Revision 5.1  93/03/14  16:50:54  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * symtab.h
 */

typedef struct _Symtab {
	char *name;
	int token;
	int type;
	int allowed_modifiers;
} SYMTAB, *Symtab;

extern SYMTAB special_chars_symtab[];
extern SYMTAB text_symtab[];

#define T_NONE		0x0000
#define T_NUMERIC	0x0001
#define T_BOOLEAN	0x0002
#define T_CHARACTER	0x0004
#define T_STRING	0x0008
#define T_SECTOR	0x0010
#define T_TOKEN		0x0020
#define T_PLAGUE	0x0040
#define T_HAPPY		0x0080

#define T_EVALUATE	(T_NUMERIC | T_BOOLEAN)


/*
 * Token modifier selection types
 */
#define MP_NONE		0x0000  /* Token has unequivocal meaning      */
#define MP_RESO		0x0001	/* Token has meaning within resource  */
#define MP_THRES	0x0002	/* Token has meaning within threshold */
#define MP_SSECT	0x0004	/* (start value)		      */
#define MP_SECT		0x0008	/* Token has meaning within sector    */
#define MP_SHIP		0x0010  /* Token has meaning within ships     */
#define MP_PLANE	0x0020  /* Token has meaning within planes    */
#define MP_NUKE		0x0040  /* Token has meaning within nukes     */
#define MP_LAND		0x0060  /* Token has meaning within landunits */

/* Commodities */
#define MP_COMM		(MP_RESO | MP_THRES | MP_SECT | MP_SHIP | MP_LAND)

#define MP_ALL		(MP_SECT | MP_SHIP | MP_PLANE | MP_NUKE | MP_LAND)
#define MP_ALLX		(MP_SECT | MP_SHIP | MP_PLANE | MP_LAND)	/* All except nukes */
