/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/scanshow.c,v 5.1 93/03/14 16:50:20 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:20 $
    $Author: etienne $
    $Id: scanshow.c,v 5.1 93/03/14 16:50:20 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	scanshow.c,v $
 * Revision 5.1  93/03/14  16:50:20  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nuke.h"

void FScanNukeShowBuild ()
{
	int namelen;
	char * line, * ptr, * name;
	int lcm, hcm, oil, rad, ava, tech, res, cost;
	int nr;

	FeedEmpire ("show nuke build", PRINT);
	MessageAtEmpire ("scanning nuke build data");

	nr = 0;
	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			set_nt_name (nr, (char *) 0);
			nr_nuke_types = nr;
			return;
		}

		if (line == (char *) 0)
			return;

		ptr = StrStr (line, "lcm hcm  oil  rad avail");
		if (ptr != (char *) 0)
		{
			namelen = ptr - line - 1;
			continue;
		}

		if (strlen (line) < namelen + 2)
		{
			PrintAtEmpire ("Strange line in show nuke build");
			PrintAtEmpire (line);
			continue;
		}

		if (land_units) {
			if (sscanf (line + namelen + 1, "%d %d %d %d %d %d %d $ %d", 
		      	& lcm, & hcm, & oil, & rad, & ava, & tech, &res, & cost) != 8)
			{
				PrintAtEmpire ("Strange line in show nuke build");
				PrintAtEmpire (line);
				continue;
			}
		} else {
			if (sscanf (line + namelen + 1, "%d %d %d %d %d %d $ %d", 
		      	& lcm, & hcm, & oil, & rad, & ava, & tech, & cost) != 7)
			{
				PrintAtEmpire ("Strange line in show nuke build");
				PrintAtEmpire (line);
				continue;
			}
		}

		set_nt_lcm (nr, lcm);
		set_nt_hcm (nr, hcm);
		set_nt_oil (nr, oil);
		set_nt_rad (nr, rad);
		set_nt_ava (nr, ava);
		set_nt_tech (nr, tech);
		set_nt_res (nr, res);
		set_nt_cost (nr, cost);

		name = doalloc ((unsigned) namelen + 1);
		ptr = line + namelen;
		while (* -- ptr == ' ' && ptr > line);
		(void) strncpy (name, line, ptr - line + 1);
		* (name + (ptr - line) + 1) = '\0';
		set_nt_name (nr, name);
		nr ++;
	}
}

void FScanNukeShowCap ()
{
	int nr;
	int index_i, ability_index;
	char * line, * ptr;
	int blst, dam, lbs, tech;
	char word [100];

	FeedEmpire ("show nuke cap", PRINT);
	MessageAtEmpire ("scanning nuke build data");
	nr = 0;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING)
		{
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			return;
		}

		if (line == (char *) 0)
			return;

		ptr = StrStr (line, "blst dam lbs tec");
		if (ptr != (char *) 0)
		{
			if (ksu_version)
			{
				index_i = ptr - line;
				ptr = StrStr (line, "abilities");

				if (ptr == (char *) 0)
				{
					PrintAtEmpire (Fmt 
						("show nuke cap: %s",
						"abilities not found"));
					EmpireMore ();
					return;
				}

				ability_index = ptr - line;
				continue;
			}
			else {
				index_i = ptr - line;
				continue;
			}

		}

		if (strlen (line) < index_i + 2)
		{
			PrintAtEmpire ("Strange line in show nuke cap");
			PrintAtEmpire (line);
			EmpireMore ();
			continue;
		}

		if (sscanf (line + index_i, "%d %d %d %d",
	 		& blst, & dam, & lbs, & tech) != 4)
		{
			PrintAtEmpire ("Strange line in show nuke cap");
			PrintAtEmpire (line);
			EmpireMore ();
			continue;
		}

		set_nt_blst (nr, blst);
		set_nt_dam (nr, dam);
		set_nt_lbs (nr, lbs);
		set_nt_tech (nr, tech);

		if (ksu_version)
		{
			ptr = line + ability_index;
			while (ScanWord (& ptr, word))
			{
				if (strcmp (word, "neutron") == 0)
					set_nt_abil (nr, NK_NEUTRON);
				else
				{
					PrintAtEmpire (Fmt (
						"unknown ability: %s",
						word));
					Bell ();
					EmpireMore ();
					continue;
				}
			}
		}

		nr ++;
	}
}
