/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/build.c,v 5.1 93/03/14 16:50:16 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:16 $
    $Author: etienne $
    $Id: build.c,v 5.1 93/03/14 16:50:16 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	build.c,v $
 * Revision 5.1  93/03/14  16:50:16  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nation.h"
#include "nuke.h"
#include "sector.h"

static int last_nukeid = -1;

void BuildNuke (x, y)
int x, y;
{
	DoBuildNuke (x, y, -1);
}

void RedoBuildNuke (x, y)
int x, y;
{
	DoBuildNuke (x, y, last_nukeid);
}

void DoBuildNuke (x, y, type)
int x, y;
int type;
{
	int nukenr;
	char * line, * answer, * ptr;

	if (! CheckOwnedCurSct ())
		return;
	
	if (s_des (cursct) != 'n' || s_eff (cursct) < 60)
	{
		Message ("you can only build nukes in 60+% nucl. plants");
		Bell ();
		return;
	}

	if (type == -1)
	{
		type = SelectNukeType (x, y, NK_BUILD);
		if (type < 0)
			return;
	}

	if (! BuildCheckCommodity ('l', nt_lcm (type), nt_name (type)) ||
	    ! BuildCheckCommodity ('h', nt_hcm (type), nt_name (type)) ||
	    ! BuildCheckCommodity ('o', nt_oil (type), nt_name (type)) ||
	    ! BuildCheckCommodity ('r', nt_oil (type), nt_name (type)) ||
	    ! BuildCheckAvailable (nt_ava (type), nt_name (type)))
		return;
	

	FeedEmpire (Fmt ("build nuke %s", CrdStr (cursct)), PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () != E_QUESTION)
	{
		Message ("build nuke failed!");
		Bell ();
		return;
	}

	nukenr = -1;
	FeedEmpire (nt_name (type), PRINT);
	for (;;)
	{
		line = ReadEmpire (PRINT);

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);
			Bell ();
			answer = InputAtMessage (line, 10, GS_NAME);

			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Build cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}

			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (line);
			Message ("Build failed");
			Bell ();
			return;
		}

		ptr = index (line, '#');
		if (ptr == (char *) 0)
			continue;
		
		ptr ++;
		if (ScanDigit (& ptr, & nukenr))
			break;
	}

	(void) WaitForPrompt (PRINT);
	SetAgain (RedoBuildNuke);
	last_nukeid = type;

	if (nukenr == -1)
	{
		Message ("Couldn't find nuke number, rescan them all!");
		Bell ();
		return;
	}
	
	FScanNukes (Fmt ("%d", nukenr), PRINT);
	CensusNuke (s_stock (cursct));
}
