/*
	$Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/work.c,v 5.1 93/03/14 16:48:43 etienne Exp Locker: etienne $
	$Date: 93/03/14 16:48:43 $
	$Author: etienne $
	$Id: work.c,v 5.1 93/03/14 16:48:43 etienne Exp Locker: etienne $
	$Locker: etienne $
	$Log:	work.c,v $
 * Revision 5.1  93/03/14  16:48:43  etienne
 * initial rel. 
 * engineers working
 * 
 * Revision 5.0  93/02/09  21:41:26  etienne
 * initial rev.
 * 
*/

#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

static int last_work = 0;

#define DEF_WORK 60

void Work (what)
char * what;
{
	DoWork (what, 0);
}

void RedoWork ()
{
	if (last_layout == LAND_MODE)
		DoWork (Fmt ("%d", ld_nr (curland)), last_work);
	else if (last_layout == ARMY_MODE)
		DoWork (Fmt ("%c", curarmy), last_work);
	else
	{
		Message ("No current land/army selected");
		Bell ();
		return;
	}
}

	/* ARGSUSED */
void BindWork (x, y, str)
int x, y;
char * str;
{
	int work;

	if (str != (char *) 0 && sscanf (str, " ( %d )", & work) == 1)
		last_work = work;
	
	RedoWork ();
}

DoWork (what, work)
char * what;
int work;
{
	char * ans;
	register Land ptr;
	int nr, n;
	int total;

	if (s_des (cursct) == '.')
	{
		Message ("You can't work here!");
		Bell ();
		return;
	}

	UnmarkAllLands ();
	MarkLands (what);

	nr = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			if (! ld_owned (ptr) || ! LandHas (ptr, L_ENGINEER) ||
						      ld_mob (ptr) == 0)
				set_ld_marked (ptr, False);
			else
				nr ++;
		}

	if (nr == 0)
	{
		Message ("No selected units with work-cap / mobility");
		Bell ();
		return;
	}

	if (work <= 0)
	{
		ans = InputAtMessage (Fmt ("How many work%s %s:",
				nr == 1 ? "" : " from each unit",
#ifndef lint
				DEF_WORK < 0 ? "" :
#endif
					Fmt ("[%d]", DEF_WORK)),
			3, GS_PNUMBER);

		if (ans == (char *) 0 || interrupt ||
					(* ans == '\0' && DEF_WORK < 0))
		{
			Message ("work cancelled");
			Bell ();
			return;
		}

		if (* ans == '\0')
			work = DEF_WORK;
		else
			work = atoi (ans);
	}

	SetAgain (RedoWork);
	last_work = work;
	
	if (work == 0)
	{
		Message ("work cancelled");
		Bell ();
		return;
	}

	total = 0;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			n = ld_mob (ptr);
			if (n == 0)
				continue;

			if (n > work)
				n = work;
			
			total += n;
		}
	
	if (total == 0)
	{
		Message ("No work done");
		Bell ();
		return;
	}

	/* inc_mines (cursct, total); */ /* to be replaced with work */
	if (command_state < FORCE_BUF_STATE)
	{
		FeedEmpire (Fmt ("work %s %d", what, work), PRINT);
		(void) WaitForPrompt (PRINT);
	}
	else if (command_state == FORCE_BUF_STATE)
		FeedCommand (Fmt ("work %s %d", what, work), PRINT);

	Message (Fmt ("%d work done", total));
	Census ();
}
