/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/landbuild.c,v 5.1 93/03/14 16:47:22 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:47:22 $
    $Author: etienne $
    $Id: landbuild.c,v 5.1 93/03/14 16:47:22 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	landbuild.c,v $
 * Revision 5.1  93/03/14  16:47:22  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"
#include "nation.h"

static int last_landid, last_techn;
void RedoBuildLand ();

void DoBuildLand (x, y, landid, techn)
int x, y;
int landid, techn;
{
	Strings strings;
	Pager pager;
	char * ptri, * err;
	char * line, * answer;
	int newlandnr;
	int maint;

	if (! s_owned (cursct) || s_des (cursct) != '!' || s_eff (cursct) < 60)
	{
		Message ("You can only build units in +60% headquarters !");
		Bell ();
		return;
	}

	if (s_ava (cursct) < 1)
	{
		Message ("No available workers !");
		Bell ();
		return;
	}

	if (landid < 0)
	{
		strings = InitStrings ();

		for (landid = 0; landtypes [landid]. nam != (char *) 0;
								landid ++)
			if (landtypes [landid]. tec <= (int) n_tech (nation))
			{
					/* Cost to maintain this land */
					/* Of course no multiplier     */

				maint = (int) (etu_per_update * - dmin (-1.0,
				     landtypes [landid]. cos * money_land));

				AddStringID (strings, Fmt (
		   "%-17.17s %3d tech %2d lcm %2d hcm %3d mil %2d gun %2d shell %3d ava $%-4d ($%d)",
					landtypes [landid]. nam,
					landtypes [landid]. tec,
					landtypes [landid]. lcm,
					landtypes [landid]. hcm,
					landtypes [landid]. mil,
					landtypes [landid]. guns,
					landtypes [landid]. shells,
					landtypes [landid]. ava,
					landtypes [landid]. cos,
					maint), landid);
			}

		if (StringsSize (strings) == 0)
		{
			Message ("You can't build any units");
			Bell ();
			return;
		}

		pager = InitPager (strings, "Build which unit ?");
		MapPagerFromTop (pager, map_win, x, y);
		landid = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);

		if (landid < 0 || interrupt)
		{
			interrupt = False;
			ClearMes ();
			return;
		}
	}

	err = (char *) 0;

	if (landtypes [landid]. ava > s_ava (cursct))
		err = Fmt ("not enough available workers (need %d)",
			landtypes [landid]. ava);

	if (landtypes [landid]. lcm > (q_lcm (cursct)*10))
		err = Fmt ("not enough light constr. materials (need %d)",
			landtypes [landid]. lcm);;

	if (landtypes [landid]. hcm > (q_hcm (cursct)*10))
		err = Fmt ("not enough heavy constr. materials (need %d)",
			landtypes [landid]. hcm);

	if (landtypes [landid]. mil > (s_mil (cursct)*10))
		err = Fmt ("not enough military (need %d)",
			landtypes [landid]. mil);

	if (landtypes [landid]. guns > (q_gun (cursct)*10))
		err = Fmt ("not enough guns (need %d)",
			landtypes [landid]. guns);

	if (landtypes [landid]. shells > (q_she (cursct)*10))
		err = Fmt ("not enough shells (need %d)",
			landtypes [landid]. shells);

	if (landtypes [landid]. cos / 10 > (n_treas (nation)*5))
		err = Fmt ("not enough money (need $%d)",
			(int) landtypes [landid]. cos / 10);

	if (err != (char *) 0)
	{
		Message (err);
		Bell ();
		return;
	}

	FeedEmpire (Fmt ("build land %s", CrdStr (cursct)), PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () != E_QUESTION)
	{
		Message ("Build failed");
		Bell ();
		return;
	}

	FeedEmpire (Fmt ("%s", landtypes [landid]. nam), PRINT);

	for (;;)
	{
		line = ReadEmpire (PRINT);

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);
			Bell ();

			if (strncmp (line, "Build at what tech", 18) == 0)
			{
			    if (techn < 0)
			    {
				Bell ();
			    	answer = InputAtMessage (line, 5, GS_PNUMBER);

				if (answer == (char *) 0 || interrupt)
				{
					while (EmpireStatus () != E_COMMAND)
					{
						FeedEmpire ("aborted", PRINT);
						(void) WaitForPrompt (PRINT);
					}

					Message ("Build land aborted");
					return;
				}

				if (* answer == '\0' || atoi (answer) >
							(int) n_tech (nation))
				     answer = Fmt ("%d", (int) n_tech (nation));
				     
				techn = atoi (answer);
			    }
			    else
				answer = Fmt ("%d", techn);
			}
			else
			    answer = InputAtMessage (line, 10, GS_NAME);

			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Build cancelled");
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				return;
			}
			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (line);
			Message ("Build failed");
			Bell ();
			return;
		}

		ptri = index (line, '#');

		if (ptri != (char *) 0)
		{
			ptri++;

			if (!ScanDigit (&ptri, &newlandnr))
				/* No digit ignore it */
				continue;

			SkipBlank (&ptri);

			if (strncmp (ptri, "built in sector", 15) != 0)
				/* No build ignore it */
				continue;

			break;
		}
	}

		/* Get new land, just scan it */

	(void) WaitForPrompt (PRINT);
	last_techn = techn;
	last_landid = landid;
	SetAgain (RedoBuildLand);

	if (FScanLand (Fmt ("%d", newlandnr), DONT_PRINT) == 0)
	{
		Bell ();
		PrintAtEmpire ("Can't find your new landunit !!");
		(void) WaitForPrompt (DONT_PRINT);
		return;
	}

	(void) WaitForPrompt (DONT_PRINT);

	curland = NrToLand (newlandnr);

	Message (Fmt ("A new %s is built (at tech %d)",
		landtypes [landid]. nam,
		ld_tech (curland)));

		/* Adjust materials & available workers */
	
	RedumpSector (cursct, DONT_PRINT);

	CensusLand (curland);

	if ((landtypes [landid]. cos / 10) <= 100)
		n_treas (nation) -= (double) (landtypes [landid]. cos / 10);
}

void BuildLand (x, y)
int x, y;
{
	DoBuildLand (x, y, -1, -1);
}

void RedoBuildLand (x, y)
int x, y;
{
	DoBuildLand (x, y, last_landid, last_techn);
}
