/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/deity/RCS/nation.c,v 5.1 93/03/14 16:47:00 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:47:00 $
    $Author: etienne $
    $Id: nation.c,v 5.1 93/03/14 16:47:00 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	nation.c,v $
 * Revision 5.1  93/03/14  16:47:00  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:41  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:36:22  greyhelm
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "func.h"

static char * fname = "misc/nation.c";

WinInfo nation_win;
extern WinInfo root_win;
Nation nation;
char *natnames [MAX_NATIONS];

char *cname;
char *pname;
char *uname;
int my_cnum = UNKNOWN_CNUM;
int capitol_x = 0, capitol_y = 0;

void InitNation ()
{
	nation = (Nation) doalloc (sizeof (struct s_nation));
}

void AddCountry (nr, name)
int nr;
char *name;
{
	extern char *Str ();

	if (nr >= MAX_NATIONS)
	{
		fprintf (stderr, "Nation Number to big (> %d)\n", MAX_NATIONS);
	  fprintf (stderr, "Using nation number 99 instead.");
	  /*		leave ();  */
	  return;
	}

	if (natnames[nr] != (char *) 0)
		if (strcmp (natnames[nr], name) != 0)
			/* Somebody changed it's name */
			free (natnames[nr]);
		else
			return;

	natnames[nr] = Str (name);
}

int NatCmp (nat1, nat2)
char ** nat1, ** nat2;
{
	printf ("Comparing '%s' met '%s'\n", * nat1, * nat2);

	if (* nat1 == (char *) 0 && * nat2 == (char *) 0)
		return 0;
	
	if (* nat1 == (char *) 0)
		return 1;

	if (* nat2 == (char *) 0)
		return -1;

	return strcmp (* nat1, * nat2);
}

void FindMyCnum ()
{
	int i, found;

	for (i = 0; i < MAX_NATIONS; i ++)
		natnames [i] = (char *) 0;

	FScanReport ("*");

	for (i = 1; i < MAX_NATIONS; i++) 
		if (natnames[i] != (char *) 0)
		{
			FScanRelations (i);

			found = 0;
			for (i = 0; i < MAX_NATIONS; i++) 
				if (natnames[i] != (char *) 0)
					if (strcmp (natnames[i], cname) == 0)
					{
						found = 1;
						my_cnum = i;
					}

			if (!found)
			{
				/* must be country 0 , assume it anyway */
PrintAtEmpire ("Cannot locate your country number assuming you are country 0");
				my_cnum = 0;
			}
				
			/*
			 
			qsort (natnames, MAX_NATIONS, sizeof (char *), NatCmp);

			*/
			return;
		}
	
	fprintf (stderr, "Can't find other active country\n");
	leave ();
}

char *CountryName (nr)
int nr;
{
	if (nr < 0)
		return ("Unknown");

	if (natnames[nr] == (char *) 0)
		return (Fmt ("Own #%d", nr));

	return (natnames[nr]);
}

bool ExistCountry (nr)
int nr;
{
	if (nr < 0)
		return False;
	else
		return (natnames[nr] != (char *) 0);
}

int CountryId (name)
char *name;
{
	int i, alen, blen;
	
	alen = strlen (name);
	for (i = 0; i < MAX_NATIONS; i++) 
		if (natnames[i] != (char *) 0) {
			blen = strlen (natnames[i]);
			if (! strncmp (name, natnames[i],
					alen < blen ? alen : blen))
				return (i);
		}
	
	return (UNKNOWN_CNUM);
}

void SaveCountries (fp)
FILE *fp;
{
	int i;

	for (i = 0; i < MAX_NATIONS; i++) 
		if (natnames[i] != (char *) 0)
			fprintf (fp, "%d %s\n", i, natnames[i]);
	
	fprintf (fp, "END OF COUNTRY LIST\n");
}

void RestoreCountries (fp)
FILE *fp;
{
	char buffer [BUFSIZ];
	int nr;
	char *ptr;
	extern char *cname;
	int i;

	for (i = 0; i < MAX_NATIONS; i ++)
		natnames [i] = (char *) 0;

	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (strncmp (buffer, "END OF COUNTRY LIST", 19) == 0)
			return;

		buffer [strlen (buffer) - 1] = '\0';	/* no newline */
		ptr = buffer;

		if (!ScanDigit (&ptr, &nr))
		{
fprintf (stderr, "Bad line in country section of savefile\"%s\"\n", buffer);
			continue;
		}

		AddCountry (nr, ++ptr);

		if (strcmp (ptr, cname) == 0)
			my_cnum = nr;
	}
}

char *AskCountry (x, y, quest, allow_own)
int x, y;
char *quest;
bool allow_own;
{
	Strings strings;
	Pager pager;
	int nr, i;

	strings = InitStrings ();
	for (nr = 0; nr < MAX_NATIONS; nr ++)
		if ((nr != my_cnum || allow_own) && natnames [nr] != (char *) 0)
			AddSortStringID (strings, natnames [nr], nr);

	if (StringsSize (strings) == 0)
		return (char *) 0;

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
		return (char *) 0;
	else
		return natnames [i];
}

void ShowNation ()
{
	Strings strings;

	strings = InitStrings ();
	
	AddString (strings,
		Fmt ("Treasury:    %8s     Militairy Res:     %5d",
			Fmt ("$%.0f", n_treas (nation)), n_mil_res (nation)));
	AddString (strings,
		Fmt ("Education:    %7s     Happiness:       %7s",
			Fmt ("%.2f", n_educ (nation)),
			Fmt ("%.2f", n_hap (nation))));
	AddString (strings,
		Fmt ("Technology:   %7s     Research:        %7s",
			Fmt ("%.2f", n_tech (nation)),
			Fmt ("%.2f", n_research (nation))));
	AddString (strings,
		Fmt ("Tech. factor:  %6s%%    Plague factor:    %6s%%",
			Fmt ("%.2f", n_tech_fact (nation)),
			Fmt ("%.2f", n_plag_fact (nation))));
	
#ifdef X_VERSION
	InitWMPager (strings, "nation");
#else
	ShowStringsInPager (strings, "nation");
#endif /* X_VERSION */
}

double GiveNatLevel (id)
int id;
{
	switch (id)
	{

	case NAT_RLEV:
		return n_research (nation);

	case NAT_TLEV:
		return n_tech (nation);
	
	case NAT_HLEV:
		return n_hap (nation);

	case NAT_ELEV:
		return n_educ (nation);

	default:
		Panic ("GiveNatLevel", fname, 
			Fmt ("Illegal level-id: %d", id));
		return 0.0;
	}
}

void NationSetRealm (realmnr, realm)
int realmnr;
char * realm;
{
	(void) strcpy (nation-> realm [realmnr], realm);
}
