/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/multi.c,v 5.1 93/03/14 16:46:14 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:46:14 $
    $Author: etienne $
    $Id: multi.c,v 5.1 93/03/14 16:46:14 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	multi.c,v $
 * Revision 5.1  93/03/14  16:46:14  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "func.h"
#include "parser.h"

#define		MC_CONVERT	0
#define		MC_DELIVER	1
#define		MC_DEMOBILIZE	2
#define		MC_DESIGNATE	3
#define		MC_ENLIST	4
#define 	MC_MAKEMAP	5
#define		MC_RUNPROG	6
#define		MC_SCRAP	7
#define		MC_SETCUT	8
#define		MC_SETTHR	9
#define 	MC_SETREALM	10
#define		MC_SHOOT	11
#define		MC_SPY		12
#define		MC_TERRIT	13
#define		MC_WIPE		14
#define		MC_CHANGEOWNER	15


#define		MC_MAX		16

static char * mul_comm [] =
{
	"convert",
	"deliver",
	"demobilize",
	"designate",
	"enlist",
	"make map",
	"run program",
	"scrap",
	"set cutoff",
	"set threshold",
	"set realm",
	"shoot",
	"spy",
	"territory",
	"wipe threshold",
	"change owner",
	(char *) 0
};

	/* ARGSUSED */
void MultiCommand (x, y, quest, comname, def, proc, ch)
int x, y;
char * quest, * comname;
int def;
void (* proc) ();
char ch;
{
	char * ans, * realm;
	int quant;

	ans = InputAtMessage (Fmt ("%s%s:", quest,
		(def < 0) ? "" : Fmt (" [%d]", def)), 4,  GS_NUMBER);

	if (ans == (char *) 0 || interrupt || (* ans == '\0' && def < 0))
	{
		interrupt = False;
		Message (Fmt ("Multi %s cancelled", comname));
		return;
	}

	if (* ans == '\0')
		quant = def;
	else
		quant = atoi (ans);

	MesBut ("View", "Do", "Cancel");

	do
	{
		Message (Fmt ("Command: %s %d", comname, quant));
		realm = MySelRealm ();
		if (realm != (char *) 0)
			(* proc) (realm, quant, ch);
	}
	while (realm != (char *) 0);
	
	Message (Fmt ("Multi %s ended", comname));
}

void MultiSpy ()
{
	char * realm;

	Message ("Select realm to spy at");
	while ((realm = MySelRealm ()) != (char *) 0)
		FScanSpy (realm);
	ClearMes ();
}
		
void SetRealm (x, y)
int x, y;
{
	Pager pager;
	Strings strings;
	char *realm;
	int i;

	strings = InitStrings ();
	for (i = 0; i < nr_realms; i++)
		AddStringID (strings,
			Fmt ("%-2d) %s", i, nation-> realm [i]), i);

	pager = InitPager (strings, "Change which realm ?");
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
	{
		Message ("Set realm cancelled");
		return;
	}

	realm = MySelRealm ();

	if (realm == (char *) 0)
	{
		Message ("Change realm cancelled");
		return;
	}

	FeedCommand (Fmt ("realm %d %s", i, realm), PRINT);
	(void) strcpy (nation-> realm [i], realm);
	Message (Fmt ("realm %d set", i));
}

void MultiProg (px, py)
int px, py;
{
	char * ans;
	Program program;
	Strings strings;
	Pager pager;
	int i;
	int sx, sy, ex, ey, x, y;
	char * realm;
	Sector sct;
	Strings outp_str, send_str;
	bool aborted;

	program = SelectProgram (px + 1, py + 1);
	if (program == (Program) 0)
		return;

	/*

	ans = InputAtMessage ("Load program from: ", 20, GS_TEXT);
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Nothing run");
		return;
	}

	if (* ans == '\0')
	{
		strings = EditStrings (80, 25);

		pager = InitPager (strings, "Enter your program");
		AddPagerFunc (pager, "Write", WRITEFUNC);
		AddPagerFunc (pager, "Read", READFUNC);
		AddPagerFunc (pager, "Run", DONEFUNC);
		AddPagerFunc (pager, "Compile", COMPILEFUNC);
		AddPagerFunc (pager, "Cancel", CANCEL);
		MapPagerFromTop (pager, map_win, px, py);

		for (;;)
		{
			i = EditPager (pager);

			if (i == COMPILEFUNC || i == DONEFUNC)
			{
				program = ParseProgram (strings);
				if (program != (Program) 0)
				{
					Message ("Program OK");
					if (i == DONEFUNC)
						break;

					DestroyProgram (& program);
				}
				continue;
			}

			if (i == CANCELFUNC || i == CANCEL || i == CANCELALL)
			{
				FreePager (pager);
				FreeStrings (strings);
				Message ("Program Cancelled");
				return;
			}

			break;
		}

		FreePager (pager);
	}
	else
	{
		strings = InitStrings ();
		if (! LoadStrings (strings, ans))
			return;
		program = ParseProgram (strings);
		if (program == (Program) 0)
		{
			Message ("Couldn't compile program.");
			return;
		}
	}

	*/

	Message ("Select realm to run the program at");

	for (;;)
	{
		realm = MySelRealm ();

		if (realm == (char *) 0)
		{
			ClearMes ();
			MesClearBut ();
			DestroyProgram (& program);
			return;
		}

		if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
		{
			Message ("Illegal realm specified");	/* HE */
			Bell ();
			continue;
		}

		send_str = InitStrings ();
		outp_str = InitStrings ();

		aborted = False;
		for (y = sy; y <= ey && ! aborted; y ++)
			for (x = sx; x <= ex && ! aborted; x ++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0)
					continue;
				
				if (RunProgram (sct, program, outp_str,
					send_str) != P_OK)
							aborted = True;
			}

		if (aborted)
		{
			Bell ();
			Message ("Program aborted");
		}

		if (StringsSize (outp_str) > 0)
#ifdef TERMC_VERSION
			ShowStringsInPager (outp_str, "Output of program");
#else /* TERMC_VERSION */
			InitWMPager (outp_str, "Output of program");
#endif /* TERMC_VERSION */

		if (StringsSize (send_str) > 0)
			AddMail (send_str, Fmt ("=== Output of prog '%s' (%s)",
					* ans == '\0' ? "stdin" : ans,
					DateFmt (time ((time_t *) 0))));

		FreeStrings (send_str);
	}
}

void DoMakeMap (x, y)
int x, y;
{
	char * name;
	char * realm;
	int sx, sy, ex, ey, flag;

	flag = GetSaveMode (x, y);

	if (flag < 0)
		return;

	realm = MySelRealm ();
	if (realm == (char *) 0)
		return;
	
	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	do
	{
		name = InputAtMessage ("Filename :", 50, GS_TEXT);

		if (interrupt || name == (char *) 0 || *name == '\0')
		{
			interrupt = False;
			return;
		}
	}
	while (! SaveMap (name, flag, sx, ex, sy, ey));
	return;
}


		
void Multi (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, mul_comm, MC_MAX, 0);

	pager = InitPager (strings, "Which command ?");
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	if (i < 0 || interrupt)
	{
		interrupt = False;
		return;
	}

	RaiseAll ();

	switch (i)
	{

	case MC_CONVERT:
		MultiConvert (x + 2, y + 2);
		break;

	case MC_RUNPROG:
		MultiProg (x + 2, y + 2);
		break;

	case MC_ENLIST:
		MultiEnlist (x + 2, y + 2);
		break;
	
	case MC_DEMOBILIZE:
		MultiDemob (x + 2, y + 2);
		break;

	case MC_SETTHR:
		MultiThreshold (x + 2, y + 2);
		break;

	case MC_SPY:
		MultiSpy ();
		break;

	case MC_SETREALM:
		SetRealm (x + 2, y + 2);
		break;

	case MC_MAKEMAP:
		DoMakeMap (x + 2, y + 2);
		break;

	case MC_WIPE:
		MultiWipe ();
		break;

	case MC_TERRIT:
		MultiTerri ();
		break;

	case MC_DESIGNATE:
		MultiDesignate (x + 2, y + 2);
		break;

	case MC_CHANGEOWNER:
		MultiChangeOwner ();
		break;
	}

	LowerAll ();
}
