/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/mfire.c,v 5.1 93/03/14 16:45:47 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:45:47 $
    $Author: etienne $
    $Id: mfire.c,v 5.1 93/03/14 16:45:47 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	mfire.c,v $
 * Revision 5.1  93/03/14  16:45:47  etienne
 * initial release. should be completly rewritten.
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/

/* support for multifire (chainsaw > 2.1) 
 * etienne 18 Nov 1992
 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "nation.h"

static char * last_target = (char *) 0;

void MFireFromFleet (fleet)
char * fleet;
{
	int nr;
	int range;
	Ship ptr;
	char buffer [1024];
	bool first;

	UnmarkAllShips ();
	MarkShips (fleet);

	nr = 0;
	for ALL_SHIPS (ptr)
		if (sh_marked(ptr))
		{
			if ( ! sh_owned (ptr) || sh_eff (ptr) < 60 || sh_she (ptr) == 0 || sh_gun (ptr) == 0 || sh_mil (ptr) == 0 )
				set_sh_marked (ptr, False);
			else
				nr++;
		}
	if (nr == 0)
	{
		Message ("No selected ships with enough mil/gun/shell/eff");
		Bell ();
		return;
	}

	range = -1;

	buffer [0] = '\0';
	first = True;

	for ALL_SHIPS (ptr)
		if (sh_marked(ptr)) {
			if (first) {
				first = False;
				strcat (buffer, Fmt ("%d", sh_nr (ptr)));
			} else
				strcat (buffer, Fmt ("/%d", sh_nr (ptr)));

		if (ShipFireRange (ptr) > range)
			range = ShipFireRange (ptr);
		}
		if (first)
			return;

	Message(Fmt ("Would fire with ships: %s max range : %d",buffer,range));
	Bell ();
	return;



/*	DoMFireFromFleet ((char *) 0, -1); */
}

#ifdef BLABBER
void RedoMFireFromFleet ()
{
	DoMFireFromFleet (last_target);
}

void DoMFireFromFleet (target)
char * target;
{
	Ship from_ship;
	Sector from_sct;
	char * ans;

	int shells;
	double range;

	char * mes;
	bool dept;

	from_ship = curship;
	from_sct = cursct;

	if (from_ship == (Ship) 0)
	{
			/* set current, again, no ship ? */
		Message ("Ship-fire without a ship ?");
		Bell ();
		return;
	}

	if (! sh_owned (from_ship))
	{
		Message ("You don't own that ship !");
		Bell ();
		return;
	}

	mes = (char *) 0;

	if (sh_eff (from_ship) < 60)
		mes = "Ship is crippled";

	shells = sh_she (from_ship);
	if (shells == 0)
		mes = "Klick, no more shells";

	if (sh_gun (from_ship) == 0)
		mes = "No guns";

	if (sh_mil (from_ship) == 0)
		mes = "No mils to fire !";

	nr_guns = ShipMaxGuns (from_ship);

	range = ShipFireRange (from_ship);

	if (nr_guns == 0 || range == 0.0)
		mes = Fmt ("You can't fire from a %s", ShipName (from_ship));

	if (mes != (char *) 0)
	{
		Message (mes);
		Bell ();
		return;
	}

	dept = ShipHas (from_ship, M_DCHRG);

	if (target == (char *) 0)
		target = SelectTarget (sh_xcd (from_ship), sh_ycd (from_ship),
					(int) range, & dept, False);
	
	if (target == (char *) 0)
	{
		Message ("fire cancelled");
		return;
	}

	if (dept)
	{
		if (shells < 2)
		{
			Message ("You need two shells for a deptcharge");
			Bell ();
			return;
		}

		guns = 2;
	}
	else
	{
		if (shells < nr_guns)
		{
			Message (Fmt ("Only %d shell%s left"),
				shells, 
				shells > 1 ? "s" : "");
			Bell ();
			nr_guns = shells;
		}

		if (nr_guns == 1)
			guns = 1;
		else
		{
			if (guns <= 0)
			{
				ans = InputAtMessage (Fmt (
						"Fire how many guns [%d]:",
						nr_guns), 2, GS_PNUMBER);

				if (ans == (char *) 0 || interrupt)
				{
					Message ("Fire cancelled");
					return;
				}

				if (* ans == '\0')
					guns = nr_guns;
				else
				{
					guns = atoi (ans);
					if (guns > nr_guns)
					{
						Bell ();
						guns = nr_guns;
					}
				}
			}
		}
	}

	if (guns == 0)
	{
		Message ("Fire cancelled");
		return;
	}

	if (target == (char *) 0)
		return;
		
	if (last_target != (char *) 0)
		free (last_target);

	last_target = Str (target);
	last_guns = guns;

	SetAgain (RedoFireFromShip);

	FeedEmpire (Fmt ("fire ship %s %d ",
			sh_nr (from_ship),
			target),
		PRINT);

	set_sh_she (from_ship, sh_she (from_ship) - guns);
	ParseFireOutput ((Sector) 0, curship);

	cursct = from_sct;
	curship = from_ship;
	CensusShip (curship);
}
#endif
