/*
	$Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/load.c,v 1.1 93/03/14 16:45:01 etienne Exp Locker: etienne $
	$Date: 93/03/14 16:45:01 $
	$Author: etienne $
	$Id: load.c,v 1.1 93/03/14 16:45:01 etienne Exp Locker: etienne $
	$Locker: etienne $
	$Log:	load.c,v $
 * Revision 1.1  93/03/14  16:45:01  etienne
 * Initial revision
 * 
*/

#include <main.h>
#include <version.h>
#include <sector.h>
#include <land.h>
#include <ship.h>
#include <plane.h>

void LLoadXPlane (land)
Land land;
{
	fprintf(stderr,"LLoadXPlane\n");
	return; /* TODO */
}

void LandToShip (landnr)
char *landnr;
{
	char * ptr, * ptri, * line, * shipnr;
	int lnd, shp;
	Land land;
	Ship ship;

	UnmarkAllLands ();
	MarkLands (landnr);

	for ALL_LANDS (land)
		if (ld_marked (land) && !PortableLand (land)) {
			Message ("Army has heavy units ! No units loaded");
			Bell ();
			UnmarkAllLands ();
			return;
		}

	for ALL_LANDS (land)
		if (ld_marked (land) && ld_shipnr (land) > 0) {
			FeedEmpire (Fmt ("unload %d %s land", ld_shipnr (land), landnr), PRINT);
			WaitForPrompt (PRINT);
			ship = NrToShip (ld_shipnr (land));
			set_ld_shipnr (land, -1);
			set_sh_land (ship, (sh_land (ship) - 1));
			return;
		}
		

 	ship = SelectOneShip (10,10, ST_LOADLAND, "Load onto wich ship ?");

	if (ship == (char *) 0)
		return;

	FeedEmpire (Fmt ("load %d %s land", sh_nr (ship), landnr),  PRINT);
	(void) SkipNLines (1, DONT_PRINT);

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (EmpireStatus () != E_PRINTING) {
			PrintAtEmpire ("");
			PrintAtEmpire (line);
			Bell ();
			return;
		}

		ptri = index (line, '#');

		if (ptri == (char *) 0)
			return;

		if (sscanf (ptri,"#%d loaded onto ship #%d", & lnd , & shp) != 2) {
			Message ("Loading failed !");
			Bell ();
			return;
		}
		land = NrToLand (lnd);
		ship = NrToShip (shp);
		set_ld_shipnr (land, shp);
		set_sh_land (ship, sh_land (ship) + 1);
	}
}

void PlaneToShip (planenr)
char *planenr;
{
	fprintf(stderr, "PlaneToShip: plane %s\n", planenr);
	return;
}

void SLoadPlane (ship, mission)
Ship ship;
Mission mission;
{
	char * planes;

	if (s_pla (cursct) <= 0) {
		Message ("No planes in this sector");
		Bell ();
		return;
	}

	UnmarkAllPlanes ();
	planes = SelectPlanes (10,10, cursct, mission, "Load which planes ?");

	if (planes == (char *) 0) {
		Message ("Load aborted");
		return;
	}

	if ((char) planes == '.')
		return;

	FeedEmpire ( Fmt ("load %d %s plane", sh_nr (ship), planes));
	return;
	
}

void SLoadXPlane (ship)
Ship ship;
{
	fprintf(stderr, "SLoadXPlane %d\n", sh_nr (ship));
	return;
}

void SLoadHeli (ship)
Ship ship;
{
	fprintf(stderr, "SLoadHeli %d\n", sh_nr (ship));
	return;
}

void SLoadLand (ship)
Ship ship;
{
	char * lands;
	int maxlnd;

	maxlnd = (shiptypes [ sh_type(ship)]. land - sh_land (ship));
	MarkLands (cursct);
	lands = SelectLands (10,10, LD_LANDTOSHIP, Fmt ("Load which units ? (max : %d)", maxlnd));

	if (lands == (char *) 0)
		return;

	FeedCommand (Fmt ("load %d %s land", sh_nr (ship), lands), PRINT);

	/* TODO, scanning of loading lands */

	return;
}

