/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/commands/RCS/distri.c,v 5.1 93/03/14 16:44:24 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:44:24 $
    $Author: etienne $
    $Id: distri.c,v 5.1 93/03/14 16:44:24 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	distri.c,v $
 * Revision 5.1  93/03/14  16:44:24  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:18:04  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:32:23  greyhelm
 * Client for ASCII /X Empire client
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "slist.h"

void MarkPath (start, path)
Sector start;
char *path;
{
	Sector sct;

	sct = start;
	MarkSector (sct);
	while (*path != 'h' && *path != '_' && *path != '\0')
	{
		sct = MoveInDirection (sct, * path, S_DESIG);
		MarkSector (sct);
		path ++;
	}
}

void UnmarkPath (start, path)
Sector start;
char *path;
{
	Sector sct, nextsct;

	sct = start;
	UnmarkSector (sct);
	while (*path != 'h' && *path != '_' && *path != '\0')
	{
		nextsct = MoveInDirection (sct, *path, S_DESIG);
		if (NO_INFO (sct) && s_mar (sct) == 0)
			FreeSector (sct);
		sct = nextsct;
		UnmarkSector (sct);
		path ++;
	}
	if (NO_INFO (sct) && s_mar (sct) == 0)
		FreeSector (sct);
}

#define	DB_MAXEFF	0
#define	DB_CUREFF	1
#define DB_DELETE	2

static char *distrib_modes [] =
{
	"100 % efficient & new designation",
	"current efficiency & designation",
	"delete",
	(char *) 0
};

static int GetDistributeMode (x, y, n)
int x, y, n;
{
	Strings strings;
	Pager pager;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, distrib_modes, n, 0);
	pager = InitPager (strings, "Assume ?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreeStrings (strings);
	FreePager (pager);

	return i;
}

bool ExecSetDistr (sct, to, mode, show, isrealm)
Sector sct ,to;
int mode;
bool show;
bool isrealm;
{
	char * path;

	path = (mode == DB_CUREFF) ?
		BestTmpDistPath (sct, to) :
		BestDistPath (sct, to);

	if (path == (char *) 0)
	{
		Message ("To far away/Not connected");
		return False;
	}

	if (s_pat (sct) != (char *) 0 && strcmp (path, s_pat (sct)) == 0)
	{
		Message ("No need to change that !");
		return False;
	}

	Message (Fmt (
		"New distribution path, pathcost = now %.2f (100%% eff %.2f)",
			RealPathCost (sct, path),
			EffPathCost (sct, path)));

	if (show)
		MarkPath (sct, path);

	if (!isrealm) {
		if (land_units) {
			FeedCommand (Fmt ("distribute %s %s", CrdStr (sct), CrdStr (to)), PRINT);
		} else {
			FeedCommand (Fmt ("distribute %s %sh", CrdStr (sct), path), PRINT);
		}
	}

	set_dxc (sct, s_xcd (to));
	set_dyc (sct, s_ycd (to));
	SetDistPath (sct, path);

	return True;
}

void UtilDist (x, y)
int x, y;
{
	Sector ware;
	bool done;
	int button, mode;
	Sector sct, psct;
	char *ppath;

	DeityChange (cursct);
	ware = cursct;
	if (!s_owned (ware))
	{
		Message ("You must own the current sector, stumperd !");
		return;
	}

	mode = GetDistributeMode (x, y, 2);

	if (mode < 0)
	{
		Message ("Distribute cancelled");
		return;
	}

	SetDefaultCursor (map_win, CR_DISTR);
	Message ("Distribute all: Select sectors");
	MesBut ("Show", "Done", "Set");
	done = False;
	ppath = (char *) 0;	/* previous path */
	psct = (Sector) 0;	/* previous sector */

	RaiseAll ();

	do {
		sct = SelectSector (&button);

		if (ppath != (char *) 0)
		{
			UnmarkPath (psct, ppath);
			ppath = (char *) 0;
		}

		if (psct != (Sector) 0)
		{
			UnmarkSector (psct);
			psct = (Sector) 0;
		}

		if (interrupt || button == MIDDLE_BUTTON)
		{
			interrupt = False;
			done = True;
		}
		else if (sct == (Sector) 0 || NO_INFO (sct))
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (sct);
			if (! s_owned (sct))
			{
				MarkSector (sct);
				Message (Fmt ("Sector %s ain't yours",
						CrdStr (sct)));
				UnmarkSector (sct);
			}
			else if (s_pat (sct) == (char *) 0)
			{
				MarkSector (sct);
				psct = sct;
			Message (Fmt ("%s @ %s has no distribution path",
					DesignName (s_nds (sct)),
					CrdStr (sct)));
			}
			else
			{
				psct = sct;
				MarkSector (sct);
				ppath = s_pat (sct);
		Message (Fmt ("Pathcost: now %.2f (100%% eff : %.2f)",
					RealPathCost (sct, ppath),
					EffPathCost (sct, ppath)));
				MarkPath (sct, s_pat (sct));
			}
		}
		else if (button == RIGHT_BUTTON)
		{
			CensusSct (sct);

			if (! s_owned (sct))
			{
				Message (Fmt ("Sector %s ain't yours",
					CrdStr (sct)));
			}
			else if (sct == ware)
			{
		Message ("Use distribute local to delete a distribution path");
			}
			else
			{
				Message ("Searching");
				if (ExecSetDistr (sct, ware, mode, True, False))
				{
					ppath = s_pat (sct);
					psct = sct;
					MarkSector (sct);
				}
			}
		}
			
	} while (! done);

	Census ();
	SetDefaultCursor (map_win, CR_MAP);
	Message ("End of distribute");
	MesClearBut ();

	LowerAll ();
}

void Distribute (sct, x, y)
Sector sct;
int x, y;
{
	Sector to;
	int button, mode;

	extern char *BestTmpDistPath ();

	mode = GetDistributeMode (x, y, 3);

	if (mode < 0)
		return;

	if (mode == DB_DELETE)
	{
		Message ("Distribution path from deleted");

		if (land_units) {
			FeedCommand (Fmt ("distribute %s %s", CrdStr (sct),
					CrdStr (sct)),
			    	PRINT);
		} else { 
			FeedCommand (Fmt ("distribute %s h", CrdStr (sct)),
			    	PRINT);
		}

		if (land_units) {
			set_dxc (sct, s_xcd (sct));
			set_dyc (sct, s_ycd (sct));
		} else {
			set_dxc (sct, 0);
			set_dyc (sct, 0);
		}
		SetDistPath (sct, (char *) 0);

		DrawSector (sct);
		CensusSct (sct);
		return;
	}
		
	Message (Fmt ("Current command: distribute %s", CrdStr (sct)));
	MesBut ("View", "Cancel", "Set");

	for (;;)
	{
		to = SelectSector (&button);

		if (interrupt || button == MIDDLE_BUTTON)
		{
			interrupt = False;
			Message ("Cancelled");
			MesClearBut ();
			return;
		}

		if (to == (Sector) 0 || NO_INFO (to))
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (to);
			continue;
		}

		if (! s_owned (to) && ! deity)
		{
			Message ("Heh, you don't own that sector !");
			continue;
		}

		if (to == sct)
		{
			Message ("Distribution path from deleted");

			if (land_units) {
				FeedCommand (Fmt ("distribute %s %s",
						 CrdStr (sct), CrdStr (to)),
				    		PRINT);
			} else {
				FeedCommand (Fmt ("distribute %s h",
						 CrdStr (sct)),
				    		PRINT);
			}

			set_dxc (sct, s_xcd (sct));
			set_dyc (sct, s_ycd (sct));
			SetDistPath (sct, (char *) 0);

			MesClearBut ();
			DrawSector (sct);
			return;
		}
		else
		{
			if (ExecSetDistr (sct, to, mode, True, False))
				UnmarkPath (sct, s_pat (sct));

			MesClearBut ();
			return;
		}
	}
}

	/*
	 *	The real(m) utility
	 */


void DistributeRealm (to)
Sector to;
{
	SList slist, tmp;
	char * ppath;
	Neighb neighb;
	Sector sct, psct = (Sector) 0;
	bool cross_bridges;
	bool incl_bridges;
	char * ans;
	char * srealm;
	Realm realm;
	char *line, *ptr;

	if (! s_owned (to))
	{
		Message ("That sector doesn't belong to you");
		Bell ();
		return;
	}

	if (s_des (to) != 'w' && ! Confirm (
		"This sector is not an warehouse, continue?", True))
			return;

	ans = InputAtMessage ("Distribute bridge spans [n]: ", 1, "yn");
	if (ans == (char *) 0 || interrupt)
	{
		Message ("Distribute realm cancelled");
		interrupt = False;
		return;
	}
	incl_bridges = * ans == 'y';

	ans = InputAtMessage ("Cross bridge spans [y]: ", 1, "yn");
	if (ans == (char *) 0 || interrupt)
	{
		Message ("Distribute realm cancelled");
		interrupt = False;
		return;
	}
	cross_bridges = ! (* ans == 'n');

	Message ("Select realm");
	srealm = MySelRealm ();
	if (srealm == (char *) 0 || interrupt)
	{
		Message ("Distribute realm cancelled");
		interrupt = False;
		return;
	}

	realm = InitRealm (srealm, S_OWNED);
	if (realm == (Realm) 0)
	{
		Message ("Something went wrong!");
		Bell ();
		return;
	}

	if (land_units) 
		FeedCommand (Fmt ("distribute %s %s", srealm, CrdStr (to)), PRINT);
	slist = (SList) 0;
	AddToSList (& slist, to, (SList) 0, False);
	ppath = (char *) 0;

	while ((tmp = FirstNotMarked (slist)) != (SList) 0)
	{
		InitNeighbours (tmp-> sct, & neighb);
		while (NextNeighbour (& sct, S_DESIG, neighb))
		{
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;

			if (! InRealm (realm, sct))
				continue;

			if (InSList (slist, sct))
				continue;

			if (s_des (sct) != '=' || incl_bridges)
			{
				if (Dist (s_xcd (sct), s_xcd (to),
					  s_ycd (sct), s_ycd (to)) > 10)
					continue;

				(void) ExecSetDistr (sct, to, DB_CUREFF, False,True);

				if (s_pat (sct) != (char *) 0)
				{
					if (ppath != (char *) 0)
						UnmarkPath (psct, ppath);
				
					MarkPath (sct, s_pat (sct));
					ppath = s_pat (sct);
					psct = sct;
				}
			}

			if (s_des (sct) != '=' || cross_bridges)
				AddToSList (& slist, sct, tmp, True);
		}
	}

	if (ppath != (char *) 0)
		UnmarkPath (psct, ppath);

	FreeSList (& slist);
	Message ("All sectors now distribute to the warehouse");
	FreeRealm (realm);
	return;
}

/* 
void Redistribute (x, y, n)
{
	int mode;
	char * realm;
	Realm rlm;

	mode = GetDistributeMode (x, y, 2);
	if (mode < 0)
	{
		Message ("Redistribute utility cancelled.");
		return;
	}

	Message ("Select realm to redistribute");
	realm = MySelRealm ();

	for (sct = First

*/
