/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/clients/RCS/empire.c,v 5.1 93/03/14 16:42:30 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:42:30 $
    $Author: etienne $
    $Id: empire.c,v 5.1 93/03/14 16:42:30 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	empire.c,v $
 * Revision 5.1  93/03/14  16:42:30  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:17:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:55:46  greyhelm
 * Test of GNUmake checkin
 *
 * Revision 4.4  1993/02/06  04:34:59  greyhelm
 * Added RCS header - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"

WinInfo empire_win;

int empire_height, empire_width;

static char last [1024];

bool enable_empire_more = False;

#ifdef	TERMC_VERSION

#	define	AT_Y	empire_height - 1

#else

#	define	AT_Y	empire_height - 2

#endif

void InitEmpire (inc_y, inc_width, inc_height, savelines)
int inc_y, inc_width, inc_height, savelines;
{
#ifdef TERMC_VERSION
	/*
	empire_height = screen_rows - EMPIRE_STARTY - 1;
	empire_width = screen_cols - CENSUS_WIDTH - 2;
	*/

	empire_height = EMPIRE_HEIGHT + 1;
	empire_width = screen_cols - CENSUS_WIDTH - 1;

	empire_win = OpenWindow (root_win,
			CENSUS_WIDTH + 1,
			EMPIRE_STARTY,
			empire_width,
			empire_height,
			0,
			UPPER_BOX,
			savelines);
#else
	empire_win = OpenWindow (root_win,
			0,
			CharToPixelY (EMPIRE_STARTY + inc_y),
			CharToPixelX (ROOT_WIDTH + inc_width - 1 -
					(savelines > 0 ? 1 : 0)) - BORDER_WIDTH,
			CharToPixelY (EMPIRE_HEIGHT + inc_height),
			PIXELS, FIXED, CharToPixelY (savelines));

	empire_height = EMPIRE_HEIGHT + inc_height;
	empire_width = ROOT_WIDTH + inc_width - (savelines > 0 ? 1 : 0);

#endif /* TERMC_VERSION */

}

void PrintAtEmpireMode (str, mode)
char *str;
int mode;
{
	if (! xstarted)
		return;

#ifdef X_VERSION

	Scroll (empire_win, CharToPixelY (1));

#else

	Scroll (empire_win, 1);
	Refresh ();

#endif /* X_VERSION */

	if (str == (char *) 0)
	{
		fprintf (stderr, "PrintAtEmpire char * 0 ??\n");
		return;
	}

	Print (empire_win, 0, AT_Y, Fmt ("%-.*s", empire_width - 1, str), mode);

	(void) strcpy (last, str);

	if (strlen (str) > empire_width)
		PrintAtEmpireMode (str + empire_width - 1, mode);
	else
	{
		FlushWindow (empire_win);
		Refresh ();
	}
}

void PrintAtEmpire (str)
char * str;
{
	PrintAtEmpireMode (str, NORMAL);
}

void MessageAtEmpire (str)
char * str;
{
#ifdef TERMC_VERSION
	if (no_empwin)
		Message (Fmt ("tcemp: %s", str));
	else
		PrintAtEmpire (Fmt ("tcemp: %s", str));
#else
	PrintAtEmpire (Fmt ("xemp: %s", str));
#endif /* TERMC_VERSION */
}

void ReprintAtEmpire (str)
char * str;
{
	int len;

	if (! xstarted)
		return;

	len = strlen (last);
	Print (empire_win, len, AT_Y,
				Fmt ("%-.*s", empire_width - 1 - len, str),
				BOLD);

	if (len + strlen (str) > empire_width - 1)
		PrintAtEmpireMode (str + empire_width - 1 - len, BOLD);
	else
		FlushWindow (empire_win);
	
	Refresh ();
}

void InputToEmpire ()
{
	char *ptr;
	int len;
	extern char *GetString ();

	enable_empire_more = True;
	for (;;)
	{
		FreeFmts ();

		do {
			len = strlen (last);
			ptr = GetString (empire_win, len, AT_Y,
					       empire_width - 1 - len, GS_TEXT);
			if (ptr == (char *) 0 &&
					(EmpireStatus () == E_COMMAND ||
					 EmpireStatus () == E_DEAD)) {
				interrupt = False;
				enable_empire_more = False;
				return;
			}
		} while (!interrupt && ptr == (char *) 0);

		if (interrupt) {
			interrupt = False;
			FeedEmpire ("aborted", PRINT);
		}
		else
			FeedEmpire (ptr, DONT_PRINT);

		(void) WaitForPrompt (PRINT);
		FlushWindow (empire_win);
	}
}

bool EmpireMore ()
{
	extern WinInfo empire_win;
	extern int empire_height;

	if (! xstarted)
		return True;

#ifdef X_VERSION
#	define	EMPIRE_MOREX	30
#else
#	define	EMPIRE_MOREX	20
#endif

	PrintB (empire_win, EMPIRE_MOREX, empire_height - 1, "[ M O R E ]");
	FlushWindow (empire_win);
	Refresh ();
	Pause ();
	PrintN (empire_win, EMPIRE_MOREX, empire_height - 1, "           ");
	FlushWindow (empire_win) ;
	Refresh ();

	if (interrupt) {
		interrupt = False;
		return False;
	}

	return True;
}
