/*
    $Header: /usr/local/src/et/work/xemp5.0/include/RCS/land.h,v 5.1 93/03/14 16:39:12 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:39:12 $
    $Author: etienne $
    $Id: land.h,v 5.1 93/03/14 16:39:12 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	land.h,v $
 * Revision 5.1  93/03/14  16:39:12  etienne
 * added some things (dont remeber all)
 * 
 * Revision 5.0  93/02/06  09:25:20  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:17:12  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#ifndef _LAND
#define _LAND

#ifndef _VAR
#include "var.h"
#endif _VAR

	/*
	 *	No need to add entries for the old coordinates of
	 *	an enemy unit. Let's take the lcm & hcm values 
	 */

extern char *ArmyId();
extern Sector LandSector();
extern Sector SctMarkedLands ();
extern char *SelectLands();

#define	old_x	lcm
#define	old_y 	hcm

struct l_land
{ 
	short owner;	/* deity only */
	short nr;
	short type;
	short x, y;
	char army;
	short eff;
	short fort;
	short mob;
	uchar moves;
	short food;
	short fuel;
	short tech;
	short retr;
	short arad;			/* actions radius */
	short xpln;			/* xlight planes */
	short shipnr;
	short shell;
	short gun;
	short pet;
	short iron;
	short dust;
	short bar;
	short oil;
	short lcm;
	short hcm;
	short rad;
	time_t time;
	Land nextsct, next;
	bool marked;
};

#define ld_owned(p)		(int) ((p)-> owner == my_cnum)
#define ld_owner(p)		(int) (p)-> owner
#define ld_nr(p)		(int) (p)-> nr
#define ld_type(p)		(int) (p)-> type
#define ld_xcd(p)		(int) (p)-> x
#define ld_ycd(p)		(int) (p)-> y
#define ld_army(p)		(int) (p)-> army
#define ld_eff(p)		(int) (p)-> eff
#define ld_fort(p)		(int) (p)-> fort
#define ld_mob(p)		(int) (p)-> mob
#define ld_moves(p)		(int) (p)-> moves
#define ld_foo(p)		(int) (p)-> food
#define ld_fuel(p)		(int) (p)-> fuel
#define ld_tech(p)		(int) (p)-> tech
#define ld_retr(p)		(int) (p)-> retr
#define ld_arad(p)		(int) (p)-> arad
#define ld_xpln(p)		(int) (p)-> xpln
#define ld_shipnr(p)		(int) (p)-> shipnr
#define ld_she(p)		(int) (p)-> shell
#define ld_gun(p)		(int) (p)-> gun
#define ld_pet(p)		(int) (p)-> pet
#define ld_iron(p)		(int) (p)-> iron
#define ld_dust(p)		(int) (p)-> dust
#define ld_bar(p)		(int) (p)-> bar
#define ld_oil(p)		(int) (p)-> oil
#define ld_lcm(p)		(int) (p)-> lcm
#define ld_hcm(p)		(int) (p)-> hcm
#define ld_rad(p)		(int) (p)-> rad
#define ld_next(p)		(p)-> next
#define ld_nxtsct(p)		(p)-> nextsct
#define ld_marked(p)		(p)-> marked
#define ld_time(p)		(p)-> time

#define	ld_oldx(p)		(p)-> old_x
#define	ld_oldy(p)		(p)-> old_y

#define set_ld_owner(p,q)	((p)-> owner	= (short) (q))
#define set_ld_nr(p,q)		((p)-> nr	= (short) (q))
#define set_ld_type(p,q)	((p)-> type	= (short) (q))
#define set_ld_xcd(p,q)		((p)-> x	= (short) (q))
#define set_ld_ycd(p,q)		((p)-> y	= (short) (q))
#define set_ld_army(p,q)	((p)-> army	= (char) (q))
#define set_ld_eff(p,q)		((p)-> eff	= (short) (q))
#define inc_ld_eff(p,q)		(p)-> eff 	+= (short) (q)
#define set_ld_fort(p,q)	((p)-> fort	= (short) (q))
#define set_ld_mob(p,q)		((p)-> mob	= (short) (q))
#define set_ld_foo(p,q)		((p)-> food	= (short) (q))
#define inc_ld_foo(p,q)		(p)-> food	+= (short) (q)
#define set_ld_fuel(p,q)	((p)-> fuel	= (short) (q))
#define set_ld_tech(p,q)	((p)-> tech	= (short) (q))
#define set_ld_retr(p,q)	((p)-> retr	= (short) (q))
#define set_ld_arad(p,q)	((p)-> arad	= (short) (q))
#define set_ld_xpln(p,q)	((p)-> xpln	= (short) (q))
#define set_ld_shipnr(p,q)	((p)-> shipnr	= (short) (q))
#define set_ld_she(p,q)		((p)-> shell	= (short) (q))
#define set_ld_gun(p,q)		((p)-> gun	= (short) (q))
#define set_ld_pet(p,q)		((p)-> pet	= (short) (q))
#define set_ld_iron(p,q)	((p)-> iron	= (short) (q))
#define set_ld_dust(p,q)	((p)-> dust	= (short) (q))
#define set_ld_bar(p,q)		((p)-> bar	= (short) (q))
#define set_ld_oil(p,q)		((p)-> oil	= (short) (q))
#define set_ld_lcm(p,q)		((p)-> lcm	= (short) (q))
#define set_ld_hcm(p,q)		((p)-> hcm	= (short) (q))
#define set_ld_rad(p,q)		((p)-> rad	= (short) (q))
#define set_ld_next(p,q)	((p)-> next	= (q))
#define set_ld_nxtsct(p,q)	((p)-> nextsct	= (q))
#define set_ld_marked(p,q)	((p)-> marked	= (q))

#define set_ld_oldx(p,q)	((p)-> old_x = (short) (q))
#define set_ld_oldy(p,q)	((p)-> old_y = (short) (q))
#define set_ld_oldpos(p,q,r)	{ set_ld_oldx(p, q); set_ld_oldy (p, r); }

#define set_ld_time(p,q)	((p)-> time = (q))
#define set_ld_moves(p,q)	((p)-> moves = (uchar) (q))

struct	l_landtype {
	char   *nam;		/* full name of type of landunit */
	int	lcm;		/* units of lcm to build */
	int	hcm;		/* units of hcm to build */
	int	mil;		/* units of mil to build */
	int	guns;		/* units of guns to build */
	int	shells;		/* units of shells to build */
	int	ava;		/* How may workers should be available */
	int	tec;		/* tech required to build */
	int	cos;		/* how much it costs to build */
	float	att;		/* attack value of unit. */
	float	def;		/* defense value of unit. */
	int	vul;		/* how vulnerable to shelling it is */
	int	spd;		/* how fast it can go */
	int	vis;		/* how well it can be seen */
	int	spy;		/* how well it can see */
	int	rad;		/* how far it can react */
	int	frg;		/* how far it can fire */
	int	acc;		/* how many guns it can fire */
	int	dam;		/* how much damage it does when firing*/
	int	amm;		/* how much ammo it uses to fire */
	int	aaf;		/* the AA fire rating of the unit */
	int	fuse;		/* the units fuel usage */
	int	fcar;		/* the units fuel capacity */
	int 	xpl;		/* how many light planes on board */
	long	flags;		/* what special things can this landunit do */
	int	car [V_MAX];
};

#define MAX_LANDTYPES	100

#define L_SUPPLY	0x00001	/* supply unit */
#define L_LIGHT		0x00002	/* light unit */
#define L_ASSAULT	0x00004	/* can take land from water */
#define L_RECON		0x00008	/* gets better info on enemy */
#define L_SECURITY	0x00010	/* better on guerillas */
#define L_ENGINEER	0x00020	/* engineering unit ... better building */
#define L_RADAR		0x00040	/* radar capable */
#define L_MARINE	0x00080	/* marines ... YES! */
#define L_XLIGHT	0x00100 /* can load xligh stuff */
#define L_KNOWN		0x00200	/* do I know the specs ? */

extern Land landlist;
extern LdType landtypes[];

#define		ALL_LANDS(p)	(p=landlist; p != (Land) 0; p = ld_next (p))

typedef enum
{
	LD_MARCH,
	LD_SCRAP,
	LD_LLOADXPLANE,
	LD_LANDTOSHIP,
	LD_ARMYADD
}
    LdTask;

#define LND_RADAR	0
#define LND_LOOK	1
#define	LND_MARCH	2
#define	LND_FIRE	3
#define LND_MINE	4
#define LND_FORT	5
#define LND_WORK	6
#define LND_SUPPLY	7
#define LND_SET		9
#define LND_SCRAP	10
#define LND_SCUTTLE	11
#define LND_BUILD	12

#define	LND_MAX		12

#endif /* _LAND */
