/*
 * Plague code
 * mta Sun Dec  2 23:43:20 EET 1990
 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include <fcntl.h>
#include <sys/file.h>
#include "production.h"

char * LastProduction();

S_PRODUCTION *production;

void ReadProduction(file)
char *file;
{
   int fd;
   off_t size;
   char *buf;

   if (strcmp (file, "-"))
   {
   	if ((fd = open(file, O_RDONLY)) == -1)
	{
		Error("Production: could not open file");
		return;
	}

   	size = lseek(fd, (off_t)0, L_XTND);
   	(void) lseek(fd, (off_t)0, L_SET);

   	buf = (char *) malloc(size+1);
   	read (fd, buf, size);
      	close (fd);
   }
   else 
      	buf = LastProduction();

   UpdateProduction(buf);
   free(buf);
}


/*
 * gets production report as parameter,
 * constructs production list
 */

void UpdateProduction(string)
char *string;
{
   char *ps, *pn, *po, *pp;
   S_PRODUCTION *np;

/* dispose of known production info */
   if (production != NULL) {
      S_PRODUCTION *now;
      now = production;
      while ( p_next(production) ) {
	 production = p_next(production);
	 free (now);
	 now = production;
      }
      free (now);
      production = NULL;
   }
   
   ps = (char *)malloc(strlen(string)+1);
   (void) strcpy(ps, string);

   po = ps;
   while (pn= index(po, '\n'))  {
      pp = pn+1;
      np = NULL;
      *pn = '\0';
      np = (S_PRODUCTION *)alloc_production();
      if (pn = (char *)StrStr(po, "battling PLAGUE")) {
	 p_plague_stage(np) = PLG_INFECT;
	 p_xcd(np) = atoi(po);
	 p_ycd(np) = atoi(index(po, ',')+1);
      } else if (pn = (char *)StrStr(po, "Outbreak of PLAGUE in ")) {
	 p_plague_stage(np) = PLG_INFECT;
	 p_xcd(np) = atoi(pn+22);
	 p_ycd(np) = atoi(index(pn+22, ',')+1);
      } else if (pn = (char *)StrStr(po, "PLAGUE deaths reported in ")) {
	 p_plague_stage(np) = PLG_DYING;
	 p_xcd(np) = atoi(pn+26);
	 p_ycd(np) = atoi(index(pn+26, ',')+1);
      } else if (pn = (char *)StrStr(po, "Civil unrest in ")) {
	 p_happines(np) = HP_UNREST;
	 p_xcd(np) = atoi(pn+16);
	 p_ycd(np) = atoi(index(pn+16, ',')+1);
      } else if (pn = (char *)StrStr(po, "Revolutionary subversion reported in ")) {
	 p_happines(np) = HP_REVOLUTIONARIES;
	 p_xcd(np) = atoi(pn+37);
	 p_ycd(np) = atoi(index(pn+37, ',')+1);
      } else if (pn = (char *)StrStr(po, "Production minimally disrupted by terrorists in ")) {
	 p_happines(np) = HP_TERRORISTS;
	 p_xcd(np) = atoi(pn+48);
	 p_ycd(np) = atoi(index(pn+48, ',')+1);
      } else if (pn = (char *)StrStr(po, "Production partially disrupted by terrorists in ")) {
	 p_happines(np) = HP_TERRORISTS;
	 p_xcd(np) = atoi(pn+48);
	 p_ycd(np) = atoi(index(pn+48, ',')+1);
      } else if (pn = (char *)StrStr(po, "Production moderately disrupted by terrorists in ")) {
	 p_happines(np) = HP_TERRORISTS;
	 p_xcd(np) = atoi(pn+49);
	 p_ycd(np) = atoi(index(pn+49, ',')+1);
      } else if (pn = (char *)StrStr(po, "Production completely disrupted by terrorists in ")) {
	 p_happines(np) = HP_TERRORISTS;
	 p_xcd(np) = atoi(pn+49);
	 p_ycd(np) = atoi(index(pn+49, ',')+1);
      } else if (pn = (char *)StrStr(po, "Guerrilla warfare in ")) {
	 p_happines(np) = HP_GUERRILLAS;
	 p_xcd(np) = atoi(pn+21);
	 p_ycd(np) = atoi(index(pn+21, ',')+1);
      } else if (pn = (char *)StrStr(po, "Bad dist path in ")) {
	 p_bad_dist(np) = True;
	 p_xcd(np) = atoi(pn+17);
	 p_ycd(np) = atoi(index(pn+17, ',')+1);
      } else {
	 free(np);
	 np = NULL;
      }
      if (np) {
	 p_next(np) = production;
	 production = np;
      }
      po = pp;
   }
   free(ps);
}

/*
 * gets x and y and returns plague-stage
 */
PlagueStage(sct)
Sector sct;
{
   S_PRODUCTION *pp = production;
   int x, y;

   x = s_xcd(sct);
   y = s_ycd(sct);
   
   while (pp) {
      if ( (p_xcd(pp) == x) && (p_ycd(pp) == y) ) 
	 if (p_plague_stage(pp) != -1)
	    return p_plague_stage(pp);
      pp = p_next(pp);
   }

   return PLG_HEALTHY;
}

IsPlague(sct)
Sector sct;
{
   int stage;

   stage = PlagueStage(sct);

   if (stage == PLG_INFECT)
      return True;

   return False;
}

DumpPlague()
{
   S_PRODUCTION *pp = production;

   while (pp) {
      fprintf(stderr, "(%d, %d) %d\n", p_xcd(pp), p_ycd(pp), p_plague_stage(pp));
      pp = p_next(pp);
   }

}
   

/*
 * gets x and y and returns happines
 */
HappinesState(sct)
Sector sct;
{
   S_PRODUCTION *pp = production;
   int x, y;

   x = s_xcd(sct);
   y = s_ycd(sct);
   
   while (pp) {
      if ( (p_xcd(pp) == x) && (p_ycd(pp) == y) ) 
	 if (p_happines(pp) != -1)
	    return p_happines(pp);
      pp = p_next(pp);
   }

   return HP_LOYAL;
}

IsHappy(sct)
Sector sct;
{
   int state;

   state = HappinesState(sct);
   
   if (state <= HP_LOYAL)
	    return True;

   return False;
}

DumpHappines()
{
   S_PRODUCTION *pp = production;

   while (pp) {
      fprintf(stderr, "(%d, %d) %d\n", p_xcd(pp), p_ycd(pp), p_happines(pp));
      pp = p_next(pp);
   }

}

char *alloc_production()
{
   S_PRODUCTION *new;

   new = (S_PRODUCTION *)malloc(sizeof(S_PRODUCTION));
   
   p_plague_stage(new) = -1;
   p_happines(new) = -1;
   p_bad_dist(new) = -1;
   p_next(new) = NULL;

   return (char *)new;
}

IsBadDistr(sct)
Sector sct;
{
   S_PRODUCTION *pp = production;
   int x, y;

   x = s_xcd(sct);
   y = s_ycd(sct);
   
   while (pp) {
      if ( (p_xcd(pp) == x) && (p_ycd(pp) == y) ) 
	 if (p_bad_dist(pp) != -1)
	    return True;
      pp = p_next(pp);
   }

   return False;
}

