#include "main.h"
#include "var.h"
#include "ferry.h"
#include "sector.h"

int EditGoto (win, ferry, init)
WinInfo win;
Ferry ferry;
bool init;
{
	char * ptr, ch;
	int x, y;
	bool first_pass, err, cont;

	ClearWindow (win);

	PrintN (win, 1, 1, Centered ("-=[ Ferry Utility : GOTO ]=-", F_MAX_X));

	PrintN (win, 1, 3, Fmt ("Ferry# %d", ferry-> id));

	y = 0;
	first_pass = True;
	err = False;

	cont = True;
	do {
			/* Ship / Fleet */

		if (first_pass || y == 5)
		{
			ClearLine (win, 5);

			if (y == 5 || init)
			{
				if (! SelectFlSh (win, 5, ferry))
				{
					Bell ();

					if (init)
					{
					    Message ("Add Ferry cancelled");
					    DeleteFerry (ferry-> id);
					    return RET_DONE;
					}
				}
			}

			if ((ptr = CheckFlSh (ferry)) != (char *) 0)
			{
				if (first_pass && ! init)
					err = True;
				else
					Bell ();
			}

			PrintN (win, 1, 5, Fmt ("%-20s %-35s",
				ferry-> fleet == '\0' ?
					Fmt ("Ship %d", ferry-> shipnr) :
					Fmt ("Fleet %c", ferry-> fleet),
				ptr == (char *) 0 ?
					Fmt ("[now @ %s]", FerryPos (ferry)) :
					Fmt ("[Warning: %s !]", ptr)));
		}

		if (y == 6 || first_pass)
		{
			if (! init && y == 6)
				ferry-> active = ! ferry-> active;

			ClearLine (win, 6);
			PrintN (win, 1, 6, Fmt ("Ferry is %sactive",
				ferry-> active ? "": " NOT"));
		}

			/* Goto which sector ? */

		if (first_pass || y == 8)
		{
			ClearLine (win, 8);

			if (y == 8 || init)
			{
				if (! SelSector (win, 8, "Goto",
					True, & (ferry-> ax), & (ferry-> ay)))
				{
					Bell ();

					if (init)
					{
					     Message ("Add Ferry cancelled");
					     DeleteFerry (ferry-> id);
					     return RET_DONE;
					}
				}

			}

			ptr = CheckSector (ferry-> ax, ferry-> ay, TASK_GOTO);

			if (ptr != (char *) 0)
				if (first_pass && ! init)
					err = True;
				else
					Bell ();

			PrintN (win, 1, 8, Fmt ("%-20s %-35s",
				Fmt ("Goto: %d,%d", ferry-> ax, ferry-> ay),
				ptr == (char *) 0 ?
					"[OK]" :
					Fmt ("[Warning: %s !]", ptr)));
		}

		if (y == 12 && ! first_pass)
		{
			if (FerButPressed (x, F_SX_DONE, 4))
				return RET_DONE;
			else if (FerButPressed (x, F_SX_PREV, 4))
				return RET_PREV;
			else if (FerButPressed (x, F_SX_RUN, 3))
			{
				DoFerry (ferry-> id);
				return RET_DONE;
			}
			else if (FerButPressed (x, F_SX_NEXT, 4))
				return RET_NEXT;
			else if (FerButPressed (x, F_SX_DELETE, 6))
				if (Confirm ("Delete this ferry ?", True))
					return RET_DELE;
		}

		if (first_pass)
		{
			PrintN (win, 1, 9, 
				ferry-> complet ?
					"Status: Completed" :
					"Status: Not completed");

			FerButton (win, F_SX_DONE,   12, "Done");
			FerButton (win, F_SX_PREV,   12, "Prev");
			FerButton (win, F_SX_RUN,    12, "Run");
			FerButton (win, F_SX_NEXT,   12, "Next");
			FerButton (win, F_SX_DELETE, 12, "Delete");

			if (err)
				Bell ();

			if (init)
				init = False;
			
			first_pass = False;
		}

		FlushWindow (win);
		Refresh ();

#ifdef X_VERSION
		cont = SelButtonAtWin (win, & x, & y, (int *) 0);
#else
		SelectButtonChar ((int *) 0, & ch, & x, & y, "DPNRP\033");
		if (interrupt || ch != '\0')
		{
			if (interrupt)
			{
				interrupt = False;
				cont = False;
			}
			else
			{
				y = 12;
				SetXAtButton (& x, ch);
			}
		}
#endif
	}
	while (cont);
					
	return RET_DONE;
}

void RunGotoFerry (ferry)
Ferry ferry;
{
	Sector from, to;
	int x, y;

	if (ferry-> complet)
	{
		ShowText ("This task is already completed");
		ShowText ("Done");
		return;
	}

	ShowText (Fmt ("Moving to %d, %d", ferry-> ax, ferry-> ay));
	ShowText ("");

	to = World (ferry-> ax, ferry-> ay, S_DESIG);

	from = FerrySector (ferry);

	x = s_xcd (from);
	y = s_ycd (from);

	(void) NavigPath (ferry-> fleet, ferry-> shipnr, & x, & y, to);

	if (World (x, y, S_EXIST) == to)
	{
		ferry-> complet = True;
		ShowText ("Got There, task COMPLETED");
	}

	if (! util_mode)
	{
		DrawSector (from);
		DrawSector (World (x, y, S_DESIG));
	}

	ShowText ("Done");
}

