#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "plane.h"

void UpdMobSect (realm, etus)
char * realm;
int etus;
{
	register int x;
	register int y;
	Sector sct;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for (x = - MAX_X / 2; x < MAX_X / 2; x ++)
		for (y = - MAX_Y / 2 + (x % 2); y < MAX_Y / 2; y += 2)
		{
			if (x < sx || x > ex || y < sy || y > ey)
				continue;

			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0 || ! s_owned (sct))
				continue;
			
			value = s_mob (sct) + etus * sect_mob_scale;
			if (value > sect_mob_max)
				value = sect_mob_max;
			set_mob (sct, value);
		}
}

void UpdMobShip (realm, etus)
char * realm;
int etus;
{
	Ship ptr;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for (ptr = shiplist; ptr != (Ship) 0; ptr = sh_next (ptr))
	{
		if (! sh_owned (ptr))
			continue;
		
		if (sh_xcd (ptr) < sx || sh_xcd (ptr) > ex ||
		    sh_ycd (ptr) < sy || sh_ycd (ptr) > ey)
			continue;

		value = sh_mob (ptr) + etus * ship_mob_scale;
		if (value > ship_mob_max)
			value = ship_mob_max;

		set_sh_mob (ptr, value);
	}
}

void UpdMobPlane (realm, etus)
char * realm;
int etus;
{
	Plane ptr;
	int value;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_PLANES (ptr)
	{
		if (! pl_owned (ptr))
			continue;
		
		if (pl_xcd (ptr) < sx || pl_xcd (ptr) > ex ||
		    pl_ycd (ptr) < sy || pl_ycd (ptr) > ey)
			continue;

		value = pl_mob (ptr) + etus * plane_mob_scale;
		if (value > plane_mob_max)
			value = plane_mob_max;
		
		set_pl_mob (ptr, value);
	}
}
