#include "type.h"
#include "main.h"
#include "tc_type.h"
#include "event.h"
#include "char.h"
#include "func.h"

#ifdef BSD
#include <sys/ioctl.h>
#else /* SYS5 */
#include <sys/termios.h>
#endif

char * CL;		/* clear screen */
static char * HO;	/* cursor home */
char * CM;		/* cursor movement */
static char * SO;	/* begin reverse video */
static char * SE;	/* end reverse video */
char * US;		/* start underscore mode */
char * UE;		/* end underscore mode */
static char * IS;	/* terminal initialise string */
static char * MH;	/* start half intensity */
static char * ME;	/* end half intensity */

static char bp [1024];
static char strbuffer [1024];
static char * bufptr;

bool am_flag, ms_flag;

char * HLS;	/* start highlight */
char * HLE;	/* end highlight */

bool interrupt;
int map_height = 22;

bool xstarted;

int screen_cols, screen_rows;

static void TGetStr (ptr, id, must)
char ** ptr;
char * id;
bool must;
{
	char * tgetstr ();

	* ptr = tgetstr (id, & bufptr);

	if (* ptr == (char *) 0 && must)
	{
		fprintf (stderr, "Couldn't find the \"%s\" capibility.\n", id);
		exit (1);
	}
}

void InitTermcap (hs1, he1, hs2, he2)
char * hs1, * he1, * hs2, * he2;
{
	char * term, * getenv ();

	term = getenv ("TERM");
	if (term == (char *) 0)
	{
		fprintf (stderr, "Environment variable \"TERM\" not set.\n");
		exit (1);
	}

	switch (tgetent (bp, term))
	{

	case -1:
		fprintf (stderr, "Can't open termcap file (%s).\n",
			getenv ("TERMCAP") == (char *) 0 ?
				"/etc/termcap": getenv ("TERMCAP"));
		exit (1);
	
	case 0:
		fprintf (stderr, "Can't find termcap entry for \"%s\".\n", 
					term);
		exit (1);
	default:
		break;
	}

	bufptr = strbuffer;

	TGetStr (& CL, "cl", True);
	/* XX False-> True XX */ 
	TGetStr (& HO, "ho", False);
	TGetStr (& CM, "cm", True);

	am_flag = tgetflag ("am");
	ms_flag = tgetflag ("ms");

	if (hs1 == (char *) 0)
	{
		TGetStr (& SO, "so", True);
		TGetStr (& SE, "se", True);
		TGetStr (& US, "us", True);
		TGetStr (& UE, "ue", True);
		TGetStr (& IS, "is", False);
		TGetStr (& MH, "mh", False);
		TGetStr (& ME, "me", False);

		HLS = MH;
		HLE = ME;
		if (HLS == (char *) 0)
		{
			HLS = SO;
			HLE = SE;
			if (HLS == (char *) 0)
			{
				HLS = US;
				HLE = UE;
				fprintf (stderr,
					"Can't find half bright/reverse");
				fprintf (stderr,
					" mode, using underscore.\n");
			}
		}
	}
	else
	{
		TGetStr (& SO, hs1, True);
		TGetStr (& SE, he1, True);
		TGetStr (& US, hs2, True);
		TGetStr (& UE, he2, True);

		HLS=SO;
		HLE=SE;
	}


		/*
		 *	Determine the size of the window.
		 */
	{
		struct winsize wininf;

		if (ioctl (0, TIOCGWINSZ, & wininf) != 0)
		{
			fprintf (stderr, "ioctl (TIOCGWINSZ) failed.\n");
			perror ("ioctl");
			exit (1);
		}

		screen_cols = wininf. ws_col;
		screen_rows = wininf. ws_row;


		if (screen_cols == 0 || screen_rows == 0)
		{
			char buf [100];

			/*
			fprintf (stderr, "Cols & rows are not correctly set. ");
			fprintf (stderr, "Use: 'stty cols # rows #'\n");
			exit (1);
			*/

			printf ("Screen size [24x80]: ");
			if (gets (buf) == (char *) 0)
				exit (0);
			
			if (buf [0] == '\0')
			{
				screen_cols = 80;
				screen_rows = 24;
			}
			else
			{
				if (sscanf (buf, "%d %*[x,] %d", & screen_rows,
						& screen_cols) != 2)
				{
					printf ("input error.\n");
					exit (1);
				}
			}
		}
	}

	xstarted = True;
}

int put (ch)
char ch;
{
	putchar (ch);
}

WinInfo census_win;
FILE * error_fp;

WinInfo root_win;
