#include "setup.h"

void Setup1 ()
{
	char * ptr;

	def_bsd = access ("/usr/include/sys/termios.h", R_OK) == 0
				? "no" : "yes";

	if (auto_mode)
	{
		printf ("CC= cc\n");
		printf ("BSD system= %s\n", def_bsd);
		printf ("CFLAGS= -O\n");
		printf ("LDFLAGS= -s\n");
		printf ("LLIBS= /usr/lib/X11\n");

		compiler = "cc";
		bsd = def_bsd;
		copts = "-O";
		lopts= "-s";
		x11lib = def_x11lib;
		while (! make_termcap && access (x11lib, R_OK) != 0)
		{
			x11lib = Quest (
				"Directory where the X-libraries are located",
				(char *) 0, True);
		}
			

		return;
	}

	do {
		Clear ();

		printf ("-=[ Compilation ]=-\n\n");
		compiler = Quest ("Use which compiler", def_compiler, True);

		bsd = Quest ("Are you working under BSD", def_bsd, False);
		copts = Quest ("Flags to pass to the c-compiler",
						def_copts, False);
		lopts = Quest ("Flags to pass to the loader", def_lopts, False);

		if (! make_termcap)
			x11lib = Quest (
				"Directory where the X-libraries are located",
				def_x11lib, True);
		
		printf ("CC=%s\n", compiler);
		printf ("CFLAGS=%s\n", copts);
		printf ("LDFLAGS=%s\n", lopts);
		if (! make_termcap)
			printf ("LLIBS=%s\n", x11lib);

		if (* bsd == 'y')
			printf ("Working under BSD\n\n");
		else
			printf ("Not working under BSD\n\n");
	}
	while (! Correct ());
}

void Setup2 ()
{
	static char buffer [100];
	char * ptr, * getenv ();

	if (auto_mode)
	{
		dhost = "berkeley.edu";
		dport = "1617";
		ptr = getenv ("XEMPDIR");
		if (ptr == (char *) 0)
		{
			ptr = getenv ("HOME");
			if (ptr == (char *) 0)
			{
				fprintf (stderr,
				"You can not use auto mode (HOME not set)\n");
				exit (1);
			}
			strcpy (buffer, ptr);
			strcat (buffer, "/xemp/info");
		}
		else
		{
			strcpy (buffer, ptr);
			strcat (buffer, "/info");
		}

		xempinf = buffer;
		printf ("XEMPINFO= %s\n", xempinf);

		hasei = Quest ("Do you have empire-info on line", 
					def_hasei, False);

		if (* hasei == 'y')
		{
			empinf = Quest ("Name of the info-directory",
					(char *) 0, True);

			printf ("EMPINFO= %s\n", empinf);
		}
		return;
	}
		
	do {
		Clear ();

		printf ("-=[ XEMP default values ]=-\n\n");
		do
			wsize = Quest ("World Size", def_wsize, False);
		while (sscanf (wsize, "%dx%d", & def_max_x, & def_max_y) != 2);

		dhost = Quest ("Default empire host", def_host, False);
		dport = Quest ("Default empire port", def_port, False);
		xempinf = Quest ("Where will xemp-info be located",
					def_xempinf, False);
		hasei = Quest ("Do you have empire-info on line", 
					def_hasei, False);

		if (* hasei == 'y')
			empinf = Quest ("Name of the info-directory",
					def_empinf, True);
		

		printf ("\nDEF_MAX_X=%d\n", def_max_y);
		printf ("DEF_MAX_Y=%d\n", def_max_y);
		printf ("EMPIREPORT=%s\n", dport);
		printf ("EMPIREHOST=%s\n", dhost);
		printf ("XEMPINFO=%s\n", xempinf);
		if (* hasei == 'y')
			printf ("EMPINFO=%s\n", empinf);

		putchar ('\n');
	}
	while (! Correct ());
}

void Setup3 ()
{
	if (auto_mode)
	{
		printf ("CTAGS= ctags\n");
		printf ("FTPDIR= /home/staff3/ftpd/pub/xemp/secret\n");

		ctags = "ctags";
		ftpdir = "/home/staff3/ftpd/pub/xemp/secret";
		return;
	}

	do {
		Clear ();

		printf ("-=[ Miscellaneous ]=-\n\n");

		ctags = Quest ("Ctags", def_ctags, False);
		ftpdir = Quest ("Ftp directory", def_ftpdir, False);

		printf ("\nCTAGS=%s\n", ctags);
		printf ("FTPDIR=%s\n\n", ftpdir);
	}
	while (! Correct ());
}
