#include "setup.h"
#include <varargs.h>

char * Fmt (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];
	
	va_start (args);
	ptr = va_arg (args, char *);

	(void) vsprintf (fmtbuf, ptr, args);
	va_end (args);

	return fmtbuf;
}

void Verbose (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];
	
	if (verbose)
	{
		va_start (args);
		ptr = va_arg (args, char *);

		(void) vsprintf (fmtbuf, ptr, args);
		va_end (args);

		printf (fmtbuf);
	}
}

void Error (va_alist)
va_dcl
{
	va_list args;
	char * ptr;
	char fmtbuf [BUFSIZ];

	va_start (args);
	ptr = va_arg (args, char *);
	(void) vsprintf (fmtbuf, ptr, args);
	va_end (args);

	fprintf (stderr, "%s: %s", progname, fmtbuf);
	exit (-1);
}

char * Str (s)
char * s;
{
	char * strcpy (), * malloc ();

	return strcpy (malloc (strlen (s) + 1), s);
}

void Get (buf)
char * buf;
{
	char * gets ();

	if (gets (buf) == (char *) 0)
		Error ("unexpected end of input.\n");
}

char * Question (quest, def, is_file)
char * quest;
char * def;
bool is_file;
{
	char ans_buffer [BUFSIZ];
	char * ans, * getenv ();

	printf (quest);
	if (def != (char *) 0)
		printf (" [%s]", def);
	printf (": ");

	Get (ans_buffer);
	ans = ans_buffer;
	if (* ans == '\0')
		ans = def;

	if (* ans == '~')
		ans =  Fmt ("%s%s", getenv ("HOME"), ans + 1);

	if (is_file && access (ans, R_OK))
		printf ("\007%s: can't access\n", ans);

	if (* ans == '.' && * (ans + 1) == '\0')
		return "";
	else
		return ans;
}

char * Quest (quest, def, is_file)
char * quest, * def;
bool is_file;
{
	return Str (Question (quest, def, is_file));
}

void More ()
{
	char answer [40];

	printf ("More [q to quit]: ");
	Get (answer);
	if  (* answer == 'q')
	{
		printf ("%s: stopped\n", progname);
		exit (0);
	}
}

bool Correct ()
{
	char ans [40];

	printf ("Correct (ynq) [y]: ");
	Get (ans);
	if (* ans == 'q' || * ans == 'Q')
	{
		printf ("setup: stopped\n");
		exit (0);
	}

	return * ans != 'n' && * ans != 'N';
}

void Clear ()
{
	system ("clear");
}
