#include "setup.h"

bool auto_mode;

static void Info ()
{
	Clear ();

	printf ("-=[ XEMP setup program ]=-\n\n");
	printf ("This program will help you installing XEMP, ");
	printf ("by asking you all information\n");
	printf ("about libraries and default XEMP-values.\n\n");
	printf ("Defaults values will be shown in brackets. ");
	printf ("Tilde (~) can be used for\nyour home-directory. ");
	printf ("A '.' can be used for no input (means not default).\n\n");
	printf ("When you still have problems compiling xemp, ");
	printf ("you can send email to\n'%s' ", author);
	printf ("or simple use 'make reply'.\n\n");
	printf ("Options:\n");
	printf ("\t-i: check for existing makefile.\n");
	printf ("\t-p: don't depend on the file 'proto.h'\n");
	printf ("\t-v: verbose\n");
	printf ("\t-d: use all default values\n");
	printf ("\t-t: make termcap version only\n");
	printf ("\t-f <file-name> (default makefile)\n\n");
	printf ("\t-T: make makefile for tcemp only. (ultrix machines)\n");
	printf ("\t-X: make makefile for xemp only.  (ultrix machines)\n");
	printf ("\t-V: verbose output when making.\n");
}

static void EndInfo ()
{
	if (verbose)
		Clear ();
	
	printf ("%s ready.\n\n", makef);
	printf ("options to make:\n");
	printf ("\txemp    - compiles xemp\n");
	printf ("\ttags    - makes tags file\n");
	printf ("\treply   - send a reply to %s\n", author);
	printf ("\tcleanup - remove object and tag files\n");
	printf ("\tpack    - pack all sub directories\n");
	printf ("\tunpack  - unpack all sub directories\n");
	printf ("\tsetup   - compile setup\n");
	printf ("\tproto   - compile proto\n");
	printf ("\tproto.h - create a new proto-file\n");
	printf ("\tftp     - places the current version in ftp\n");
}


main (argc, argv)
int argc;
char * argv;
{
	bool use_defaults = False;
	bool check = False;
	bool silent_mode = False;
	char answer [40];
	FILE * fp;

	extern char * optarg;
	extern int getopt ();
	int ch;

	make_termcap = False;

	init_opt (argc, argv);
	while ((ch = next_opt ()) != '\0')
		switch (ch)
		{

		case 't':
			make_termcap = True;
			break;

		case 'd':
			use_defaults = True;
			break;
		
		case 'i':
			check = True;
			break;

		case 'v':
			verbose = True;
			break;
		
		case 'p':
			depend_proto = False;
			break;
		
		case 'f':
			makef = next_arg ();
			break;
		
		case 'V':
			verbose_output = True;
			break;

		case 'T':
			just_tcemp = True;
			make_termcap = True;
			break;
		
		case 'X':
			just_xemp = True;
			break;

		case 'a':
			auto_mode = True;
			break;

		case 's':
			silent_mode = True;
			break;

		default:
			Info ();
			exit (-1);
		}

	if (use_defaults)
		Defaults ();
	else
	{
		if (! silent_mode)
		{
			Info ();
			More ();
		}

		Setup1 ();
		Setup2 ();
		Setup3 ();
	}

	if (access (makef, R_OK) == 0 && check)
	{
		printf ("%s already exists, overwrite? ", makef);
		Get (answer);
		if (* answer != 'y' && * answer != 'Y')
		{
			printf ("setup cancelled\n");
			exit (0);
		}
	}

	fp = fopen (makef, "w");
	if (fp == (FILE *) 0)
	{
		Error ("can't open %s.\n", makef);
		exit (-1);
	}

	if (silent_mode)
		printf ("generating makefile - this may take a while\n");
	GenHeader (fp);
	GenFiles (fp);
	GenMisc (fp);
	GenTags (fp);
	GenDo (fp);
	GenReply (fp);
	GenPack (fp);
	GenUnpack (fp);
	GenSetup (fp);
	GenTryCap (fp);
	GenProto (fp);
	GenCleanup (fp);
	GenFtp (fp);
	GenPatch (fp);
	GenAllDependencies (fp);

	if (! silent_mode)
		EndInfo ();
	else
		printf ("makefile ready\n");
	exit (0);
}
