#include "message.h"
#include "list.h"
#include <stdio.h>
#include <varargs.h>

char * args [] = {
	"mail",
	"-s",
	(char *) 0,	/* subject */
	(char *) 0,	/* to */
	(char *) 0
};

void AddText (p, va_alist)
int p;
va_dcl
{
	va_list args;
	char * ptr;
	char buf [100];

	va_start (args);
	ptr = va_arg (args, char *);
	(void) vsprintf (buf, ptr, args);
	va_end (args);

	write (p, buf, strlen (buf));
}

void AddGroups (p, list)
int p;
List list;
{
	char * ptr;

	AddText (p, "The following list(s) exist:\n");
	for (ptr = FirstGroup (list); ptr != (char *) 0; ptr = NextGroup (list))
			AddText (p, "\t* %s\n", ptr);
}

void AddHelp (p, list)
int p;
List list;
{
	char * ptr;

	AddText (p, "Help on the mailing lists:\n\n");
	AddText (p, "Subject: ML ADD (<group>, <full-name>, <address>)\n");
	AddText (p, "\tThis will add you to the 'group' mailing list.\n\n");
	AddText (p, "Subject: ML FW (<group>, <subject>)\n");
	AddText (p,
"\tThis will forward the message to all the members in this group.\n\n");
	AddText (p, "Subject: ML DELETE (<group>, <address>)\n");
	AddText (p, "\tThis will delete you from the mailing list\n\n");
	AddText (p, "Subject: ML HELP\n");
	AddText (p, "Subject: ML HELP (<address>)\n");
	AddText (p, "\tThis help.\n\n");
	AddGroups (p, list);
}

void Message (type, list, group, user, address, from)
int type;
List list;
char * group, * user, * address, * from;
{
	FILE * pp;
	char * to, * ptr;
	char command [100];
	int pid;
	int p [2];

	if (pipe (p) < 0)
	{
		fprintf (stderr, "pipe failed.\n");
		perror ("pipe");
		exit (1);
	}

	args [2] = "ML: auto reply";
	args [3] = address [0] == '\0' ? from : address;

	pid = fork ();
	switch (pid)
	{

	case -1:
		fprintf (stderr, "fork failed.\n");
		perror ("fork");
		exit (-1);
	
	case 0:
		close (0);
		dup (p [0]);
		close (p [0]);
		close (p [1]);
		close (1);
		close (2);
		(void) open ("/dev/null", 1);
		(void) open ("/dev/null", 1);
		execvp ("mail", args);
		close (2);
		(void) open ("/dev/tty", 1);
		perror ("execvp");
		exit (1);
	
	default:
		close (p [0]);

		switch (type)
		{

		case MES_ADDED:
			AddText (p [1],
			  "You have been added to the '%s' mailing list.\n",
				group);
			break;
		
		case MES_UNKNOWN_GROUP:
			AddText (p [1],
			  "The mailing list '%s' doesn't exists.\n",
							group);
			AddGroups (p [1], list);
			break;
		
		case MES_DELETED:
			AddText (p [1],
			  "You have been deleted from the '%s' mailing list.\n",
				group);
			break;

		case MES_UNKNOWN_USER:
			AddText (p [1],
	    "Couldn't find your email address (%s) in my mailing list\n",
					address);
			AddText (p [1],
			  "Usage: ML DELETE (<group>, <address>)\n");
			break;

		case MES_HELP:
			AddHelp (p [1], list);
			break;
		}

		close (p [1]);
		wait ((int *) 0);
		break;
	}
}
