#include <stdio.h>
#include "dlist.h"
 
typedef struct s_entry_info ENTRYINFO, * EntryInfo;
typedef struct s_dlist_info DLISTINFO, * DListInfo;

struct s_dlist_info
{
	EntryInfo head, tail, current;
	int nr_elems;
	int sizeof_entry;
};

extern char * malloc ();

struct s_entry_info
{
	EntryInfo next, prev;
};

DLISTPTR DLNew (dlist_info_size, entry_info_size)
int dlist_info_size, entry_info_size;
{
	char * ptr;
	DListInfo dlinfo;

	ptr = malloc ((unsigned) dlist_info_size + sizeof (DLISTINFO));
	dlinfo = (DListInfo) ptr;
	dlinfo-> head = dlinfo-> tail = dlinfo-> current = (EntryInfo) 0;
	dlinfo-> nr_elems = 0;
	dlinfo-> sizeof_entry = entry_info_size;

	return (DLISTPTR) (ptr + sizeof (DLISTINFO));
}

int DLElems (dlist)
DLISTPTR dlist;
{
	DListInfo dlinfo;

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	return dlinfo-> nr_elems;
}

void DLSetCurrent (dlist, pos)
DLISTPTR dlist;
int pos;
{
	DListInfo dlinfo;

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));

	switch (pos)
	{

	case HEAD:
		dlinfo-> current = dlinfo-> head;
		break;
	
	case TAIL:
		dlinfo-> current = dlinfo-> tail;
		break;
	
	case NEXT:
		if (dlinfo-> current != (EntryInfo) 0)
			dlinfo-> current = dlinfo-> current-> next;
		break;
	
	case PREV:
		if (dlinfo-> current != (EntryInfo) 0)
			dlinfo-> current = dlinfo-> current-> prev;
		break;
	}
}

ENTRYPTR DLAddElem (dlist, pos)
DLISTPTR dlist;
int pos;
{
	EntryInfo einfo;
	DListInfo dlinfo;

	DLSetCurrent (dlist, pos);

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	einfo = (EntryInfo) malloc ((unsigned) sizeof (ENTRYINFO) + 
				dlinfo-> sizeof_entry);

	if (dlinfo-> current == (EntryInfo) 0)
	{
		einfo-> next = einfo-> prev = (EntryInfo) 0;
		dlinfo-> head = dlinfo-> tail = einfo;
	}
	else
	{
		einfo-> prev = dlinfo-> current;
		einfo-> next = dlinfo-> current-> next;
		if (einfo-> next != (EntryInfo) 0)
			einfo-> next-> prev = einfo;
		else
			dlinfo-> tail = einfo;
		if (einfo-> prev != (EntryInfo) 0)
			einfo-> prev-> next = einfo;
		else
			dlinfo-> head = einfo;
	}

	dlinfo-> current = einfo;
	dlinfo-> nr_elems ++;

	return (ENTRYPTR) ((char *) einfo + sizeof (ENTRYINFO));
}

ENTRYPTR DLInsElem (dlist, pos)
DLISTPTR dlist;
int pos;
{
	EntryInfo einfo;
	DListInfo dlinfo;

	DLSetCurrent (dlist, pos);

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	einfo = (EntryInfo) malloc ((unsigned) sizeof (ENTRYINFO) + 
				dlinfo-> sizeof_entry);

	if (dlinfo-> current == (EntryInfo) 0)
	{
		einfo-> next = einfo-> prev = (EntryInfo) 0;
		dlinfo-> head = dlinfo-> tail = einfo;
	}
	else
	{
		einfo-> prev = dlinfo-> current-> prev;
		einfo-> next = dlinfo-> current;
		if (einfo-> prev != (EntryInfo) 0)
			einfo-> prev-> next = einfo;
		else
			dlinfo-> head = einfo;
		if (einfo-> next != (EntryInfo) 0)
			einfo-> next-> prev = einfo;
		else
			dlinfo-> head = einfo;
	}

	dlinfo-> current = einfo;
	dlinfo-> nr_elems ++;

	return (ENTRYPTR) ((char *) einfo + sizeof (ENTRYINFO));
}

void DLDelete (dlist, pos, freefunc)
DLISTPTR dlist;
int pos;
void (* freefunc) ();
{
	EntryInfo einfo;
	DListInfo dlinfo;

	if (pos != CURRENT)
		DLSetCurrent (dlist, pos);

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	einfo = dlinfo-> current;
	if (einfo != (EntryInfo) 0)
	{
		if (einfo == dlinfo-> head)
			dlinfo-> head = einfo-> next;
		else
			einfo-> prev-> next = einfo-> next;
		
		if (einfo == dlinfo-> tail)
			dlinfo-> tail = einfo-> prev;
		else
			einfo-> next-> prev = einfo-> prev;
		
		if (freefunc != FREE)
			(* freefunc) ((ENTRYPTR) ((char *) einfo +
						sizeof (ENTRYINFO)));
		(void) free ((char *) einfo);

		dlinfo-> nr_elems --;
	}
}

ENTRYPTR DLGet (dlist, pos)
DLISTPTR dlist;
int pos;
{
	DListInfo dlinfo;

	DLSetCurrent (dlist, pos);

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));

	if (dlinfo-> current == (EntryInfo) 0)
		return (ENTRYPTR) 0;
	else
		return (ENTRYPTR) ((char *) dlinfo-> current +
				   sizeof (ENTRYINFO));
}

void DLCall (dlist, func)
DLISTPTR dlist;
void (* func) ();
{
	DListInfo dlinfo;
	EntryInfo entry;

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));

	for (entry = dlinfo-> head; entry != (EntryInfo) 0;
				entry = entry-> next)
		(* func) ((ENTRYPTR) ((char *) entry + sizeof (ENTRYINFO)));
}

void DLWrite (dlist, fp, writefunc)
DLISTPTR dlist;
FILE * fp;
void (* writefunc) ();
{
	DListInfo dlinfo;
	EntryInfo entry;

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	fwrite (& (dlinfo-> nr_elems), sizeof (int), 1, fp);

	for (entry = dlinfo-> head; entry != (EntryInfo) 0;
				entry = entry-> next)
		if (writefunc != (void (*) ()) 0)
			(* writefunc) (fp, (ENTRYPTR) ((char *) entry +
						sizeof (ENTRYINFO)));
		else
			if (fwrite ((char *) entry + sizeof (ENTRYINFO),
				dlinfo-> sizeof_entry, 1, fp) != 1)
						perror ("fwrite");
}

void DLRead (dlist, fp, readfunc)
DLISTPTR dlist;
FILE * fp;
void (* readfunc) ();
{
	DListInfo dlinfo;
	ENTRYPTR entry;
	int nelems, i;

	dlinfo = (DListInfo) ((char *) dlist - sizeof (DLISTINFO));
	fread (& nelems, sizeof (int), 1, fp);
	for (i = 0; i < nelems; i ++)
	{
		entry = DLAddElem (dlist, TAIL);
		if (readfunc != (void (*) ()) 0)
			(* readfunc) (fp, entry);
		else
			if (fread ((char *) entry, dlinfo-> sizeof_entry,
						1, fp) != 1)
				perror ("fread");
	}
}

void DumpList (list)
DLISTPTR list;
{
	DListInfo dlinfo;
	EntryInfo einfo;

	dlinfo = (DListInfo) ((char *) list - sizeof (DLISTINFO));

	printf ("*** DUMPING FROM LIST [%06d] ***\n", (int) list);
	printf ("Address: %06d   # elems = %d\n",
				(int) dlinfo, dlinfo-> nr_elems);
	printf ("[Current = %06x]   [Head = %06x]   [Tail = %06x]\n\n",
		(int) dlinfo-> current,
		(int) dlinfo-> head,
		(int) dlinfo-> tail);

	for (einfo = dlinfo-> head; einfo; einfo = einfo-> next);
		printf ("[Address = %06x]   [Next = %06x]   [Prev = %06x]\n",
			(int) einfo, (int) einfo-> next, (int) einfo-> prev);
}
