#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"
#include "census.h"
#include "nation.h"

void RedoUpgrade ()
{
	Ship next;
	char nextfl;

	if (last_layout == SHIP_MODE)
	{
		next = sh_nxtsct (curship);
		UpgradeShip (Fmt ("%d", sh_nr (curship)));
		curship = next;
		CensusShip (curship);
		DrawSector (cursct);
	}
	else if (last_layout == FLEET_MODE)
	{
		nextfl = GiveNextFleetInSct (cursct, curfleet);
		UpgradeShip (FleetId ());
		curfleet = nextfl;
		CensusFleet (nextfl);
		DrawSector (cursct);
	}
	else
	{
		Message ("No current ship/fleet selected");
		Bell ();
	}
}
	/*
	 *	There is no binding to upgrade.
	 *	This routine should only be called with owned ships
	 */

void UpgradeShip (what)
char * what;
{
	int points;
	int w_p_eff;
	Ship ptr, next;
	int n;
	char buffer [1024];

	if (! s_owned (cursct) || s_des (cursct) != 'h' || s_eff (cursct) < 60)
	{
		Message ("Only upgrades in 60% harbors");
		Bell ();
		return;
	}

	if (! Confirm (Fmt ("Upgrade %s", what), True))
	{
		Message ("Upgrade cancelled");
		return;
	}

	UnmarkAllShips ();
	MarkShips (what);
	SetAgain (RedoUpgrade);

	n = 0;
	ptr = shiplist;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr))
		{
			next = sh_next (ptr);
			w_p_eff = (shiptypes [sh_type (ptr)]. lcm / 2) +
				   shiptypes [sh_type (ptr)]. hcm ;
			points = s_ava (cursct) * 100 / w_p_eff;

			if (points < 20)
			{
				Message (Fmt (
					"Not enough available work (need %d)",
					1 + (w_p_eff * 20) / 100));
				Bell ();
				break;
			}

			if (sh_eff (ptr) < 60)
			{
				Warning (Fmt ("%s #%d not efficient enough",
					ShipName (ptr), sh_nr (ptr)));
				ptr = next;
				continue;
			}

			if (sh_tech (ptr) >= (int) n_tech (nation))
			{
				Warning (Fmt ("%s #%d has already tech %d",
					ShipName (ptr), sh_nr (ptr),
					sh_tech (ptr)));
				ptr = next;
				continue;
			}

			if (n ++ == 0)
				buffer [0] = '\0';
			else
				strcat (buffer, "/");

			strcat (buffer, Fmt ("%d", sh_nr (ptr)));
			set_ava (cursct, (s_ava (cursct) * 100 - w_p_eff * 20) /
						100);
			inc_sh_eff (ptr, -35);
			set_sh_tech (ptr, n_tech (nation));

			ptr = next;
		}
		else
			ptr = sh_next (ptr);
	
	if (n == 0)
	{
		Message ("No ships upgraded");
		Bell ();
		return;
	}

	FeedCommand (Fmt ("upgrade %s", buffer), PRINT);
	Census ();
	DrawSector (cursct);
}
