#include "type.h"
#include "main.h"
#include "census.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "sector.h"

#define SORT_NR		0
#define	SORT_SECTOR	1
#define	SORT_TYPE	2
#define	SORT_FLEET	3
#define	SORT_OWNER	4

#define SORT_MAX_O	4
#define SORT_MAX_E	5

#define OWN  		0
#define ENEMY           1

static char * list_ships_how [] = 
{
	"sort by number",
	"sort by sector",
	"sort by ship-type",
	"sort by fleet",
	"sort by owner",
	(char *) 0
};

static char * fleet_chars =
	"~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

static int AddShipToStrings (strings, ship, enemy)
Strings strings;
Ship ship;
{
  if ((sh_owned(ship)) && (enemy == OWN))

      {
	AddString (strings, Fmt (
			       "%4d %-14.14s %4d,%-4d %c %3d%% %3d %3d %3d %3d %3d  %3d  %3d ",
			       sh_nr (ship),
			       ShipName (ship),
			       sh_xcd (ship),
			       sh_ycd (ship),
			       sh_fleet (ship),
			       sh_eff (ship),
			       sh_mob (ship),
			       sh_moves (ship),
			       sh_pln (ship),
			       sh_mil (ship),
			       sh_civ (ship),
			       sh_foo (ship),
			       sh_tech (ship)));
	return 1;
      }
  
  else if ( !(sh_owned(ship)) && (enemy == ENEMY))

    {
      AddString (strings, Fmt (
	    "%4d %-14.14s %-14.14s %4d,%-4d ",
			sh_nr (ship),
			ShipName (ship),
			(CountryName(sh_owner (ship))),
			sh_xcd (ship),
			sh_ycd (ship)));
      return 1;
    }
  else
    return 0;
}

void ListShips (x, y, enemy)
int x, y, enemy;
{
	Strings strings;
	Pager pager;
	int i, j;
	int total;
	Sector sct;
	Ship ptr;
	char * ch;
	bool empty_line;

	strings = InitStrings ();
	AddStringsID (strings, list_ships_how,
		      enemy == OWN ? SORT_MAX_O : SORT_MAX_E,
		      0);
	pager = InitPager (strings, "Listing of ships");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);
	if (i < 0)
	{
		Message ("No listing");
		return;
	}

	strings = InitStrings ();
	Message ("generating list");
	if (enemy == OWN)
	  AddString (strings, 
		     "   #    type           x,y    w  eff  mob muv pln mil civ food tech");
	else
	  
	  AddString (strings, "   #    type         Owner            x,y    ");
	
	total = 0;
	switch (i)
	{

	case SORT_NR:
		for ALL_SHIPS (ptr)
		{
		  if (AddShipToStrings (strings, ptr, enemy))
		    {
		      empty_line = True;
		      total ++;
		    }
		}
		break;
	
	case SORT_SECTOR:
		for (x = - MAX_X / 2; x <= MAX_X / 2; x ++)
			for (y = - MAX_Y / 2; y <= MAX_Y / 2; y++)
			{
				sct = World (x, y, S_EXIST);
				if (sct == (Sector) 0)
					continue;

				empty_line = False;
				for (ptr = s_fship (sct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				     total ++;
				   }
				}

				if (empty_line)
					AddString (strings, "");
			}
		break;
	
	case SORT_TYPE:
		for (j = 0; shiptypes [j]. nam != (char *) 0; j ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_type (ptr) == j)
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			
			if (empty_line)
				AddString (strings, "");
		}
		break;
	
	case SORT_FLEET:
		for (ch = fleet_chars; * ch != '\0'; ch ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_fleet (ptr) == * ch)
				  {
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			      }
			if (empty_line)
				AddString (strings, "");
		}

	case SORT_OWNER:

		for (j = 0; j < MAX_NATIONS ; j ++)
		{
			empty_line = False;

			for ALL_SHIPS (ptr)
			{
				if (sh_owner (ptr) == j)
				{
				  if (AddShipToStrings (strings, ptr, enemy))
				    {
				      empty_line = True;
				      total ++;
				    }
				}
			}
			
			if (empty_line)
				AddString (strings, "");
		}
		break;
	
		break;
	}

	if (total == 0)
	{
		Message ("No info on ships !");
		FreeStrings (strings);
		Bell ();
		return;
	}

	AddString (strings, Fmt ("%d ships", total));
#ifdef X_VERSION
	InitWMPager (strings, "List of all ships");
#else /* TERMC_VERSION */
	ShowStringsInPager (strings, "List of all ships");
#endif /* VERSION */
}
