#include "type.h"
#include "main.h"
#include "census.h"
#include "var.h"
#include "ship.h"
#include "sector.h"


	/*
	 *	# maximum # of ships thta fits at the census screen
	 */

#define MAX_CEN_SHIPS	50


char curfleet = '\0';

char GiveNextFleetInSct (sct, fleet)
Sector sct;
char fleet;
{
	char next;
	Ship ship;

	next = fleet;

	for (ship = s_fship (sct); ship != (Ship) 0; ship = sh_nxtsct (ship))
		if (next < sh_fleet (ship) && sh_fleet (ship) > fleet)
			next = sh_fleet (ship);

	if (next > fleet)
		return next;
	
	next = '~';
	for (ship = s_fship (sct); ship != (Ship) 0; ship = sh_nxtsct (ship))
		if (sh_fleet (ship) < next)
			next = sh_fleet (ship);

	return next;
}

int FleetMinMob (fleet)
char fleet;
{
	Ship ptr;
	int min_mob;

	min_mob = MAX_SHIPMOB;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet && ptr-> mob < min_mob)
			min_mob = ptr-> mob;
	
	return min_mob;
}

bool FleetEmpty (fleet)
char fleet;
{
	Ship ptr;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet)
			return False;

	return True;
}

bool FleetColocated (fleet)
char fleet;
{
	bool found;
	int x, y;
	Ship ptr;

	found = False;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet)
			if (! found)
			{
				x = ptr-> x;
				y = ptr-> y;
				found = True;
			}
			else
			{
				if (x != ptr-> x || y != ptr-> y)
					return False;
			}

	return True;
}

long ShipNrAbils (shipnr)
int shipnr;
{
	Ship ship;

	ship = NrToShip (shipnr);

	if (ship == (Ship) 0)
		return 0L;
	else
		return shiptypes [ship-> type]. flags;
}

long FleetAbils (fleet)
char fleet;
{
	long abils;
	Ship ptr;

	abils = 0L;


	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet)
			abils |= shiptypes [ptr-> type]. flags;
	
	return abils;
}

Sector FleetSector (fleet)
char fleet;
{
	Ship ptr;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet)
			return World (ptr-> x, ptr-> y, S_DESIG);
	
	return (Sector) 0;
}

void MoveFleet (fleet, sct)
char fleet;
Sector sct;
{
	Ship ptr;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (ptr-> fleet == fleet)
			MoveShip (ptr, sct);
}

char FirstFleetInSct (sct)
Sector sct;
{
	if (s_fship (sct) == (Ship) 0)
		return '\0';
	else
		return sh_fleet (s_fship (sct));
}

char * FleetId ()
{
	bool first;
	static char buffer [1024];
	Ship ptr;

	if (! FleetColocated (curfleet))
	{
		buffer [0] = '\0';
		first = True;

		for (ptr = s_fship (cursct); ptr != (Ship) 0;
							ptr = sh_nxtsct (ptr))
			if (sh_fleet (ptr) == curfleet)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");
				
				strcat (buffer, Fmt ("%d", sh_nr (ptr)));
			}
		
		return buffer;
	}
	else
		return Fmt ("%c", curfleet);
}

static void CalcFreeFleets (upper, lower)
bool upper [], lower [];
{
	Ship ptr;
	register i;

	for (i = 0; i < 26; i ++)
		upper [i] = lower [i] = True;
	

	for ALL_SHIPS (ptr)
		if (isupper (sh_fleet (ptr)))	
			upper [sh_fleet (ptr) - 'A'] = False;
		else if (islower (sh_fleet (ptr)))
			lower [sh_fleet (ptr) - 'a'] = False;
	
}

void ShowFreeFleets ()
{
	char * ptr;
	bool upper [26], lower [26];

	CalcFreeFleets (upper, lower);
	ptr = MakeFreeString (upper, lower);

	if (strlen (ptr) == 0)
		Message ("No free fleets");
	else
		Message (Fmt ("Free fleets: %s", ptr));
}

char FirstFreeFleet ()
{
	int i;
	bool upper [26], lower [26];

	for (i = 0; i < 26; i ++)
		if (lower [i])
			return 'a' + i;

	for (i = 0; i < 26; i ++)
		if (upper [i])
			return 'A' + i;

	return '\0';
}
