#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

static Ship last_ship;

void BindBoard (x, y, str)
int x, y;
char * str;
{
	if (str != (char *) 0)
		Warning ("You can't bind 'board' with arguments");

	DoBoard (x, y, (Ship) 0);
}

void Board (x, y)
int x, y;
{
	DoBoard (x, y, (Ship) 0);
}

void RedoBoard (x, y)
{
	DoBoard (x, y, last_ship);
}

void DoBoard (x, y, fromship)
int x, y;
Ship fromship;
{
	Strings strings;
	Pager pager;
	Ship ship;
	int select, nr, mils;
	bool succes, gotmils, gotmob;
	char *ptri, *line;

	if (last_layout != SHIP_MODE || curship == (Ship) 0)
		return;

	if (sh_owned (curship))
	{
		Message ("That's your own ship, use tend command !!");
		Bell ();
		return;
	}

	gotmob = gotmils = False;

	if (fromship == (Ship) 0)
	{
		nr = 0;
		strings = InitStrings ();

		for (ship = s_fship (cursct); ship != (Ship) 0;
						ship = sh_nxtsct (ship))
		{
			if (! sh_owned (ship))
				continue;

			nr++;
			if ((mils = sh_mil (ship)) > 0 && sh_civ (ship) == 0)
				mils -= 2;

			if (mils <= 0)
				continue;

			gotmils = True;

			if (sh_mob (ship) <= 0)
				continue;

			gotmob = True;

			AddStringID (strings, Fmt ("%s #%d @ %s (%d mils)",
						ShipName (ship),
						sh_nr (ship),
						CrdStr (cursct),
						mils),
					sh_nr (ship));
		}

		if (nr == 0)
		{
			Message ("No ships nearby the target sector");
			Bell ();
			FreeStrings (strings);
			return;
		}

		if (! gotmils)
		{
			Message (
			  "None of the ships have (enough) militairs on board");
			Bell ();
			FreeStrings (strings);
			return;
		}
		else if (! gotmob)
		{
			Message ("None of the ships have (enough) mobility");
			Bell ();
			FreeStrings (strings);
			return;
		}
			
		pager = InitPager (strings,
			Fmt ("Board %s (owner %s) from which ship ?",
				ShipName (curship),
				CountryName (sh_owner (curship))));


		MapPagerFromTop (pager, map_win, x, y);
		select = PagerMenu (pager);
		FreePager (pager);
		FreeStrings (strings);

		if (select < 0)
		{
			Message ("Chicken !!!");
			return;
		}

		fromship = NrToShip (select);
	}
	else
	{
		if (sh_mob (fromship) <= 0)
		{
			Message (Fmt ("%s #%d doesn't have enough mobility",
				ShipName (fromship), sh_nr (fromship)));
			Bell ();
			last_ship = (Ship) 0;
			return;
		}

		if (sh_mil (fromship) < 2)
		{
			Message ("Need two mils to board");
			Bell ();
			last_ship = (Ship) 0;
			return;
		}

		select = sh_nr (fromship);
	}

	SetAgain (RedoBoard);
	last_ship = fromship;

	FeedEmpire (Fmt ("board %d %d", sh_nr (curship), select), PRINT);

	succes = False;

	for (;;)
	{
		line = ReadEmpire (PRINT);
		if (line == (char *) 0)
			break;

		if (EmpireStatus () == E_COMMAND)
		{
			Bell ();
			Message ("Board failed");
			PrintAtEmpire (line);
			break;
		}

		ptri = strchr (line, 'V');
		if (ptri != (char *) 0 &&
			StrEQ (ptri, "Victim ship moves faster than you do"))
		{
			Bell ();
			Message ("Sorry Boss, ship is too fast");
			break;
		}

		ptri = strchr (line, 'Y');
		if (ptri != (char *) 0 &&
			StrEQ (ptri, "You have been repelled"))
		{
			Bell ();
			Message ("Sorry Boss, seems we've been defeated");
			break;
		}

		ptri = strchr (line, 'B');
		if (ptri != (char *) 0 &&
			StrEQ (ptri, "Boarding successful"))
		{
			Bell ();
			succes = True;
			Message ("Veni Vedi Vici !!!");
			break;
		}
	}

	(void) WaitForPrompt (PRINT);
	CheckShips (	
		succes ? Fmt ("%d/%d", sh_nr (fromship), sh_nr (curship)) 
		       : Fmt ("%d", fromship));

	CensusShip (curship);
}
