#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"

void RedoScrapPlane ()
{
	Plane next;
	char nextwing;

	if (last_layout == PLANE_MODE)
	{
		next = pl_nxtsct (curplane);
		ScrapPlane (Fmt ("%d", pl_nr (curplane)));
		curplane = next;
		if (curplane != (Plane) 0)
			CensusPlane (curplane);
		else
			Census ();
		DrawSector (cursct);
	}
	else if (last_layout == WING_MODE)
	{
		nextwing = GiveNextWingInSct (cursct, curwing);
		ScrapPlane (WingId ());
		if (nextwing != ' ' && nextwing != '\0')
		{
			curwing = '\0';
			Census ();
		}
		else
		{
			curwing = nextwing;
			CensusWing (curwing);
		}
		DrawSector (cursct);
	}
	else
	{
		Message ("No current plane/wing selected");
		Bell ();
	}
}
	

	/*
	 *	There is no binding to scrap.
	 */

void ScrapPlane (what)
char * what;
{
	Plane ptr, next;
	int inc_lcm, inc_hcm;
	int nr;

	UnmarkAllPlanes ();
	MarkPlanes (what);

	if (! s_owned (cursct) || s_des (cursct) != '*' || s_eff (cursct) < 60)
	{
		Message ("Only scrapping in +60% airports");
		Bell ();
		return;
	}

	Message (Fmt ("Scrapping %s", what));

	if (! Confirm (Fmt ("Scrap %s", what), True))
	{
		Message ("Scrap plane cancelled");
		return;
	}

	FeedCommand (Fmt ("scrap plane %s", what), PRINT);
	SetAgain (RedoScrapPlane);

	ptr = first_plane;
	nr = inc_lcm = inc_hcm = 0;
	while (ptr != (Plane) 0)
		if (pl_marked (ptr))
		{
			next = pl_next (ptr);

			inc_lcm += (planetypes [pl_type (ptr)]. lcm * 2) / 3;
			inc_hcm += (planetypes [pl_type (ptr)]. hcm * 2) / 3;
			nr ++;

			DeletePlane (ptr);
			ptr = next;
		}
		else
			ptr = pl_next (ptr);
	
	if (nr == 0)
	{
		Message ("No planes scrapped");
		Bell ();
		return;
	}

	set_q_lcm (cursct, q_lcm (cursct) + inc_lcm);
	set_q_hcm (cursct, q_hcm (cursct) + inc_hcm);
	Message (Fmt ("%d planes scrapped", nr));
	Census ();
	DrawSector (cursct);
}
