#include "main.h"
#include "sector.h"
#include "version.h"

#define	VERSION		"version 4.08"

static WinInfo ver_win;

void ShowVersion ()
{
	ver_win = OpenWindow (map_win, 5, 0, 50, 16, CHARS, MENU, 0);

	PrintB (ver_win, 19, 1, "-=[ XEMP ]=-");
	PrintN (ver_win, 1, 3, "Written by:");
	PrintN (ver_win, 1, 4, "    Henk-Jan Visscher");
	PrintN (ver_win, 1, 6, "With help from:");
	PrintN (ver_win, 1, 7, "    Maarten-Jan Huisjes");
	PrintN (ver_win, 1, 8, "    Michiel Huisjes");
	PrintN (ver_win, 1, 9, "    Daniel J. Hazekamp");
	PrintN (ver_win, 1, 10, "    Heinola Kari Pekka");
	PrintN (ver_win, 1, 11, "    Julian Onions");
	PrintN (ver_win, 1, 12, "    J{rvinen Markku");
	PrintN (ver_win, 1, 14, VERSION);
	PrintN (ver_win, 1, 15, Fmt ("Compiled: %s", COM_DATE));

	FlushWindow (ver_win);
}

void EndVersion ()
{
	DestroyWindow (ver_win);
}


static long options_defined;

static void KSUSetOption (option)
long option;
{
	options_defined |= option;
}

bool KSUOption (option)
long option;
{
	return ((options_defined & option) == option);
}


struct s_option
{
	char * name;
	long option;
};

static struct s_option ksu_options [] =
{

	{ "ALLYHARBOR",			ALLYHARBOR },
	{ "SHOWPLANE",			SHOWPLANE },
	{ "DROPANY",			DROPANY },
	{ "REJECTS",			REJECTS },
	{ "BMAP",			BMAP },
	{ "SCUTTLE",			SCUTTLE },
	{ "CONVASAT",			CONVASAT },
	{ "ABM",			ABM },
	{ "GRIND",			GRIND },
	{ "PINPOINTMISSILE",		PINPOINTMISSILE },
	{ "FALLOUT",			FALLOUT },
	{ "MISSINGMISSILES",		MISSINGMISSILES },
	{ "SHIPNAMES",			SHIPNAMES },
	{ "NEUTRON",			NEUTRON },
	{ "BETTERABM",			BETTERABM },
	{ "RANGEEDIT",			RANGEEDIT },
	{ "MISSDEF",			MISSDEF },
	{ "SHIPSAM",			SHIPSAM },
	{ "BIND",			BIND },
	{ "DEMANDUPDATE",		DEMANDUPDATE },
	{ "FIXEDTRADEPRIZES",		FIXEDTRADEPRIZES },
	{ "TRADEREQUIRESTECH",		TRADEREQUIRESTECH },
	{ "TRADESHIPINHARBOR",		TRADESHIPINHARBOR },
	{ "NOPLANETELEPORT",		NOPLANETELEPORT },
	{ "TRADECHECKRELATIONS",	TRADECHECKRELATIONS },
	{ "NONUKETRADE",		NONUKETRADE },
	{ "MERC",			MERC },
	{ (char *) 0,			(long) 0 }
};

void KSUNotDefined (option)
long option;
{
	struct s_option * ptr;
	char * option_name;

	option_name = (char *) 0;
	for (ptr = ksu_options; ptr-> name != (char *) 0; ptr ++)
		if (ptr-> option == option)
		{
			option_name = ptr-> name;
			break;
		}
	
	if (option_name == (char *) 0)
		Message ("This option is not enabled in this game!");
	else
		Message ("Option \"%s\" is not enabled in this game",
			option_name);
	Bell ();
}

void FScanVersion ()
{
	char * line;
	bool scan_options;
	register struct s_option * ptr;

	bool size_set, sec_per_etu_set, etu_per_update_set, fgrate_set;
	bool fcrate_set, obrate_set, uwbrate_set , eatrate_set, babyeat_set;
	bool bankint_set, mon_cset, mon_mset;

	size_set = sec_per_etu_set = etu_per_update_set = fgrate_set = 
	fcrate_set = obrate_set = uwbrate_set  = eatrate_set =
	babyeat_set = bankint_set = mon_cset = mon_mset = False;

	FeedEmpire ("version", PRINT);
	PrintAtEmpire ("xemp scanning version info");

	scan_options = False;
	ksu_version = False;

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);

		if (StrStr (line, "KSU") != (char *) 0)
			ksu_version = True;

		if (EmpireStatus () == E_COMMAND || line == (char *) 0)
			break;
		
		if (*line == '\0' || *line == '\n')
			continue;

		if (! size_set &&
			sscanf (line, "World size is %d by %d", &ver_max_x,
							    &ver_max_y) == 2) {
			size_set = True;
			continue;
		}

		if (! sec_per_etu_set &&
			sscanf (line, "An Empire time unit is %d", 
					&sec_per_etu) == 1) {
			sec_per_etu_set = True;
			continue;
		}

		if (! etu_per_update_set &&
			sscanf (line, "An update consists of %d",
							& etu_per_update) == 1)
		{
			etu_per_update_set = True;
			continue;
		}

		if (! bankint_set &&
			sscanf (line, "Banks pay $%lf", & bankint) == 1)
		{
			bankint /= 1000;
			bankint_set = True;
			continue;
		}

		if (! mon_cset &&
	sscanf (line,
		"1000 civilians generate $%lf, uncompensated workers $%lf each",
			& money_civ, & money_uw) == 2)
		{
			money_civ /= 1000;
			money_uw /= 1000;
			mon_cset = True;
			continue;
		}

		if (! mon_mset &&
	sscanf (line, "1000 active military cost $%lf, reserves cost $%lf",
			& money_mil, & money_res) == 2)
		{
			money_mil /= - 1000;
			money_res /= - 1000;
			mon_mset = True;
			continue;
		}


		if (! fgrate_set &&
			sscanf (line,
			"A non-aggi, 100 fertility sector can grow %lf",
			&fgrate) == 1) {
			fgrate_set = True;
			fgrate = fgrate / 100.0;
			continue;
		}

		if (! fcrate_set &&
			sscanf (line, "1000 civilians will harvest %lf",
			&fcrate) == 1) {
			fcrate_set = True;
			fcrate = fcrate / 1000.0;
			continue;
		}

		if (! obrate_set &&
			sscanf (line, "1000 civilians will give birth to %lf",
			&obrate) == 1)
		{
			obrate_set = True;
			obrate = obrate / 1000.0;
			continue;
		}

		if (! uwbrate_set &&
			sscanf (line,
			"1000 uncompensated workers will give birth to %lf",
			&uwbrate) == 1) {
			uwbrate_set = True;
			uwbrate = uwbrate / 1000.0;
			continue;
		}

		if (! eatrate_set && 
			strcmp (line, "No food is needed!!") == 0) {
			eatrate = 0.0;
			no_food = eatrate_set = True;
		}

		if (! eatrate_set &&
			sscanf (line, "In one time unit, 1000 people eat %lf",
			&eatrate) == 1) {
			eatrate_set = True;
			eatrate = eatrate / 1000.0;
			continue;
		}
	
		if (! babyeat_set &&
			sscanf (line, "1000 babies eat %lf", &babyeat) == 1) {
			babyeat_set = True;
			babyeat = babyeat / 1000.0;
			continue;
		}

		if (ksu_version && ! scan_options &&
				StrStr (line, "Options enabled"))
		{
			scan_options = True;
			continue;
		}

		if (scan_options)
			for (ptr = ksu_options; ptr-> name != (char *) 0;
								ptr ++)
				if (StrStr (line, ptr-> name))
					KSUSetOption (ptr-> option);
	}

	if (EmpireStatus () == E_COMMAND) {
		PrintAtEmpire ("");
		PrintAtEmpire (line);
	} else
		(void) WaitForPrompt (PRINT);

	if (size_set && sec_per_etu_set && etu_per_update_set && fgrate_set &&
	    obrate_set && uwbrate_set  && eatrate_set && babyeat_set &&
	    bankint_set && mon_cset && mon_mset)
		return;

	Bell ();

	if (! size_set) {
		PrintAtEmpire ("Version Warning: can't get worldsize");
		ver_max_x = MAX_X;
		ver_max_y = MAX_Y;
	}

	if (! sec_per_etu_set)
		PrintAtEmpire ("Version Warning: can't get # seconds per etu");
	if (! etu_per_update_set)
		PrintAtEmpire ("Version Warning: can't get # etu per update");
	if (! fgrate_set || ! fcrate_set || ! eatrate_set || ! babyeat_set)
	      PrintAtEmpire ("Version Warning: can't get food growth/eat info");
	if (! obrate_set || ! uwbrate_set)
		PrintAtEmpire ("Version Warning: can't get birth rate info");
	if (! bankint_set)
		PrintAtEmpire ("Version Warning: can't get bank interest");
	if (! mon_cset)
		PrintAtEmpire ("Version Warning: can't get taxes for civs/uws");
	if (! mon_mset)
		PrintAtEmpire ("Version Warning: can't get taxes for mils/res");

	Pause ();
}

void SaveVersion (fp)
FILE *fp;
{

	fprintf (fp,
	"%dx%d %d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %d %ld\n",
			ver_max_x, ver_max_y, etu_per_update, sec_per_etu,
			fgrate, fcrate, eatrate, babyeat, obrate, uwbrate,
			bankint, money_civ, money_uw, money_mil, money_res,
			ksu_version, options_defined);
}

void RestoreVersion (fp)
FILE *fp;
{
	char buffer[BUFSIZ];
	int ksu;

	if (fgets (buffer, BUFSIZ, fp) != (char *) 0)
		if (sscanf (buffer,
	"%dx%d %d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %d %ld",
			&ver_max_x, &ver_max_y, &etu_per_update, &sec_per_etu,
			&fgrate, &fcrate, &eatrate, &babyeat, &obrate,
			&uwbrate, & bankint, & money_civ, & money_uw,
			& money_mil, & money_res, & ksu,
			& options_defined) != 17)
		{
			PrintAtEmpire ("Bad version info in datafile");
			PrintAtEmpire (Fmt ("Skipping Line \"%s\"", buffer));
			PrintAtEmpire ("");
			fprintf (stderr, "Skipping Line \"%s\"", buffer);
		}

	ksu_version = ksu;

	if (eatrate == 0.0)
		no_food = True;
}
