#ifndef _VAR
#define	_VAR

#define	NUMPKG	4		/* number of different kinds of packaging */

#define	NPKG	0		/* no special packaging */
#define	WPKG	1		/* "warehouse" packaging */
#define	UPKG	2		/* "urban" packaging */
#define	BPKG	3		/* "bank" packaging */

#define V_CIVIL		1
#define V_MILIT		2
#define V_SHELL		3
#define	V_GUN		4
#define	V_PETROL	5
#define V_IRON		6
#define V_DUST		7
#define V_BAR		8
#define V_FOOD		9
#define V_OIL		10
#define	V_LCM		11
#define	V_HCM		12
#define V_UW		13
#define V_RAD		14
#define V_MAX		15

#define I_MAX		14

#define	SCT_WATER	0       /* basics */
#define	SCT_MOUNT	1
#define	SCT_SANCT	2
#define	SCT_WASTE	3
#define	SCT_RURAL	4
#define	SCT_CAPIT	5
#define	SCT_URAN	6
#define	SCT_PARK	7
#define	SCT_ARMSF	8       /* industries */
#define	SCT_AMMOF	9
#define	SCT_MINE	10
#define	SCT_GMINE	11
#define	SCT_HARBR	12
#define	SCT_WAREH	13
#define	SCT_AIRPT	14
#define	SCT_AGRI	15
#define	SCT_OIL		16
#define	SCT_LIGHT	17
#define	SCT_HEAVY	18
#define	SCT_FORTR	19      /* military/scientific */
#define	SCT_TECH	20
#define	SCT_RSRCH	21
#define	SCT_NUKE	22
#define	SCT_LIBR	23
#define	SCT_HIWAY	24      /* communications */
#define	SCT_RADAR	25
#define	SCT_WETHR	26
#define	SCT_BHEAD	27
#define	SCT_BSPAN	28
#define	SCT_BANK	29      /* financial */
#define	SCT_REFINE	30	/* refinery */
#define SCT_ENLIST	31	/* enlistment center */
#define	SCT_UNKNOW	32      /* unknown land  ?             */

#define	SCT_MAXDEF	32	/* highest sector type in header files */

#define	P_SHELL	1
#define	P_GUN	2
#define	P_PETROL	3
#define	P_IRON	4
#define	P_DUST	5
#define	P_BAR	6
#define	P_FOOD	7
#define	P_OIL	8
#define	P_LCM	9
#define	P_HCM	10
#define	P_TLEV	11
#define	P_RLEV	12
#define	P_ELEV	13
#define	P_HLEV	14
#define P_URAN	15

#define	NAVOK	1		/* ships can always navigate */
#define	NAV_02	2		/* requires 2% effic to navigate */
#define	NAV_60	3		/* requires 60% effic to navigate */

#define NAT_TLEV	0
#define NAT_RLEV	1
#define NAT_ELEV	2
#define NAT_HLEV	3

#define	MAXPRDV 6

struct	pchrstr {
	int	p_type;		/* vtype if product is a variable */
	int	p_level;	/* index (NAT_?LEV) if product is not a var */
	int	p_cost;		/* dollars / product unit */
	int	p_nrndx;	/* index into sect of natural resource */
	int	p_nrdep;	/* depletion as a % of resource used */
	int	p_nlndx;	/* index (NAT_?LEV) affecting production */
	int	p_nlmin;	/* minimum lvl required */
	int	p_nllag;	/* lag, mul by (lvl-nlmin)/(lvl-nlmin+nllag) */
	int	p_effic;	/* process efficiency, mult by p_effic/100 */
	char	*p_name;	/* name of product */
	u_char	p_nv;		/* number of constituents */
	u_char	p_vtype[MAXPRDV];/* constituent types */
	u_int	p_vamt[MAXPRDV]; /* constituent amounts */
	char	*p_sname;	/* int (7char or less) name of product */
};

struct	dchrstr
{
	int	d_mnem;		/* map symbol */
	int	d_prd;		/* product vtype */
	int	d_mcst;		/* movement cost */
	int	d_flg;		/* movement cost */
	int	d_pkg;		/* type of packaging in these sects */
	int	d_ostr;		/* offensive strength */
	int	d_dstr;		/* defensive strength */
	int	d_value;	/* resale ("collect") value */
	char	*d_name;	/* full name of sector type */
};

struct	ichrstr
{
	int	i_mnem;		/* usually the initial letter */
	int	i_vtype;	/* var type */
	int	i_value;	/* mortgage value */
	int	i_sell;		/* can this be sold? */
	int	i_lbs;		/* how hard to move */
	int	i_pkg[NUMPKG];	/* units for reg, ware, bank */
	char	*i_name;	/* full name of item */
};

#endif _VAR
