#ifndef _SECTOR

#define _SECTOR

#include <sys/times.h>

	/* 
	 *	Change these values:
	 */


extern int MAX_X;
extern int MAX_Y;

#define D_UW	0
#define D_FOO	1
#define D_SHE	2
#define D_GUN	3
#define D_PET	4
#define D_IRO	5
#define D_BAR	6
#define D_DUS	7
#define D_OIL	8
#define D_LCM	9
#define D_HCM	10
#define D_RAD	11
#define D_MAX	12

	/*
	 *	Three different sector types:
	 *
	 *	1.	sea sector / only know the designation
	 *	2.	enemy sector (spy, lookout, explore)
	 *	3.	you're sector
	 */

#define	S_EXIST		0
#define	S_DESIG		1
#define S_RESOU		2
#define S_OWNED		3

typedef struct s_sector1 * Sct1;
typedef struct s_sector2 * Sct2;
typedef struct s_sector3 * Sct3;

struct s_sector1
{
	short xcd;
	short ycd;
	short owner;
	char des;
	uchar oil;
	uchar fer;
	uchar inf;
	uchar shi;
	uchar pla;
	uchar nuk;
	uchar mines;
	Ship fship;
	Plane fplane;
	Nuke stock;
	uchar mar;		/* Is this Sector marked */
	Sct2 sct2;
};

#define s_xcd(p)	(int) (p)-> xcd
#define s_ycd(p)	(int) (p)-> ycd
#define s_owned(p)	((p)-> owner == my_cnum)
#define s_owner(p)	(int) (p)-> owner
#define s_des(p)	(p)-> des
#define s_oil(p)	(int) (p)-> oil
#define s_fer(p)	(int) (p)-> fer
#define s_fship(p)	(p)-> fship
#define s_fplane(p)	(p)-> fplane
#define s_stock(p)	(p)-> stock
#define s_mar(p)	(int) (p)-> mar

#define s_mines(p)	(int) (p)-> mines

#define s_shi(p)	(int) (p)-> shi
#define s_pla(p)	(int) (p)-> pla
#define s_nuk(p)	(int) (p)-> nuk

#define s_inf(p)	(p)-> inf

#define set_xcd(p,x)	(p)-> xcd = (short) x
#define set_ycd(p,y)	(p)-> ycd = (short) y
#define set_owner(p,q)	(p)-> owner = (short) q
#define set_des(p,c)	(p)-> des = c
#define set_oil(p,q)	(p)-> oil = (uchar) q
#define set_fer(p,q)	(p)-> fer = (uchar) q
#define set_fship(p,s)	(p)-> fship = s
#define set_fplane(p,s)	(p)-> fplane = s
#define set_stock(p,x)	(p)-> stock = x

#define set_shi(p,q)	(p)-> shi = (uchar) q
#define set_pla(p,q)	(p)-> pla = (uchar) q
#define set_nuk(p,q)	(p)-> nuk = (uchar) q
#define set_mar(p,q)	(p)-> mar = (uchar) q

#define inc_mines(p,q)	(p)-> mines += (uchar) q
#define set_mines(p,q)  (p)-> mines = (uchar) q

#define inc_shi(p)	(p)-> shi ++
#define inc_pla(p)	(p)-> pla ++
#define inc_nuk(p)	(p)-> nuk ++
#define inc_mar(p)	(p)-> mar ++

#define add_nuk(p,q)	(p)-> nuk += (q)

#define dec_shi(p)	(p)-> shi --
#define dec_pla(p)	(p)-> pla --
#define dec_nuk(p)	(p)-> nuk --
#define dec_mar(p)	(p)-> mar --

#define NONE	0x0
#define	DES	0x1
#define	OIL	0x2
#define	FER	0x4
#define	RES	0x8
#define	LOO	0x10
#define	SPY	0x20
#define	ALL	0x40
#define	KNEWALL	0x80

#define SET_INFO_DES(sct)	(s_inf (sct) |= (DES))
#define SET_INFO_OIL(sct)	(s_inf (sct) |= (DES | OIL))
#define SET_INFO_FER(sct)	(s_inf (sct) |= (DES | FER))
#define SET_INFO_RES(sct)	(s_inf (sct) |= (DES | OIL | FER | RES))
#define SET_INFO_LOO(sct)	(s_inf (sct) |= (DES | LOO))
#define SET_INFO_SPY(sct)	(s_inf (sct) |= (DES | SPY))
#define SET_INFO_ALL(sct)	(s_inf (sct) |= (DES | OIL | FER | RES | ALL))
#define SET_INFO_KNEWALL(sct)	(s_inf (sct) |= KNEWALL)

#define NO_INFO(sct)		(s_inf (sct) == NONE)
#define KNOW_DES(sct)		((s_inf (sct) & DES) == DES)
#define KNOW_OWN(sct)		(s_owner(sct) != UNKNOWN_CNUM) /* - heinola 9/11/91.*/
#define KNOW_OIL(sct)		((s_inf (sct) & OIL) == OIL)
#define KNOW_FER(sct)		((s_inf (sct) & FER) == FER)
#define KNOW_RES(sct)		((s_inf (sct) & RES) == RES)
#define KNOW_LOO_ONLY(sct)	((s_inf (sct) & LOO) == LOO)
#define KNOW_SPY_ONLY(sct)	((s_inf (sct) & SPY) == SPY)
#define KNOW_ALL(sct)		((s_inf (sct) & ALL) == ALL)

#define KNEW_ALL(sct)		((s_inf (sct) & KNEWALL) == KNEWALL)

#define KNOW_LOO(sct)		(KNOW_ALL (sct) || KNOW_LOO_ONLY (sct))
#define KNOW_SPY(sct)		(KNOW_ALL (sct) || KNOW_SPY_ONLY (sct))

#define KNOW_CIV(sct)		KNOW_LOO (sct)
#define KNOW_MIL(sct)		KNOW_LOO (sct)
#define KNOW_EFF(sct)		KNOW_LOO (sct)

#define DEL_INFO(sct)		(s_inf (sct) = NONE)

struct s_sector2
{
	short eff;
	uchar mob;
	uchar min;
	uchar gol;
	uchar ura;
	short civ;
	short mil;
	short qua [D_MAX];
	time_t tim;		/* time from lookout or spy */
	Sct3 sct3;
};

#define s_eff(p)	(int) (p)-> sct2-> eff
#define s_mob(p)	(int) (p)-> sct2-> mob
#define s_min(p)	(int) (p)-> sct2-> min
#define s_gol(p)	(int) (p)-> sct2-> gol
#define s_ura(p)	(int) (p)-> sct2-> ura
#define s_civ(p)	(int) (p)-> sct2-> civ
#define s_mil(p)	(int) (p)-> sct2-> mil
#define s_time(p)	(p)-> sct2-> tim

#define set_eff(p,i)	(p)-> sct2-> eff = (short) i
#define set_mob(p,i)	(p)-> sct2-> mob = (uchar) i
#define set_min(p,i)	(p)-> sct2-> min = (uchar) i
#define set_gol(p,i)	(p)-> sct2-> gol = (uchar) i
#define set_ura(p,i)	(p)-> sct2-> ura = (uchar) i
#define set_civ(p,i)	(p)-> sct2-> civ = (short) i
#define set_mil(p,i)	(p)-> sct2-> mil = (short) i
#define set_time(p,l)	(p)-> sct2-> tim = l

#define q_uw(p)		(int) (p) -> sct2-> qua [D_UW]
#define q_foo(p)	(int) (p) -> sct2-> qua [D_FOO]
#define q_she(p)	(int) (p) -> sct2-> qua [D_SHE]
#define q_gun(p)	(int) (p) -> sct2-> qua [D_GUN]
#define q_pet(p)	(int) (p) -> sct2-> qua [D_PET]
#define q_iro(p)	(int) (p) -> sct2-> qua [D_IRO]
#define q_dus(p)	(int) (p) -> sct2-> qua [D_DUS]
#define q_bar(p)	(int) (p) -> sct2-> qua [D_BAR]
#define q_oil(p)	(int) (p) -> sct2-> qua [D_OIL]
#define q_lcm(p)	(int) (p) -> sct2-> qua [D_LCM]
#define q_hcm(p)	(int) (p) -> sct2-> qua [D_HCM]
#define q_rad(p)	(int) (p) -> sct2-> qua [D_RAD]

#define set_q_uw(p,q)	(p) -> sct2-> qua [D_UW]  = (short) q
#define set_q_foo(p,q)	(p) -> sct2-> qua [D_FOO] = (short) q
#define set_q_she(p,q)	(p) -> sct2-> qua [D_SHE] = (short) q
#define set_q_gun(p,q)	(p) -> sct2-> qua [D_GUN] = (short) q
#define set_q_pet(p,q)	(p) -> sct2-> qua [D_PET] = (short) q
#define set_q_iro(p,q)	(p) -> sct2-> qua [D_IRO] = (short) q
#define set_q_dus(p,q)	(p) -> sct2-> qua [D_DUS] = (short) q
#define set_q_bar(p,q)	(p) -> sct2-> qua [D_BAR] = (short) q
#define set_q_oil(p,q)	(p) -> sct2-> qua [D_OIL] = (short) q
#define set_q_lcm(p,q)	(p) -> sct2-> qua [D_LCM] = (short) q
#define set_q_hcm(p,q)	(p) -> sct2-> qua [D_HCM] = (short) q
#define set_q_rad(p,q)	(p) -> sct2-> qua [D_RAD] = (short) q

struct s_sector3
{
	char nds;
	uchar wor;
	short ava;
	uchar ter;
	char occ;
	short cut [D_MAX];
	short tre [D_MAX];
	char *pat;
	short dxc;
	short dyc;
	Nuke fnuke;
	PlanEntry plan;
};

#define s_plan(p)	(p)-> sct2-> sct3-> plan
#define set_plan(p,q)	(p)-> sct2-> sct3-> plan = (q)

#define s_nds(p)	(p)-> sct2-> sct3-> nds
#define s_wor(p)	(int) (p)-> sct2-> sct3-> wor
#define s_ava(p)	(int) (p)-> sct2-> sct3-> ava
#define s_ter(p)	(int) (p)-> sct2-> sct3-> ter
#define s_occ(p)	(p)-> sct2-> sct3-> occ
#define s_pat(p)	(p)-> sct2-> sct3-> pat
#define s_dxc(p)	(int) (p)-> sct2-> sct3-> dxc
#define s_dyc(p)	(int) (p)-> sct2-> sct3-> dyc
#define s_fnuke(p)	(p)-> sct2-> sct3-> fnuke

#define set_nds(p,q)	(p)-> sct2-> sct3-> nds = q
#define set_wor(p,i)	(p)-> sct2-> sct3-> wor = (uchar) i
#define set_ava(p,i)	(p)-> sct2-> sct3-> ava = (short) i
#define set_ter(p,i)	(p)-> sct2-> sct3-> ter = (uchar) i
#define set_occ(p,c)	(p)-> sct2-> sct3-> occ = c
#define set_dxc(p,i)	(p)-> sct2-> sct3-> dxc = (short) i
#define set_dyc(p,i)	(p)-> sct2-> sct3-> dyc = (short) i
#define set_pat(p,s)	(p)-> sct2-> sct3-> pat = s
#define set_fnuke(p,q)	(p)-> sct2-> sct3-> fnuke = q

	/*
	 *	set_pat is a function (SetPath)
	 */

	/* d_ => delivery direction */

#define DIR_MASK	0x07
#define CUT_SHIFT	3

#define d_uw(p)	  (int) chardirs [((p)-> sct2-> sct3-> cut [D_UW]  & DIR_MASK)]
#define d_foo(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_FOO] & DIR_MASK)]
#define d_she(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_SHE] & DIR_MASK)]
#define d_gun(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_GUN] & DIR_MASK)]
#define d_pet(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_PET] & DIR_MASK)]
#define d_iro(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_IRO] & DIR_MASK)]
#define d_dus(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_DUS] & DIR_MASK)]
#define d_bar(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_BAR] & DIR_MASK)]
#define d_oil(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_OIL] & DIR_MASK)]
#define d_lcm(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_LCM] & DIR_MASK)]
#define d_hcm(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_HCM] & DIR_MASK)]
#define d_rad(p)  (int) chardirs [((p)-> sct2-> sct3-> cut [D_RAD] & DIR_MASK)]

#define set_d(a,b)	((a) = (short) ((a) & ~DIR_MASK) | b)

#define set_d_uw(p,q)  	set_d ((p)-> sct2-> sct3-> cut [D_UW],  q)
#define set_d_foo(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_FOO], q)
#define set_d_she(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_SHE], q)
#define set_d_gun(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_GUN], q)
#define set_d_pet(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_PET], q)
#define set_d_iro(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_IRO], q)
#define set_d_dus(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_DUS], q)
#define set_d_bar(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_BAR], q)
#define set_d_oil(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_OIL], q)
#define set_d_lcm(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_LCM], q)
#define set_d_hcm(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_HCM], q)
#define set_d_rad(p,q)	set_d ((p)-> sct2-> sct3-> cut [D_RAD], q)

	/* c_ => cuttoff */

#define c_uw(p)	  (int) ((p)-> sct2-> sct3-> cut [D_UW]  >> CUT_SHIFT)
#define c_foo(p)  (int) ((p)-> sct2-> sct3-> cut [D_FOO] >> CUT_SHIFT)
#define c_she(p)  (int) ((p)-> sct2-> sct3-> cut [D_SHE] >> CUT_SHIFT)
#define c_gun(p)  (int) ((p)-> sct2-> sct3-> cut [D_GUN] >> CUT_SHIFT)
#define c_pet(p)  (int) ((p)-> sct2-> sct3-> cut [D_PET] >> CUT_SHIFT)
#define c_iro(p)  (int) ((p)-> sct2-> sct3-> cut [D_IRO] >> CUT_SHIFT)
#define c_dus(p)  (int) ((p)-> sct2-> sct3-> cut [D_DUS] >> CUT_SHIFT)
#define c_bar(p)  (int) ((p)-> sct2-> sct3-> cut [D_BAR] >> CUT_SHIFT)
#define c_oil(p)  (int) ((p)-> sct2-> sct3-> cut [D_OIL] >> CUT_SHIFT)
#define c_lcm(p)  (int) ((p)-> sct2-> sct3-> cut [D_LCM] >> CUT_SHIFT)
#define c_hcm(p)  (int) ((p)-> sct2-> sct3-> cut [D_HCM] >> CUT_SHIFT)
#define c_rad(p)  (int) ((p)-> sct2-> sct3-> cut [D_RAD] >> CUT_SHIFT)

#define set_c(p,q)	(p = (short) (q << CUT_SHIFT) | (p & DIR_MASK))
#define set_c_uw(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_UW], q)
#define set_c_foo(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_FOO], q)
#define set_c_she(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_SHE], q)
#define set_c_gun(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_GUN], q)
#define set_c_pet(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_PET], q)
#define set_c_iro(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_IRO], q)
#define set_c_dus(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_DUS], q)
#define set_c_bar(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_BAR], q)
#define set_c_oil(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_OIL], q)
#define set_c_lcm(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_LCM], q)
#define set_c_hcm(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_HCM], q)
#define set_c_rad(p,q)	set_c ((p)-> sct2-> sct3-> cut[D_RAD], q)

	/* set cutoff and deliver direction in one go (used with dump)	*/
	/* ATT: use the character off the delivery here 		*/

#define set_dc(p,q,r)		(p = (short) ((r << CUT_SHIFT) | \
	((int) (index (chardirs, q) - chardirs) & DIR_MASK)))
#define set_dc_uw(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_UW] , q, r)
#define set_dc_foo(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_FOO], q, r)
#define set_dc_she(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_SHE], q, r)
#define set_dc_gun(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_GUN], q, r)
#define set_dc_pet(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_PET], q, r)
#define set_dc_iro(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_IRO], q, r)
#define set_dc_dus(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_DUS], q, r)
#define set_dc_bar(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_BAR], q, r)
#define set_dc_oil(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_OIL], q, r)
#define set_dc_lcm(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_LCM], q, r)
#define set_dc_hcm(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_HCM], q, r)
#define set_dc_rad(p,q,r)	set_dc ((p)-> sct2-> sct3-> cut[D_RAD], q, r)

	/* t_ => threshold */

#define t_uw(p)	  (int) (p)-> sct2-> sct3-> tre [D_UW]
#define t_foo(p)  (int) (p)-> sct2-> sct3-> tre [D_FOO]
#define t_she(p)  (int) (p)-> sct2-> sct3-> tre [D_SHE]
#define t_gun(p)  (int) (p)-> sct2-> sct3-> tre [D_GUN]
#define t_pet(p)  (int) (p)-> sct2-> sct3-> tre [D_PET]
#define t_iro(p)  (int) (p)-> sct2-> sct3-> tre [D_IRO]
#define t_dus(p)  (int) (p)-> sct2-> sct3-> tre [D_DUS]
#define t_bar(p)  (int) (p)-> sct2-> sct3-> tre [D_BAR]
#define t_oil(p)  (int) (p)-> sct2-> sct3-> tre [D_OIL]
#define t_lcm(p)  (int) (p)-> sct2-> sct3-> tre [D_LCM]
#define t_hcm(p)  (int) (p)-> sct2-> sct3-> tre [D_HCM]
#define t_rad(p)  (int) (p)-> sct2-> sct3-> tre [D_RAD]

#define set_t_uw(p,q)	(p)-> sct2-> sct3-> tre [D_UW]  = (short) q
#define set_t_foo(p,q)	(p)-> sct2-> sct3-> tre [D_FOO] = (short) q
#define set_t_she(p,q)	(p)-> sct2-> sct3-> tre [D_SHE] = (short) q
#define set_t_gun(p,q)	(p)-> sct2-> sct3-> tre [D_GUN] = (short) q
#define set_t_pet(p,q)	(p)-> sct2-> sct3-> tre [D_PET] = (short) q
#define set_t_iro(p,q)	(p)-> sct2-> sct3-> tre [D_IRO] = (short) q
#define set_t_dus(p,q)	(p)-> sct2-> sct3-> tre [D_DUS] = (short) q
#define set_t_bar(p,q)	(p)-> sct2-> sct3-> tre [D_BAR] = (short) q
#define set_t_oil(p,q)	(p)-> sct2-> sct3-> tre [D_OIL] = (short) q
#define set_t_lcm(p,q)	(p)-> sct2-> sct3-> tre [D_LCM] = (short) q
#define set_t_hcm(p,q)	(p)-> sct2-> sct3-> tre [D_HCM] = (short) q
#define set_t_rad(p,q)	(p)-> sct2-> sct3-> tre [D_RAD] = (short) q

#define	EX(x)		((WX (x) >= MAX_X / 2) ? (WX (x) - MAX_X) : WX (x))
#define	EY(y)		((WY (y) >= MAX_Y / 2) ? (WY (y) - MAX_Y) : WY (y))

#define	WX(x)		(((x) + 2*MAX_X) % MAX_X)
#define	WY(y)		(((y) + 2*MAX_Y) % MAX_Y)

#define	W_COORD	0x01
#define	W_DES	0x02
#define	W_COUN	0x04
#define W_NORM	0x0

#endif /* _SECTOR */
