#include "type.h"
#include "main.h"

static FILE * help_fp = (FILE *) 0;

void Help (x, y, str)
int x, y;
char * str;
{
	char buffer [BUFSIZ];
	Strings strings;
	Pager pager;
	char * help_file;

	if (help_fp == (FILE *) 0)
	{
		help_file = Fmt ("%s/.help", XEMPINFO);
		help_fp = fopen (help_file, "r");
		if (help_fp == (FILE *) 0)
		{
			Message (Fmt ("Can't open %s", help_file));
			Bell ();
			return;
		}
	}

	rewind (help_fp);

	for (;;)
	{
		if (fgets (buffer, BUFSIZ, help_fp) == (char *) 0)
		{
			Message (Fmt ("Help on '%s' not found", str));
			Bell ();
			return;
		}

		NoNl (buffer);

		if (strcmp (buffer, str) == 0)
		{
			strings = InitStrings ();

			for (;;)
			{
				if (fgets (buffer, BUFSIZ, help_fp) ==
								(char *) 0)
				{
					Message (Fmt ("No '.' found by %s",
							str));
					FreeStrings (strings);
					Bell ();
					return;
				}

				if (strcmp (buffer, ".\n") == 0)
				{
					pager = InitPager (strings, "Help");
					MapPagerFromTop (pager, map_win, x, y);
					ShowPager (pager);
					FreePager (pager);
					FreeStrings (strings);
					return;
				}

				NoNl (buffer);
				AddString (strings, buffer);
			}
		}

			/* skip to '.' */

		do {
			if (fgets (buffer, BUFSIZ, help_fp) == (char *) 0)
			{
				Message ("corrupted help-file");
				Bell ();
				return;
			}
		}
		while (strcmp (buffer, ".\n") != 0);
	}
}
