#include "type.h"
#include "main.h"
#include "sector.h"

void ExecSetThreshold (realm, itemchar, i)
char * realm;
char itemchar;
int i;
{
	int sx, sy, ex, ey, x, y, nr1, nr2, length, width;
	int changed;
	Sector sct;

	if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
		return;		/* impossible ! */

	width = XDIST (sx, ex) + 1;
	length = YDIST (sy, ey) + 1;

	changed = 0;
	for (x = sx, nr1 = 0; nr1 < width; nr1++, x ++)
		for (y = sy, nr2 = 0; nr2 < length; nr2++, y++) 
			if ((x + y) % 2 == 0)
			{
				sct = World (x, y, S_EXIST);
				if (sct != (Sector) 0 && s_owned (sct))
				{
					SetThreshold (sct, itemchar, i);
					DrawSector (sct);
					changed ++;
				}
			}

	if (changed == 0)
	{
		Message ("No thresholds changed");
		Bell ();
		return;
	}

	if (itemchar == 'a')
		FeedCommand (Fmt ("wipe %s", realm), PRINT);
	else
		FeedCommand (Fmt ("threshold %c %s %d", itemchar, realm, i),
								PRINT);

	if (itemchar == 'a')
		Message (Fmt ("%d sectors wiped", changed));
	else
		Message (Fmt ("%d %s thresholds %s",
			changed,
			ItemName (CharToItem (itemchar)),
			(i == 0) ? "deleted" : "changed"));
}

void MultiThreshold (px, py)
int px, py;
{
	char * realm, * ptr;
	int newvalue;
	int item;

	item = SelectSellItem (px, py, "Threshold for ?");

	if (item < 0)
	{
		Message ("Setting threshold cancelled");
		return;
	}

	ptr = InputAtMessage (Fmt ("New threshold for %s ?", ItemName (item)),
			4, GS_PNUMBER);

	if (ptr == (char *) 0 || *ptr == '\0')
	{
		Message ("Setting threshold cancelled");
		return;
	}

	newvalue = atoi (ptr);

	while ((realm = MySelRealm ()) != (char *) 0)
		ExecSetThreshold (realm, ItemChar (item), newvalue);
	
	Message ("Multi set threshold done");
	DrawMap ();
}

void MultiWipe ()
{
	char *realm;

	while ((realm = MySelRealm ()) != (char *) 0)
		ExecSetThreshold (realm, 'a', 0);

	Message ("Multi wipe done");
	DrawMap ();
}
