	/*
	 *	Emptool				<file: xinit.c>
	 *	
	 *	Written by HJ. Visscher.
	 *
	 *	void InitX ()
	 *		Initilizes X: opens display, get colors, etc.
	 *
	 *	void QuitX ()
	 *		Closes the connection to the X-server.
	 */

#define		FONT_DEFAULT	"9x15"
#define		FONT_BOLD	"9x15bold"
#define		FONT_SMALL	"6x10"

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "type.h"
#include "main.h"

	/*	Here are the variables from xextern.h */

bool xstarted = False;

Display *display;
int screen, depth;
Window root_window;

GC gc_normal;
GC gc_bold;
GC gc_inv_normal;
GC gc_inv_bold;
GC gc_copy;
GC gc_small;
GC gc_inv_copy;
GC gc_inv_small;
GC gc_xor;

XColor white_color, black_color;

unsigned long black_pixel, white_pixel;

int CHAR_HEIGHT, CHAR_WIDTH, CHAR_ASC;

void InitX (font, bfont)
char *font, *bfont;
{
	XColor tmp;
	XFontStruct *normal_fs, *bold_fs, *small_fs;
	XGCValues gc_values;
	unsigned long gc_mask;

		/*	Establish connection with the X-server */

	if ( (display = XOpenDisplay ((char *) 0)) == (Display *) 0)
	{
		(void) fprintf (stderr, "Can't open display (%s)\n",
			XDisplayName ((char *) 0));
		leave ();
	}

	screen = DefaultScreen (display);
	depth = DefaultDepth (display, screen);
	root_window = RootWindow (display, screen);

		/*	Get the colors */

	(void) XLookupColor (display, DefaultColormap (display, screen),
			     "white", & white_color, & tmp);
	(void) XLookupColor (display, DefaultColormap (display, screen),
			     "black", & black_color, & tmp); 

	black_pixel = BlackPixel (display, screen);
	white_pixel = WhitePixel (display, screen);

		/*	Load fonts */

	normal_fs = XLoadQueryFont (display,
		(font == (char *) 0) ? FONT_DEFAULT : font);

	if (normal_fs == (XFontStruct *) 0)
	{
		(void) fprintf (stderr, "Can't open font: %s\n",
			(font == (char *) 0) ? FONT_DEFAULT: font);
		XCloseDisplay (display);
		leave ();
	}

	bold_fs = XLoadQueryFont (display,
		(bfont == (char *) 0) ? FONT_BOLD : bfont);

	if (bold_fs == (XFontStruct *) 0)
	{
		(void) fprintf (stderr, "Can't open font: %s\n", 
			(bfont == (char *) 0) ? FONT_BOLD: bfont);
		XCloseDisplay (display);
		leave ();
	}

	small_fs = XLoadQueryFont (display, FONT_SMALL);
	if (small_fs == (XFontStruct *) 0)
	{
		(void) fprintf (stderr,
			"Can't open (small) font: %s\n", FONT_SMALL);
		(void) fprintf (stderr, 
			"When not available, change in xinit.c\n");
		XCloseDisplay (display);
		leave ();
	}
		
	/*	Get sizes and check for same size */

	CHAR_ASC = normal_fs -> ascent;
	CHAR_HEIGHT = normal_fs -> ascent + normal_fs -> descent;
	CHAR_WIDTH =  XTextWidth (normal_fs, "A", 1);

	if (CHAR_WIDTH != XTextWidth (bold_fs, "i", 1) ||
	    CHAR_HEIGHT != bold_fs -> ascent + bold_fs -> descent)
		(void) fprintf (stderr,
			"warning: fonts have different sizes!\n");

	/* Create all gc's */

	gc_mask = (GCFunction | GCForeground | GCBackground | GCFont);
	
	/* back_pixel: 0 -> xterm, 1 -> sun */

	/* gc_small is only used to draw pixmap's into pixmap's */

	/*
	  fprintf(stderr, "Black pixel %d\n", black_pixel);
	  fprintf(stderr, "White pixel %d\n", white_pixel);
	  */

	if (black_pixel == 0L)
	{
		gc_values. foreground = white_pixel;
		gc_values. background = black_pixel;
		gc_values. function = GXcopyInverted;
	}
	else
	{
		gc_values. foreground = black_pixel;
		gc_values. background = white_pixel;
		gc_values. function = GXcopy;
	}

	gc_values. font = small_fs -> fid;
	gc_small = XCreateGC (display, root_window, gc_mask, &gc_values);

	if (black_pixel == 0L)
	{
		gc_values. foreground = black_pixel;
		gc_values. background = white_pixel;
		gc_values. function = GXcopy;
	}
	else
	{
		gc_values. foreground = white_pixel;
		gc_values. background = black_pixel;
		gc_values. function = GXcopyInverted;
	}

	gc_inv_small = XCreateGC (display, root_window, gc_mask, &gc_values);

	/* normal fonts */

	gc_values. foreground = reversed ? white_pixel : black_pixel;
	gc_values. background = reversed ? black_pixel : white_pixel;

	gc_values. font = normal_fs-> fid;
	gc_values. function = GXcopy;
	gc_normal = XCreateGC (display, root_window, gc_mask, &gc_values);

	gc_values. font = bold_fs-> fid;
	gc_bold = XCreateGC (display, root_window, gc_mask, &gc_values);

	/* inverted fonts */
	
	gc_values. foreground = reversed ? black_pixel : white_pixel;
	gc_values. background = reversed ? white_pixel : black_pixel;

	gc_inv_bold = XCreateGC (display, root_window, gc_mask, &gc_values);

	gc_values. font = normal_fs-> fid;
	gc_inv_normal = XCreateGC (display, root_window, gc_mask, &gc_values);

	/* to copy the pixmap */

	gc_values. foreground = black_pixel;
	gc_values. background = white_pixel;

	gc_values. function = GXcopy;
	gc_copy = XCreateGC (display, root_window, gc_mask, &gc_values);

	gc_values. foreground = white_pixel;
	gc_values. background = black_pixel;

	gc_values. function = GXcopy/*Inverted*/;
	gc_inv_copy = XCreateGC (display, root_window, gc_mask, &gc_values);

	gc_values. foreground = black_pixel;
	gc_values. background = white_pixel;

	gc_values. function = GXxor;
	gc_xor = XCreateGC (display, root_window, gc_mask, &gc_values);

	xstarted = True;

	XSetErrorHandler (OurErrorHandler);
	XSetIOErrorHandler (OurFatalErrorHandler);
}

void QuitX ()
{
	if (xstarted)
		XCloseDisplay (display);
}

void Refresh ()
{

	if (xstarted)
		XFlush (display);
}

void WaitRefresh (discard)
bool discard;
{
  	XSync (display, discard);
}

int CharToPixelX (x)
int x;
{
	return x * CHAR_WIDTH;
}

int CharToPixelY (y)
int y;
{
	return y * CHAR_HEIGHT;
}

int CharToPixelYB (y)
int y;
{
	return y * CHAR_HEIGHT + CHAR_ASC;
}

int PixelToCharX (x)
{
	return x  / CHAR_WIDTH;
}

int PixelToCharY (y)
{
	return y / CHAR_HEIGHT;
}

int PixelToCharYB (y)
{
	return (y - CHAR_ASC) / CHAR_HEIGHT;
}

void OurErrorHandler (display, event)
Display * display;
XErrorEvent * event;
{
	char buf [101];

	XGetErrorText (display, event-> error_code, buf, 100);

	fprintf (stderr, "\007X error: %s\n", buf);
}

void OurFatalErrorHandler (display, event)
Display * display;
XErrorEvent * event;
{
	extern bool dump_core;

	OurErrorHandler (display, event);
	fprintf (stderr, "This was a fatal one ... exiting.\n");

	save_data = True;
	dump_core = False;

	leave0 ();
}
