#include "type.h"
#include "main.h"
#include "sector.h"

static VeDump ()
{
	int x, y;
	int nr;
	Sector sct;
	long t;

	FILE * fp;

	fp = fopen ("dump", "w");
	if (fp == (FILE *) 0)
	{
		perror ("fopen");
		return;
	}

	fprintf (fp, "dump # >! dump\n");
	localtime (& t);
	fprintf (fp, ctime (& t));
	fprintf (fp, "DUMP SECTOR\n");
	fprintf (fp, "x y des sdes eff mob * min gold fert ocontent uran work avail terr civ mil uw food shell gun pet iron dust bar oil lcm hcm rad u_del f_del s_del g_del p_del i_del d_del b_del o_del l_del h_del r_del u_cut f_cut s_cut g_cut p_cut i_cut d_cut b_cut o_cut l_cut h_cut r_cut dist_path dist_x dist_y u_dist f_dist s_dist g_dist p_dist i_dist d_dist b_dist o_dist l_dist h_dist r_dist\n");

	nr = 0;

	for (x = 0; x < MAX_X; x ++)
	for (y = x % 2; y < MAX_Y; y += 2)
	{
		sct = World (x, y, S_EXIST);
		if (sct == (Sector) 0 || ! s_owned (sct))
			continue;

		fprintf (fp, "%d %d %c %c %d %d %c ",
			s_xcd (sct), s_ycd (sct), s_des (sct),
			s_nds (sct) == s_des (sct) ? '_' : s_nds (sct),
			s_eff (sct), s_mob (sct), s_occ (sct));

		fprintf (fp, "%d %d %d %d %d %d %d %d %d %d ",
			s_min (sct), s_gol (sct), s_fer (sct), s_oil (sct),
			s_ura (sct), s_wor (sct), s_ava (sct), s_ter (sct),
			s_civ (sct), s_mil (sct));

		fprintf (fp, "%d %d %d %d %d %d %d %d %d %d %d %d ",
			q_uw  (sct), q_foo (sct), q_she (sct), q_gun (sct),
			q_pet (sct), q_iro (sct), q_dus (sct), q_bar (sct),
			q_oil (sct), q_lcm (sct), q_hcm (sct), q_rad (sct));
		
		fprintf (fp, "%c %c %c %c %c %c %c %c %c %c %c %c ",
			d_uw  (sct), d_foo (sct), d_she (sct), d_gun (sct),
			d_pet (sct), d_iro (sct), d_dus (sct), d_bar (sct),
			d_oil (sct), d_lcm (sct), d_hcm (sct), d_rad (sct));

		fprintf (fp, "%d %d %d %d %d %d %d %d %d %d %d %d ",
			c_uw  (sct), c_foo (sct), c_she (sct), c_gun (sct),
			c_pet (sct), c_iro (sct), c_dus (sct), c_bar (sct),
			c_oil (sct), c_lcm (sct), c_hcm (sct), c_rad (sct));
		
		fprintf (fp, "%s %d %d ",
			s_pat (sct) == (char *) 0 ? "_" : s_pat (sct),
			s_dxc (sct), s_dyc (sct));

		fprintf (fp, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
			t_uw  (sct), t_foo (sct), t_she (sct), t_gun (sct),
			t_pet (sct), t_iro (sct), t_dus (sct), t_bar (sct),
			t_oil (sct), t_lcm (sct), t_hcm (sct), t_rad (sct));
		
		nr ++;
	}	

	fprintf (fp, "  %d sectors\n", nr);
	fclose (fp);
}

	/* ARGSUSED */
void VeUtil (args)
char * args;
{
	VeDump ();
}
