#include "main.h"

typedef char SBuf [10];

typedef struct s_power * PowerEntry;
typedef struct s_powerl * PowerList;

struct s_power
{
	int ranking;
	int nat;
	SBuf nr_sects;
	SBuf eff;
	SBuf civ;
	SBuf mil;
	SBuf shells;
	SBuf guns;
	SBuf pet;
	SBuf iron;
	SBuf dust;
	SBuf food;
	SBuf oil;
	SBuf pln;
	SBuf ship;
	SBuf money;
};

struct s_powerl
{
	PowerEntry entry;
	PowerList next, prev;
};

static int sects_start = 0;
static int eff_start;

static PowerList power_head, power_tail;

static PowerEntry NewPowerEntry ()
{
	PowerEntry new_entry;
	PowerList new_list;

	new_entry = (PowerEntry) doalloc ((unsigned) sizeof (struct s_power));
	new_list = (PowerList) doalloc ((unsigned) sizeof (struct s_powerl));

	new_list-> entry = new_entry;
	new_list-> next = (PowerList) 0;
	new_list-> prev = power_tail;

	if (power_head == (PowerList) 0)
	{
		power_head = power_tail = new_list;
	}
	else
	{
		power_tail-> next = new_list;
		power_tail = new_list;
	}

	return new_entry;
}

static void FreeLastPowerEntry (entry)
PowerEntry entry;
{
	if (power_tail == (PowerList) 0)
		Panic ("FreeLastPowerEntry", __FILE__, "power_tail is NULL");
	
	(void) free ((char *) (power_tail-> entry));
	if (power_tail == power_head)
	{
		(void) free ((char *) power_head);
		power_head = power_tail = (PowerList) 0;
	}
	else
	{
		power_tail = power_tail-> prev;
		(void) free ((char *) power_tail-> next);
	}
}

static bool ScanPowerLine (entry, line)
PowerEntry entry;
char * line;
{
	char buf [100];
	char * ptr;
	int len, i;

	if (StrStr (line, "---") != (char *) 0)
		return False;
	
	ptr = StrStr (line, "sects");
	if (ptr != (char *) 0)
	{
		sects_start = (ptr - line);
		ptr = StrStr (line, "eff");
		eff_start = (ptr - line);
		return False;
	}

	if (eff_start == 0)
		return False;
	
	if (strlen (line) < eff_start + 2)
		return False;
	
	if (line [eff_start + 2] != '%')
		return False;

		/* find nation */

	i = 0;
	while (line [i] == ' ')
		i ++;
	strncpy (buf, line + i, sects_start - i);
	buf [sects_start - i] = '\0';

	if (strcmp (buf, "worldwide") == 0)
		return False;

	i = CountryId (buf);

	if (i < 0)
	{
		Message (Fmt ("Unknown country (%s) in power report", buf));
		Bell ();
		Pause ();
		return False;
	}

	entry-> nat = i;

	ptr = line + sects_start;
	ScanFmt (& ptr, entry-> nr_sects, "0-9KM.");
	ScanFmt (& ptr, entry-> eff, "0-9%");
	ScanFmt (& ptr, entry-> civ, "0-9KM.");
	ScanFmt (& ptr, entry-> mil, "0-9KM.");
	ScanFmt (& ptr, entry-> shells, "0-9KM.");
	ScanFmt (& ptr, entry-> guns, "0-9KM.");
	ScanFmt (& ptr, entry-> pet, "0-9KM.");
	ScanFmt (& ptr, entry-> iron, "0-9KM.");
	ScanFmt (& ptr, entry-> dust, "0-9KM.");
	ScanFmt (& ptr, entry-> food, "0-9KM.");
	ScanFmt (& ptr, entry-> oil, "0-9KM.");
	ScanFmt (& ptr, entry-> pln, "0-9KM.");
	ScanFmt (& ptr, entry-> ship, "0-9KM.");
	ScanFmt (& ptr, entry-> money, "0-9KM.");

	return True;
}

void FreePowerList ()
{
	while (power_tail != (PowerList) 0)
		FreeLastPowerEntry ();
}

static void DoScanPower (force)
bool force;
{
	int ranking;
	char * line;
	PowerEntry entry;

	if (power_tail == (PowerList) 0 || force)
	{
		if (power_tail != (PowerList) 0)
			FreePowerList ();
		
		FeedEmpire ("power", PRINT);
		PrintAtEmpire ("xemp: scanning power output");

		ranking = 0;
		entry = NewPowerEntry ();
		entry-> ranking = ++ ranking;

		for (;;)
		{
			line = ReadEmpire (DONT_PRINT);

			if (EmpireStatus () == E_COMMAND)
			{
				FreeLastPowerEntry ();
				PrintAtEmpire (line);
				return;
			}

			if (EmpireStatus () != E_PRINTING)
			{
				Message ("Sync error");
				Bell ();
				continue;
			}

			if (ScanPowerLine (entry, line))
			{
				entry = NewPowerEntry ();
				entry-> ranking = ++ ranking;
			}
		}
	}
}

void ScanNewPower ()
{
	DoScanPower (True);
}

void ScanPower ()
{
	DoScanPower (False);
}

static PowerEntry FindNationPowerEntry (natid)
int natid;
{
	PowerList ptr;

	if (power_head == (PowerList) 0)
		return (PowerEntry) 0;
	
	for (ptr = power_head; ptr != (PowerList) 0; ptr = ptr-> next)
		if (ptr-> entry-> nat == natid)
			return ptr-> entry;
	
	return (PowerEntry) 0;
}

void PrintPowerEntry (win, natid, start_y)
WinInfo win;
int natid;
int start_y;
{
	PowerEntry entry;

	entry = FindNationPowerEntry (natid);
	if (entry == (PowerEntry) 0)
	{
		PrintN (win, 0, start_y, "No power information found");
		return;
	}


	PrintN (win, 0, start_y, Fmt ("Power report  (ranking #%d)",
				entry-> ranking));
	PrintN (win,  0, start_y + 2, Fmt ("Sects: %s", entry-> nr_sects));
	PrintN (win, 15, start_y + 2, Fmt ("Shells: %s", entry-> shells));
	PrintN (win, 30, start_y + 2, Fmt ("Food:  %s", entry->  food));
	PrintN (win, 45, start_y + 2, Fmt ("Planes: %s", entry-> pln));
	PrintN (win,  0, start_y + 3, Fmt ("Eff:   %s", entry-> eff));
	PrintN (win, 15, start_y + 3, Fmt ("Guns:   %s", entry-> guns));
	PrintN (win, 30, start_y + 3, Fmt ("Oil:   %s", entry-> oil));
	PrintN (win, 45, start_y + 3, Fmt ("Ships:  %s", entry-> ship));
	PrintN (win,  0, start_y + 4, Fmt ("Civ:   %s", entry-> civ));
	PrintN (win, 15, start_y + 4, Fmt ("Petr:   %s", entry-> pet));
	PrintN (win, 30, start_y + 4, Fmt ("Money: %s", entry-> money));
	PrintN (win,  0, start_y + 5, Fmt ("Mil:   %s",entry-> mil));
	PrintN (win, 15, start_y + 5, Fmt ("Dust:   %s", entry-> dust));
}
