#include "setup.h"

bool verbose = False;
bool depend_proto = True;
bool make_termcap = False;
bool just_tcemp = False;
bool just_xemp = False;
bool verbose_output = False;

char * target,		* compiler,		* bsd;
char * lopts, 		* copts, 		* x11lib;
char * wsize,		* dhost,		* dport;
char * xempinf,		* empinf,		* hasei;
char * ctags,		* ftpdir;

	/*
	 *	No default-value should be the empty string.
	 *
	 *	example: def_lopts = "";
	 */

char * def_compiler = "/bin/cc";
char * def_bsd = "n";
char * def_copts = "";		/* compiler options */
char * def_lopts = "-s";		/* loader options   */
char * def_x11lib = "/usr/lib/X11";
char * def_wsize = "128x64";
char * def_host = "koto.cs.vu.nl";
char * def_port = "1617";
char * def_xempinf = "/home/student1/hjvissc/xemp/info";
char * def_hasei = "n";			/* has empire-info */
char * def_empinf = "/home/student1/hjvissc/ksu/info";
char * def_ctags = "ctags";
char * def_ftpdir = "/tmp";

char * incl_dirs [] = 
{
	"include_tc",
 	"include_x",
	"include",
	"icons",
	"parse",
	(char *) 0
};

char * x_incl_dirs [] =
{
	"include_x",
	"include",
	"icons",
	"parse",
	(char *) 0
};

char * tc_incl_dirs [] =
{
	"include_tc",
	"include",
	"parse",
	(char *) 0
};

char * tc_dirs [] =
{ 
	"misc",		"plane",	"ship",
	"parse",	"commands",	"data",
	"util",		"termc",	"update",
	"sects",	"census",	"nuke",
	(char *) 0
};

char * x_dirs [] =
{
	"misc",		"plane",	"ship",
	"parse",	"commands",	"data",
	"util",		"x",		"update",
	"sects",	"census",	"nuke",
	(char *) 0
};

char * all_dirs [] =
{
	"misc",		"plane",	"ship",
	"parse",	"commands",	"data",
	"util",		"x",		"update",
	"sects",	"census",	"nuke",
	"termc",	"include",	"include_tc",
	"include_x",	"icons",	"src",
	"info",		(char *) 0
};

char * src_dirs [] = 
{
	"misc",		"plane",	"ship",
	"parse",	"commands",	"data",
	"util",		"x",		"update",
	"sects",	"census",	"nuke",
	"termc",	(char *) 0
};
	
int def_max_x, def_max_y;

char * author = "hjvissc@cs.vu.nl";
char * makef = "makefile";

void Defaults ()
{
	Verbose ("Using default values.\n");

	compiler = def_compiler;
	if (access ("/usr/include/sys/termios.h", R_OK) == 0)
		bsd = "n";
	else
		bsd = "y";
	lopts = def_lopts;
	copts = def_copts;
	x11lib = def_x11lib;
	dhost = def_host;
	dport = def_port;
	xempinf = def_xempinf;
	empinf = def_empinf;
	hasei = def_hasei;
	ftpdir = def_ftpdir;
	ctags = def_ctags;
	(void) sscanf (def_wsize, "%dx%d", & def_max_x, & def_max_y);
}
