#include "include.h"

static void Usage ()
{
	fprintf (stderr, "Usage: scan [-x funcname] filenames\n");
	fprintf (stderr, "       -x funcname: removes funcname from files\n");
}

main (argc, argv)
int argc;
char ** argv;
{
	char ch;

	bool delfuncflag = False;
	char * functodel;

	extern char * optarg;
	extern int optind;

	while ((ch = getopt (argc, argv, "x:")) != -1)
	{
		switch (ch)
		{

		case 'x':
			delfuncflag = True;
			functodel = optarg;
			break;
		
		default:
			Usage ();
			exit (-1);
		}
	}

	if (optind >= argc)
	{
		Usage ();
		exit (0);
	}

	if (delfuncflag)
	{
		for (; optind < argc; optind ++)
			DelFunc (functodel, argv [optind]);
	}
}
