#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "var.h"

static char * last_planes = (char *) 0;
static char * last_escort = (char *) 0;
static char * last_path = (char *) 0;
static char * last_trans = (char *) 0;
static int last_x, last_y;
static Sector last_sct = (Sector) 0;
static Sector last_design = (Sector) 0;

bool FeedFly (command, planes, escorts, strat, assem, path, trans)
char * command, * planes, * escorts, * strat, * assem, * path, * trans;
{

	FeedEmpire (Fmt ("%s %s %s %s %s %s %s",
		command,
		planes,
		strlen (escorts) == 0 ? "." : escorts,
		strat == (char *) 0 ? "" : strat,
		assem,
		path,
		trans == (char *) 0
			? ""
			: strlen (trans) == 0 ? "." : trans), PRINT);
	
	return True;

	/*
	 * Looks a lot better, but takes a lot more time
	 *
	 printf("in FeedFly (plane/fly.c)\n");
	for (i = 0; i < 7; i ++)
	{

		switch (i)
		{

		case 0:  ptr = command; break;
		case 1:  ptr = planes; break;
		case 2:  ptr = escorts; break;
		case 3:  ptr = strat; break;
		case 4:  ptr = assem; break;
		case 5:  ptr = path; break;
		case 6:  ptr = trans; break;
		default: ptr = (char *) 0; break;

		}

		if (ptr != (char *) 0)
		{
			if (! first)
			{
				(void) WaitForPrompt (PRINT);
				if (EmpireStatus () == E_COMMAND)
					return False;
			}
			FeedEmpire (ptr, PRINT);
			first = False;
		}
	}

	return True;
	*/
}

void RedoFly ()
{
	char * new_path;
	char * planes;

	if (last_sct == last_design && last_sct == cursct)
	{
		DoFly (last_x, last_y, last_planes, last_escort,
						last_trans, last_path);
		return;
	}

	if (last_layout == PLANE_MODE)
		planes = Fmt ("%d", pl_nr (curplane));
	else if (last_layout == WING_MODE)
		planes = WingId ();
	else
	{
		Message ("No current plane/wing selected !");
		Bell ();
		planes = (char *) 0;
	}

	if (last_design == (Sector) 0)
	{
		Message ("No last designation sector");
		Bell ();
		return;
	}

	if (last_sct != cursct)
	{
		new_path = BestFlyPath (s_xcd (cursct), s_ycd (cursct),
				s_xcd (last_design), s_ycd (last_design));

		if (new_path == (char *) 0)
		{
			Message ("Too far away !");
			Bell ();
			return;
		}

		if (last_path != (char *) 0)
			free (last_path);
		last_path = Str (new_path);
	}

	DoFly (last_x, last_y, planes, "", last_trans, last_path);
}

void Fly (x, y)
int x, y;
{
	DoFly (x, y, (char *) 0, (char *) 0, (char *) 0, (char *) 0);
}

	/*
	 *	Bind key to fly ( item )
	 */

void BindFly (x, y, str)
int x, y;
char * str;
{
	char buf [20];
	char * planes;

	if (last_layout == PLANE_MODE)
		planes = Fmt ("%d", pl_nr (curplane));
	else if (last_layout == WING_MODE)
		planes = WingId ();
	else
		planes = (char *) 0;

	if (str != (char *) 0 && sscanf (str, " ( %s )", buf) == 1)
	{
		if (CharToItem (* buf) < 0)
		{
			Message (Fmt ("Illegal bind: fly (%s)", buf));
			Bell ();
			return;
		}

		DoFly (x, y, planes, (char *) 0, buf, (char *) 0);
	}
	else
		DoFly (x, y, planes, (char *) 0, (char *) 0, (char *) 0);
}

void DoFly (x, y, planes, escort, trans, path)
int x, y;
char * planes;
char * escort, * trans;
char * path;
{
	int max_range;
	int max_load;
	Sector design;
	int carrier;
	bool all_yours;

	UnmarkAllPlanes ();

	if (planes == (char *) 0)
	{
		planes = SelectPlanes (x, y, cursct, MIS_FLY,
							"Fly which planes ?");
		if (planes == (char *) 0)
		{
			Message ("Fly cancelled");
			return;
		}
	}

	MarkPlanes (planes);
	FilterPlanesMob ();
	FilterPlanesHaving (P_M);
	FilterPlanesHaving (P_O);
	MarkAs20Mob ();
	max_load = 2 * LoadMarked (False);

	planes = MarkedPlanesId (MOB20);
	if (planes == (char *) 0)
	{
		Message ("Nothing to fly with");
		Bell ();
		return;
	}

	if (last_planes != (char *) 0)
		free (last_planes);
	last_planes = Str (planes);

	if (escort == (char *) 0)
		escort = SelectPlanes (x, y, cursct, MIS_ESCORT,
						"Use as escort ?");

	if (escort != (char *) 0)
	{
		MarkPlanes (escort);
		FilterPlanesMob ();
		FilterPlanesHaving (P_M);
		FilterPlanesHaving (P_O);

		escort = MarkedPlanesId (MOB12);
	}

	if (escort == (char *) 0)
		escort = "";

	if (last_escort != (char *) 0)
		free (last_escort);
	last_escort = Str (escort);

	if (! ChargePetrol ())
	{
		Message ("Not enough petrol !");
		Bell ();
		return;
	}

	max_range = MaxRangeMarked (cursct); 
	SetAgain (RedoFly);
	last_x = x;
	last_y = y;
	last_sct = cursct;
	if (path == (char *) 0)
	{
		path = AskFlyRoute (cursct, max_range - 1, "fly");

		if (path == (char *) 0)
		{
			Message ("fly cancelled");
			UnchargePetrol ();
			return;
		}
	}
	else
	{
		if (strlen (path) > max_range - 1)
		{
			Message ("Too far away !");
			UnchargePetrol ();
			return;
		}
	}

	if (strlen (path) == 0 && ! Confirm ("No path, fly anyway? ", False))
	{
		Message ("Fly cancelled");
		UnchargePetrol ();
		return;
	}
		

	if (last_path != (char *) 0)
		free (last_path);
	last_path = Str (path);
	
	design = FollowOwnedPath (cursct, path, & all_yours);
	last_design = design;

	if (design == (Sector) 0 || ! s_owned (design) && s_des (design) != '.')
	{
		Message ("end sector should be yours !");
		UnchargePetrol ();
		Bell ();
		return;
	}

	if (s_des (design) == '^')
	{
		Message ("you can't land in mountains");
		UnchargePetrol ();
		Bell ();
		return;
	}

	carrier = -1;
	if (s_des (design) == '.')
	{
		if (! AllMarkedPlanesHaveAnyOf (P_L | P_G))
		{
			Message ("All planes should be light !");
			Bell ();
			UnchargePetrol ();
			return;
		}

		carrier = AskCarrier (x + 2, y + 2, design);

		if (carrier < 0)
		{
			UnchargePetrol ();
			Message ("No aircraft carrier here !");
			Bell ();
			return;
		}
	}
/*
	else if (s_des(design) == 'h') {
	
	}
*/
	else if (s_des (design) != '*' || s_eff (design) < 60)
	{
		if (! AllMarkedPlanesHaveAnyOf (P_L | P_G))
		{
			Message ("End sector is not an airport !");
			Bell ();
			UnchargePetrol ();
			return;
		}
	}

	if (max_load > 0 && design != cursct)
	{
		if (trans == (char *) 0)
		{
			trans = AskFlyItem (x + 2, y + 2, max_load, MIS_FLY);
			if (trans == (char *) 0)
			{
				Message ("Fly cancelled");
				UnchargePetrol ();
				return;
			}
		}

		if (* trans != '\0')
			if (! LoadMarkedPlanes (* trans, 2))
			{
				Message (Fmt ("Not enough %s for all planes!",
						trans));
				Bell ();
				UnchargePetrol ();
				Bell ();
				return;
			}
	}
	else
		trans = "";

	if (last_trans != (char *) 0)
		free (last_trans);
	last_trans = Str (trans);

	if (command_state == FORCE_BUF_STATE && all_yours)
	{
		FeedCommand (Fmt ("fly %s %s %s %sh %s",
			last_planes,
			strlen (last_escort) == 0 ? "." : last_escort,
			CrdStr (cursct),
			last_path,
			strlen (trans) == 0 ? "." : trans), PRINT);
	}
	else
	{
		if (! FeedFly ("fly", last_planes, last_escort, (char *) 0,
			CrdStr (cursct), Fmt ("%sh", last_path), trans))
		{
			Message ("Something went wrong, fly failed?");
			Bell ();
			UnchargePetrol ();
			if (* trans != '\0')
				UnloadMarkedPlanes (* trans, 2);
			return;
		}
		ParseFlyOutput (carrier);
	}

	ChargeMobility ();
	printf("1");
	MoveMarkedPlanes (design, carrier);
	printf("2");
	if ((trans != NULL) &&(* trans != '\0'))
	  UnloadMarkedPlanes (* trans, 2);
	printf("3");
	CensusSct (cursct);
	DrawSector (cursct);
	Message ("fly done");
}
