#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "census.h"
#include "var.h"
#include "ship.h"

void NewCap (country)
int country;
{
	int button;
	Sector sct;
	bool cont, found;
	int capx, capy;
	char * ptr, * part;

	(void) FeedEmpire (Fmt ("newcap %d", country), PRINT);
	Message ("Select starting sector");
	MesBut ("Accept", "Abort", "Next Choice");

	cont = True;
	while (cont)
	{
		ptr = ReadEmpire (PRINT);

		if (EmpireStatus () == E_COMMAND)
		{
			Message ("Something went wrong!");
			MesClearBut ();
			Bell ();
			return;
		}

		found = (sscanf (ptr, "Cap at %d,%d", & capx, & capy) == 2);
		if (found)
		{
			sct = World (capx, capy, S_DESIG);
			MarkSector (sct);
			Goto (sct);
			WaitButtonPress (& button);
			UnmarkSector (sct);

			switch (button)
			{

			case LEFT_BUTTON:
				(void) FeedEmpire ("yes", PRINT);
				(void) WaitForPrompt (PRINT);
				cont = False;
				break;
			
			case MIDDLE_BUTTON:
				(void) FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				MesClearBut ();
				Message (Fmt ("WARNING: No capital for %d",
					country));
				Bell ();
				return;
			
			case RIGHT_BUTTON:
				(void) FeedEmpire ("no", PRINT);
				break;
			}
		}
	}

	Message ("Redumping sectors");
	part = Fmt ("%d:%d,%d:%d", capx - 2, capx + 2, capy - 2, capy + 2);
	FScanDump (part, DONT_PRINT);
	DrawMap ();

	MesClearBut ();
}

void DoNewCap (x, y)
int x, y;
{
	char * country;

	country = AskCountry (x, y, "For which country?", False);
	if (country == (char *) 0)
	{
		Message ("Newcap command cancelled");
		return;
	}

	NewCap (CountryId (country));
}

void AddNation (x, y)
int x, y;
{
	WinInfo win;
	int country_nr;
	char * ans, * ptr;
	char * feed;

	RaiseAll ();
	win = OpenWindow (map_win, x, y - 5, 80, 10, CHARS, MENU, 0);
	ClearWindow (win);
	SetDefaultCursor (win, CR_MENU);

	PrintN (win, 1, 1, "Add Nation");

	FeedEmpire ("add", PRINT);
	ptr = WaitForPrompt (PRINT);
	if (sscanf (ptr, "New country number? (%d", & country_nr) == 0)
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		PrintN (win, 1, 3, "No more free countries!");
		Bell ();
		Pause ();
		DestroyWindow (win);
		return;
	}

	FeedEmpire (Fmt ("%d", country_nr), PRINT);
	(void) WaitForPrompt (PRINT);
	PrintN (win, 3, 1, Fmt ("Country number is %d", country_nr));

	ans = GetQuest (win, 4, "Country name? ", 16, GS_TEXT);
	if (ans == (char *) 0 || * ans == '\0')
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		DestroyWindow (win);
		return;
	}
	FeedEmpire (ans, PRINT);
	(void) WaitForPrompt (PRINT);
	AddCountry (country_nr, ans);

	ans = GetQuest (win, 5, "Password? ", 16, GS_TEXT);
	if (ans == (char *) 0 || * ans == '\0')
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		DestroyWindow (win);
		return;
	}

	(void) FeedEmpire (ans, PRINT);
	(void) WaitForPrompt (PRINT);

	ans = GetQuest (win, 6,
		"(V)isitor, (N)ew, (A)ctive, (G)od, (D)elete [N]: ",
		1, "vVnNaAgGdD");

	if (ans == (char *) 0)
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		DestroyWindow (win);
		return;
	}

	switch (* ans)
	{

	case 'v':
	case 'V':
		feed = "visitor";
		break;

	case '\0':
	case 'n':
	case 'N':
		feed = "new";
		break;

	case 'a':
	case 'A':
		feed = "active";
		break;
	
	case 'g':
	case 'G':
		feed = "god";
		break;

	case 'd':
	case 'D':
		feed = "delete";
		break;
	}

	(void) FeedEmpire (feed, PRINT);
	(void) WaitForPrompt (PRINT);
	
	ans = GetQuest (win, 7,
		"(C)heck, (W)ipe or (I)gnore existing sects [I]: ",
		1, "cCwWiI");
	
	if (ans == (char *) 0)
	{
		FeedEmpire ("aborted", PRINT);
		(void) WaitForPrompt (PRINT);
		DestroyWindow (win);
		return;
	}

	switch (* ans)
	{

	case 'c':
	case 'C':
		feed = "check";
		break;

	case 'w':
	case 'W':
		feed = "wipe";
		break;

	case '\0':
	case 'i':
	case 'I':
		feed = "ignore";
		break;
	}

	(void) FeedEmpire (feed, PRINT);
	(void) WaitForPrompt (PRINT);

	DestroyWindow (win);
	NewCap (country_nr);
	Message ("Country added");
}
