#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "census.h"
#include "var.h"
#include "ship.h"

void DeityChange (sct)
Sector sct;
{
		/* deity changing a unknown sector */
	if (deity && ! KNOW_ALL (sct)) {
		Message ("No info yet. Dumping sector...");
		RedumpSector (sct, PRINT);
	}
}

void EditLand (sct, what, newv)
Sector sct;
char what;
int newv;
{
	FeedEmpire (Fmt ("edit land %s", CrdStr (sct)), PRINT);
	(void) WaitForPrompt (PRINT);

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);

	FeedEmpire (Fmt ("%c %-5d", what, newv), PRINT);
	(void) WaitForPrompt (PRINT);

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);
}

static bool OpenEditShip (nr)
int nr;
{
	FeedEmpire (Fmt ("edit ship %d", nr), PRINT);
	(void) WaitForPrompt (PRINT);
	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () == E_COMMAND) {
		Message ("Edit ship failed");
		Bell ();
		return False;;
	}

	return True;
}

void EditShip (ship, what, newv)
Ship ship;
char what;
int newv;
{
	if (! OpenEditShip (sh_nr (ship)))
		return;

	FeedEmpire (Fmt ("%c %-5d", what, newv), PRINT);
	(void) WaitForPrompt (PRINT);

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);
}

bool DeityChangeLand (x, y, ch, new)
int x, y;
char ch;
int *new;
{
	char *ptr;

	Print (census_win, x, y, "    ", NORMAL);
	ptr = GetString (census_win, x, y, 4, GS_PNUMBER);

	if (interrupt || ptr == (char *) 0 || * ptr == '\0')
	{
		interrupt = False;
		Message ("Cancelled");
		return False;
	}

	* new = atoi (ptr);

	EditLand (cursct, ch, * new);

	return True;
}

extern char all_chars[], *comm_chars;
extern int last_layout;

static char ship_chars [] = "EM cmT";

static char e_shipchars[] ="O FL PTEMcmufsgpidolhr";

void DeityEditShips (x, y)
int x, y;
{
	Ship ship;
	Sector to;
	WinInfo win;
	int max, num, new, newx, newy;
	int nx, ny;
	char ch, *ptr;

	ship = AskShip (x, y, "Edit which ship ? ", True);
	if (ship == (Ship) 0)
		return;

	if (! OpenEditShip (sh_nr (ship)))
		return;

	win = OpenRelToRoot (map_win, x, y, 50, 10, CHARS, 0);
	ReverseCursor (CR_ARROWS, True);
	SetDefaultCursor (win, CR_ARROWS);

	PrintN (win, 1, 1, Fmt ("Owner %-20s", CountryName (sh_owner (ship))));
	PrintN (win, 31, 1, Fmt ("Flt %s", GiveShipQuantStr (ship, 'F')));
	PrintN (win, 1, 2, Fmt ("Loc %-4d, %-4d",
					sh_xcd (ship), sh_ycd (ship)));
	PrintN (win, 31, 2, Fmt ("Pla %s", GiveShipQuantStr (ship, 'P')));
	PrintN (win, 1, 3, Fmt ("Tec %s       Eff %s       Mob %s",
				GiveShipQuantStr (ship, 'T'),
				GiveShipQuantStr (ship, 'E'),
				GiveShipQuantStr (ship, 'M')));
	PrintN (win, 1, 4, Fmt ("civ %s       mil %s       uw  %s",
				GiveShipQuantStr (ship, 'c'),
				GiveShipQuantStr (ship, 'm'),
				GiveShipQuantStr (ship, 'u')));
	PrintN (win, 1, 5, Fmt ("foo %s       she %s       gun %s",
				GiveShipQuantStr (ship, 'f'),
				GiveShipQuantStr (ship, 's'),
				GiveShipQuantStr (ship, 'g')));
	PrintN (win, 1, 6, Fmt ("pet %s       iro %s       dus %s",
				GiveShipQuantStr (ship, 'p'),
				GiveShipQuantStr (ship, 'i'),
				GiveShipQuantStr (ship, 'd')));
	PrintN (win, 1, 7, Fmt ("oil %s       lcm %s       hcm %s",
				GiveShipQuantStr (ship, 'o'),
				GiveShipQuantStr (ship, 'l'),
				GiveShipQuantStr (ship, 'h')));
	PrintN (win, 1, 8, Fmt ("rad %s", GiveShipQuantStr (ship, 'r')));

	FlushWindow (win);
	while (SelButtonAtWin (win, & nx, & ny, (int *) 0))
	{
		if (ny < 1 || ny > 8)
			continue;
		nx = ((int) (nx / 15)) * 15 + 5;
		num = nx / 15;
		if (num > 2 || (ny == 8 && num != 0))
			continue;
		if (ny <= 2 && num == 1)
		{
			nx -= 15;
			num = 0;
		}

		ch = e_shipchars[(ny - 1) * 3 + num];
		if (ch == 'E')
			max = 100;
		else if (ch == 'M')
			max = MAX_SHIPMOB;
		else if (ch == 'T')
			max = 9999;
		else
			max = MaxShipCargo (ship, ch);

		if (strchr ("OFL ", ch) == (char *) 0 && max == 0)
		{
			Message (Fmt
			    ("The captain refuses to take %s on board",
			    ch == 'P' ? "planes" : ItemName (CharToItem (ch))));
			Bell ();
			continue;
		}
		
		if (ny == 1 && num <= 1)
		{
			ptr = AskCountry (x + 10, y + 10, "New owner ?", True);
			if (ptr != (char *) 0)
				new = CountryId (ptr);
		}
		else if (ny == 1)
		{
			PrintN (win, nx, ny, " ");
			ptr = GetString (win, nx, ny, 1, "a-zA-Z~");
			if (ptr != (char *) 0)
				new = (int) *ptr;
		}
		else if (ny == 2 && num <= 1)
		{
			PrintN (win, nx, ny, "          ");
			ptr = GetString (win, nx, ny, 10, GS_SECTOR);
			if (ptr != (char *) 0 && (sscanf (ptr, "%d%*[	 ,]%d",
			       &newx, &newy) != 2 || ((newx + newy) % 2) != 0))
			{
				ptr = (char *) 0;
				Message ("Bad coordinates");
				Bell ();
			}
			if (ptr != (char *) 0)
			{
				to = World (newx, newy, S_DESIG);
				if (to == (Sector) 0)
				{
					Message ("Bad coordinates");
					Bell ();
					ptr = (char *) 0;
				}
				else if (! KNOW_ALL (to))
				{
					Message (
					     "No info yet. Dumping sector...");
					FeedEmpire ("", PRINT);
					(void) FScanDump (ptr, PRINT);
					if (! OpenEditShip (sh_nr (ship)))
						break;
				}
			}
		} else
		{
			PrintN (win, nx, ny, "    ");
			ptr = GetString (win, nx, ny, 4, GS_PNUMBER);
			if (ptr != (char *) 0)
			{
				new = atoi (ptr);
				if (new > max)
					new = max;
			}
		}

		if (interrupt || ptr == (char *) 0 || *ptr == '\0')
		{
			interrupt = False;
		}
		else
		{
			if (ny == 1 && num == 2)
				FeedEmpire (Fmt ("%c %c", ch, (char) new),
									PRINT);
			else if (ny == 2 && num <= 1)
				FeedEmpire (Fmt ("%c %d,%d", ch, newx, newy),
									PRINT);
			else
				FeedEmpire (Fmt ("%c %-5d", ch, new), PRINT);

			(void) WaitForPrompt (PRINT);

			if (ny == 2 && num <= 1)
			{
				MoveShip (ship, to);
				DrawSector (World (sh_xcd (ship),
						   sh_ycd (ship),
						   S_DESIG));
				DrawSector (to);
			} else
				SetShipQuant (ship, ch, new);

			if (ship == curship)
				Census ();
		}

		if (ny == 1 && num <= 1)
			PrintN (win, 7, 1, Fmt ("%s",
					CountryName (sh_owner (ship))));
		else if (ny == 2 && num <= 1)
			PrintN (win, 1, 2, Fmt ("Loc %d, %d", 
					sh_xcd (ship), sh_ycd (ship)));
		else
			PrintN (win, nx, ny, Fmt ("%s", 
				GiveShipQuantStr (ship, ch)));

		FlushWindow (win);
	}

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);

	ReverseCursor (CR_ARROWS, False);

	DestroyWindow (win);
}

struct country {
	char name[MAX_CNAMELEN], rep[MAX_CNAMELEN];
	int btu;
	long mres;
	int cap_x, cap_y, org_x, org_y;
	int status, m_used;
	double tech, res, edu, hap;
	long money;
};
	

bool OpenEditCountry (nr, cc)
int nr;
struct country *cc;
{
	char *ptr, *tmp;

	FeedEmpire (Fmt ("edit country %d", nr), PRINT);
	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (strncmp (ptr, "Name", 4) != 0 || strlen (ptr) < 52)
		return False;

	tmp = ptr + 31;
	while (*tmp == ' ') tmp--;
	*++tmp = '\0';
	strncpy (cc->name, tmp > ptr + 10 ? ptr + 10 : "", MAX_CNAMELEN);
	strncpy (cc->rep, * (ptr + 52) != '\0' ? ptr + 52 : "", MAX_CNAMELEN);
	cc-> name[MAX_CNAMELEN - 1] = '\0';
	cc-> rep[MAX_CNAMELEN - 1] = '\0';

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "BTUs <b>: %d Reserves <m>: %ld", &cc-> btu,
							&cc-> mres) != 2)
		return False;

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "Capital <c>: %d%*[ ,	]%d Origin <o>: %d%*[ ,	]%d",
		     &cc-> cap_x, &cc-> cap_y, &cc-> org_x, &cc-> org_y) != 4)
		return False;

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "Status <s>: %i Min Used <u>:  %d",
				       &cc-> status, &cc-> m_used) != 2)
		return False;

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "Technology <T>: %lf Research <R>: %lf",
				       &cc-> tech, &cc-> tech) != 2)
		return False;

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "Education <E>: %lf Happiness <H>: %lf",
				       &cc-> edu, &cc-> hap) != 2)
		return False;

	ptr = ReadEmpire (PRINT);
	if (ptr == (char *) 0 || EmpireStatus () != E_PRINTING)
		return False;
	if (sscanf (ptr, "Money <M>: $%ld", &cc-> money) != 1)
		return False;
	
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () == E_COMMAND)
		return False;

	FeedEmpire ("", PRINT);

	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () == E_COMMAND)
		return False;

	return True;
}

/* 
 *                     Country #:  0
 * Name      POGO                  Repres.    peter
 * BTUs      252                   Reserves   0
 * Capital   118,10                Origin     0,0
 * Status    0xd                   Min Used   15
 * Tech      1980.07               Research   1980.07
 * Educ      1248.59               Happiness  395.06
 * Money     $123456289
 */

static char country_chars[] = "nrbmcosuTREHM";

void DeityEditCountry (x, y)
int x, y;
{
	WinInfo win;
	char *name, *ptr, ch;
	int cnum;
	struct country cc, new;
	int newx, newy, num;
	int nx, ny;
	double newf;

	name = AskCountry (x, y, "Edit which country ? ", True);
	if (name == (char *) 0)
	{
		Message ("Edit Country Failed");
		Bell ();
		return;
	}

	cnum = CountryId (name);

	if (! OpenEditCountry (cnum, &cc))
	{
		WaitForPrompt (PRINT);
		return;
	}

	win = OpenRelToRoot (map_win, x, y, 70, 12, CHARS, 0);
	/* ReverseCursor (CR_ARROWS, True); */
	SetDefaultCursor (win, CR_ARROWS);

	for (;;)
	{
		PrintMarked (win, 2, 10, " Done ", BOLD);
		PrintMarked (win, 32, 10, " Prev ", BOLD);
		PrintMarked (win, 62, 10, " Next ", BOLD);

		PrintN (win, 1, 1, Centered (Fmt ("Country #: %d", cnum), 68));
		PrintN (win, 1, 2, Fmt ("Name      %s", cc.name));
		PrintN (win, 33, 2, Fmt ("Repres.    %s", cc.rep));
		PrintN (win, 1, 3, Fmt ("BTUs      %d", cc.btu));
		PrintN (win, 33, 3, Fmt ("Reserves   %ld", cc.mres));
		PrintN (win, 1, 4, Fmt ("Capital   %d,%d", cc.cap_x, cc.cap_y));
		PrintN (win, 33, 4, Fmt ("Origin     %d,%d",
							cc.org_x, cc.org_y));
		PrintN (win, 1, 5, Fmt ("Status    0x%x", cc.status));
		PrintN (win, 33, 5, Fmt ("Min Used   %d", cc.m_used));
		PrintN (win, 1, 6, Fmt ("Tech      %.2lf", cc.tech));
		PrintN (win, 33, 6, Fmt ("Research   %.2lf", cc.res));
		PrintN (win, 1, 7, Fmt ("Educ      %.2lf", cc.edu));
		PrintN (win, 33, 7, Fmt ("Happiness  %.2lf", cc.hap));
		PrintN (win, 1, 8, Fmt ("Money     $ %ld", cc.money));
		FlushWindow (win);

		if (! SelButtonAtWin (win, & nx, & ny, (int *) 0))
			break;

		if (ny == 10)
		{
			num = nx / 30;
			if (num == 0) break;
			else if (num == 2)
			{
				if (! ExistCountry (cnum + 1))
				{
					Message ("No next country");
					Bell ();
					continue;
				}
				cnum++;
			}
			else
			{
				if (! ExistCountry (cnum - 1))
				{
					Message ("No previous country");
					Bell ();
					continue;
				}
				cnum--;
			}

			FeedEmpire ("", PRINT);
			(void) WaitForPrompt (PRINT);
			if (! OpenEditCountry (cnum, &new))
			{
				Message (Fmt ("Edit %d Country Failed", cnum));
				if (num == 2) cnum--;
				else cnum++;
				Bell ();
				(void) WaitForPrompt (PRINT);
				if (! OpenEditCountry (cnum, &cc))
				{
					WaitForPrompt (PRINT);
					break;
				}
				continue;
			}
			cc = new;
			ClearWindow (win);
			continue;
		}

		if (nx < 33) num = 0;
		else num = 1;

		if (num == 0) nx = 11;
		else nx = 44;

		if (ny == 8) nx += 2;

		if (ny < 2 || ny > 8 || (ny == 8 && num == 1))
			continue;
		
		ch = country_chars[(ny - 2) * 2 + num];

		PrintN (win, nx, ny, "                     ");
		if (ny == 2)
			ptr = GetString (win, nx, ny, 20, GS_NAME);
		else if (ny == 3 || (ny == 5 && num == 1) || ny == 8)
			ptr = GetString (win, nx, ny, 10, GS_PNUMBER);
		else if (ny == 4)
			ptr = GetString (win, nx, ny, 10, GS_SECTOR);
		else if (ny == 5)
			ptr = GetString (win, nx, ny, 10, "0-9A-Fa-fx");
		else 
			ptr = GetString (win, nx, ny, 6, "0-9.");

		if (interrupt || ptr == (char *) 0 || *ptr == '\0')
		{
			interrupt = False;
			continue;
		}
		if (ny == 2)
		{
			FeedEmpire (Fmt ("%c %s", ch, ptr), PRINT);
			if (num == 0)
			{
				strncpy (cc. name, ptr, MAX_CNAMELEN);
				cc. name[MAX_CNAMELEN - 1] = '\0';
			}
			else
			{
				strncpy (cc. rep, ptr, MAX_CNAMELEN);
				cc. rep[MAX_CNAMELEN - 1] = '\0';
			}
		}
		else if (ny == 5 && num == 0)
		{
			sscanf (ptr, "%i", &cc.status);
			FeedEmpire (Fmt ("%c %d", ch, cc.status), PRINT);
		}
		else if (ny == 3 || ny == 5 || ny == 8)
		{
			FeedEmpire (Fmt ("%c %s", ch, ptr), PRINT);
			if (ny == 3)
				if (num == 0) cc.btu = atoi (ptr);
				else sscanf (ptr, "%ld", &cc.mres);
			else if (ny == 5)
				cc.m_used = atoi (ptr);
			else
				sscanf (ptr, "%ld", &cc.money);
		}
		else if (ny == 4)
		{
			if (sscanf (ptr, "%d%*[	 ,]%d", &newx, &newy) != 2)
			{
				Message ("Bad coordinates");
				Bell ();
				continue;
			}
			FeedEmpire (Fmt ("%c %d%,%d", ch, newx, newy),
									PRINT);
			if (num == 0)
			{
				cc.cap_x = newx;
				cc.cap_y = newy;
			}
			else
			{
				cc.org_x = newx;
				cc.org_y = newy;
			}
		}
		else
		{
			if (sscanf (ptr, "%lf", &newf) != 1)
			{
				Message ("Bad value");
				Bell ();
				continue;
			}
			FeedEmpire (Fmt ("%c %lf", ch, newf), PRINT);
			if (ny == 6)
			{
				if (num == 0) cc.tech = newf;
				else cc.res = newf;
			}
			else
			{
				if (num == 0) cc.edu = newf;
				else cc.hap = newf;
			}
		}

		(void) WaitForPrompt (PRINT);
		PrintN (win, nx, ny, "                     ");
	}

	FeedEmpire ("", PRINT);
	(void) WaitForPrompt (PRINT);

	/* ReverseCursor (CR_ARROWS, False); */
  	SetDefaultCursor (win, CR_ARROWS);
	DestroyWindow (win);
}
