	/*
	 *	commands.c
	 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "ship.h"

 /*****************************************************************************
 *			Buffer command					      *
 *****************************************************************************/

#define BF_TOGGLE	0
#define BF_SHOW		1
#define BF_FEED		2
#define	BF_TEST		3

#define BF_MAX		4

char * buf_str [] =
{
	"-------------------------",
	"show buffered commands         ",   /* Don't delete the extra ' ' */
	"feed buffered commands",
	"enter test mode",
	(char *) 0
};

void InfoBufferMenu (x, y, i)
{
	switch (i)
	{

	case BF_TOGGLE:
		Help (x, y, "Buffer Toggle");
		break;

	case BF_SHOW:
		Help (x, y, "Buffer Show");
		break;

	case BF_FEED:
		Help (x, y, "Buffer Feed");
		break;

	case BF_TEST:
		Help (x, y, "Buffer Test");
		break;

	default:
		Help (x, y, "No Help");
		break;
	}
}

void BufferMenu (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	bool cont;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, buf_str, BF_MAX, 0);

	if (command_state == NORMAL_STATE)
		ChangeString (strings, BF_TOGGLE, "toggle buffering (now off)");
	else if (command_state == BUFFER_STATE)
		ChangeString (strings, BF_TOGGLE, "toggle buffering (now on)");
	else if (command_state == FORCE_BUF_STATE)
		ChangeString (strings, BF_TOGGLE,
				"toggle buffering (now force)");
	else if (command_state == TEST_STATE)
		ChangeString (strings, TEST_STATE, "reset save-files");

	pager = InitPager (strings, "Buffering");
	SetInfoOnPager (pager, InfoBufferMenu);
	MapPagerFromTop (pager, map_win, x, y);

	cont = True;
	while (cont)
	{
		i = PagerMenu (pager);

		if (i < 0)
		{
			cont = False;
			break;
		}

		if (i == BF_TOGGLE)
		{
			if (command_state == NORMAL_STATE)
			{
				command_state = BUFFER_STATE;
				ChangePagerString (pager, BF_TOGGLE,
					"toggle buffering (now on)");
			}
			else if (command_state == BUFFER_STATE)
			{
				command_state = FORCE_BUF_STATE;
				ChangePagerString (pager, BF_TOGGLE,
					"toggle buffering (now force)");
			}
			else if (command_state == FORCE_BUF_STATE)
			{
				command_state = NORMAL_STATE;
				ChangePagerString (pager, BF_TOGGLE,
					"toggle buffering (now off)");
			}
			else /* if (command_state == TEST_STATE) */
			{
				Message ("Not yet implemented");
				cont = False;
			}

			ShowPagerLine (pager, i);
			continue;
		}

		if (i == BF_TEST)
		{
			command_state = TEST_STATE;
			Message ("Now in test mode");
			Disconnect (-1);
			cont = False;
			continue;
		}

		if (i == BF_SHOW)
		{
			ShowBufCommands (x + 5, y + 5);
			continue;
		}

		if (i == BF_FEED)
		{
			if (! BufferdCommands ())
			{
				Message ("No commands buffered");
				Bell ();
			}
			else
				Reconnect ();
			
			cont = False;
		}
	}

	FreePager (pager);
	FreeStrings (strings);
}

/*******************************************************************************
*			Rescan Menu					       *
*******************************************************************************/

#define	RS_ALL		0
#define RS_MAPDUMP	1
#define	RS_DUMP		2
#define	RS_SHIPS	3
#define RS_PLANES	4
#define	RS_NUKES	5
#define	RS_LRADAR	6
#define	RS_SRADAR	7
#define	RS_LOOK		8
#define RS_CNAMES	9
#define	RS_MAP		10
#define RS_SHOWSHPL	11
#define RS_NATION	12
#define RS_SATELLITE	13
#define RS_PRODUCTION	14
#define RS_BMAP		15
#define RS_VERSION      16

#define RS_MAX		17

static char *resc_menu [] =
{
	"all",
	"map & dump",
	"dump",
	"ships & cargo",
	"planes",
	"nukes",
	"land radars",
	"ship radars",
	"lookout & coastwatch",
	"other country names",
	"map",
	"show ship/plane/nuke c&b",
	"nation",
	"satellite",
	"production",
	"bmap",
	"version",
	(char *) 0
};

static void Rescan (x, y)
int x, y;
{
	int i;
	Strings strings;
	Pager pager;
	char * realm;

	strings = InitStrings ();
	AddStringsID (strings, resc_menu, RS_MAX, 0);
	pager = InitPager (strings, "Rescan ?");
	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		i = PagerMenu (pager);

		if (i < 0)
		{
			FreePager (pager);
			FreeStrings (strings);
			return;
		}

		if (i == RS_SHOWSHPL)
		{
			FScanShowShipBuild ();
			FScanShowShipCap ();  
			FScanShowPlaneBuild ();
			FScanShowPlaneCap ();
			FScanNukeShowBuild ();
			FScanNukeShowCap ();
			continue;
		}

		if (i == RS_PLANES)
		{
			DumpPlanes ("*", PRINT);
			continue;
		}

		if (i == RS_SHIPS)
		{
			if (Confirm ("Delete enemy ships ?", True))
				DeleteEnemyShips ();
			MarkAllShips ();
			DumpShips ("*", PRINT);
			SearchMarkedShips (PRINT);
			continue;
		}

		if (i == RS_NUKES)
		{
			FScanNukes ("*", PRINT);
			continue;
		}

		if (i == RS_CNAMES)
			FindMyCnum ();

		if (i == RS_SRADAR)
		{
			FeedRadarShips ();
			DrawMap ();
			continue;
		}

		if (i == RS_SATELLITE)
		{
			FeedSatellite ();
			DrawMap ();
			continue;
		}

		if (i == RS_VERSION)
		{
			FScanVersion();
			continue;
		}

		if (i == RS_PRODUCTION)
		{
		   char *file;
		   file = InputAtMessage ("Productionfile [- for mailbox]: ",
							80, GS_TEXT);
		   if (file == (char *) 0)
			Message ("Rescan production cancelled");
		   else
		        ReadProduction(file);
		   continue;
	        }

		if (i == RS_BMAP)
		{
		        FScanBmap("#", PRINT);
			DrawMap();
			continue;
	        }

		if (i == RS_NATION)
		{
			FScanNation ();
			continue;
		}
		if (i == RS_CNAMES || i == RS_NATION || i == RS_SRADAR)
			continue;
		
		if (i == RS_SATELLITE)
		   continue;

		if (i == RS_VERSION)
		   continue;

		if (i == RS_ALL)
		{
			FScanNation ();
			FScanShowShipBuild ();
			FScanShowShipCap (); 
			FScanShowPlaneBuild ();
			FScanShowPlaneCap ();
			FScanNukeShowBuild ();
			FScanNukeShowCap ();
			DumpPlanes ("*", PRINT);
			DeleteEnemyShips ();
			MarkAllShips ();
			DumpShips ("*", PRINT);
			SearchMarkedShips (PRINT);
			FScanNukes ("*", PRINT);
			FeedRadarShips ();
			DrawMap ();
			FScanMap ("*",PRINT);
			(void) FScanDump("*",PRINT);
			MarkShips ("*");
			FScanCoastWatch("*");
			UnmarkAllShips();
			FScanRadar ("#");
			DrawMap ();
		        continue;
		}
			
		RaiseAll ();
		Message ("Select realm to rescan");

		while ((realm = MySelRealm ()) != (char *) 0)
		{
			if (i == RS_MAP || i == RS_MAPDUMP)
				FScanMap (realm, PRINT);

			if (i == RS_DUMP || i == RS_MAPDUMP)
				(void) FScanDump (realm, PRINT);

			if (i == RS_LOOK)
			{
				MarkShips (realm);
				FScanCoastWatch (realm);
				FScanLookout (realm);
				/* DeleteMarkedEnemyShips (); */
				UnmarkAllShips();
			}

			if (i == RS_LRADAR)
				FScanRadar (realm);

			DrawMap ();
		}

		LowerAll ();
	}
}

/*******************************************************************************
*			Utility Menu					       *
*******************************************************************************/

#define UTIL_DISTR		0
#define UTIL_DISISL		1
#define UTIL_EXPLORE		2
#define UTIL_FERRY		3
#define UTIL_CHECK		4
#define UTIL_UPDATE		5
#define UTIL_COUNTRY		6
#define	UTIL_PLAN		7

#define UTIL_MAX		8

static char * util_strs [] =
{
	"Distribute global",
	"Distribute realm",
	"Explore",
	"Ferry",
	"Check",
	"Simulate update",
	"Country information",
	"Plan utility",
	(char *) 0
};

void HelpOnUtils (x, y, i)
int x, y, i;
{
	switch (i)
	{

	case UTIL_DISTR:
		Help (x, y, "Distribute Utility");
		break;
	
	case UTIL_EXPLORE:
		Help (x, y, "Explore Utility");
		break;
	
	case UTIL_FERRY:
		Help (x, y, "Ferry Utility");
		break;
	
	case UTIL_CHECK:
		Help (x, y, "Check Utility");
		break;
	
	case UTIL_UPDATE:
		Help (x, y, "Update Utility");
		break;

	case UTIL_COUNTRY:
		Help (x, y, "Country Utility");
		break;

	default:
		Help (x, y, "No Help");
		break;
	}
}

static void Utils (x, y)
int x, y;
{
	Pager pager;
	char *path, *realm, *answer;
	Strings strings;
	int x1, x2, y1, y2;
	Sector to, from;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, util_strs, UTIL_MAX, 0);
	pager = InitPager (strings, "Which Utility");
	SetInfoOnPager (pager, HelpOnUtils);
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	FreePager (pager);
	FreeStrings (strings);

	if (interrupt || i < 0)
	{
		interrupt = False;
		Message ("Utility cancelled");
		return;
	}

	switch (i)
	{

	case UTIL_DISTR:
		UtilDist (x + 2, y + 2);
		return;

	case UTIL_DISISL:
		DistributeRealm (cursct);
		return;

	case UTIL_EXPLORE:
		ExploreUtil ();
		return;

	case UTIL_FERRY:
		FerryUtil (x + 2, y + 2);
		break;

	case UTIL_CHECK:
		Check ();
		break;

	case UTIL_UPDATE:
		SimulateUpdate ("#");
		break;

	case UTIL_COUNTRY:
		UtilNatInfo (x + 2, y + 2);
		break;

	case UTIL_PLAN:
		PlanUtil ();
		break;
	}
}


/*******************************************************************************
*			Make Map Menu					       *
*******************************************************************************/

#define MAP_COORD	0
#define MAP_NORM	1
#define MAP_NUM		2
#define MAP_DES		3

#define MAP_MAX	4

static char *str_savemapmodes [] =
{
	"toggle coordinates (now off)",
	"sea/land only",
	"sea/countrynum",
	"designation",
	(char *) 0
};

int GetSaveMode (x, y)
int x, y;
{
	Pager pager;
	Strings strings;
	bool cont;
	int i;

	static int flag = W_COORD;

	strings = InitStrings ();
	AddStringsID (strings, str_savemapmodes, MAP_MAX, 0);

	if ((flag & W_COORD) == 0)
		ChangeString (strings, MAP_COORD,
					"toggle coordinates (now off)");

	pager = InitPager (strings, "Make a map");
	MapPagerFromTop (pager, map_win, x, y);

	cont = True;
	while (cont)
	{
		i = PagerMenu (pager);

		if (i < 0)
		{
			FreePager (pager);
			FreeStrings (strings);
			return -1;
		}

		if (i == MAP_COORD)
		{
			if (flag & W_COORD)
			{
				flag &= ~W_COORD;
				ChangeString (strings, MAP_COORD,
						"toggle coordinates (now off)");
			}
			else
			{
				flag |= W_COORD;
				ChangeString (strings, MAP_COORD,
						"toggle coordinates (now on) ");
			}

			ShowPagerLine (pager, i);
		}
		else
			cont = False;
	}


	FreePager (pager);
	FreeStrings (strings);

	switch (i)
	{

	case MAP_NORM:
		return (flag |  W_NORM);

	case MAP_NUM:
		return (flag |  W_COUN);

	case MAP_DES:
		return (flag |  W_DES);
	}
	/* NOTREACHED */

}

/*******************************************************************************
*			Change Mode Menu				       *
*******************************************************************************/

	/* in main.h you find the defines (NORMAL_MODE, SHIPMODE, etc) */

#ifdef TERMC_VERSION
#define	MAX_MODES	9
#else
#define	MAX_MODES	8
#endif

static char *mode_menu [] =
{
	"Normal mode",
	"Ship mode",
	"Plane mode",
	"Nuke mode",
	"Fleet mode",
	"Wing mode",
	"Ferry mode",
	"Plan mode",
	"Info mode",
	(char *) 0
};

void InfoOnCensusMode (x, y, i)
int x, y, i;
{
	switch (i) {
		case NORMAL_MODE:
			Help (x, y, "Normal Mode");
			break;
		case SHIP_MODE  :
			Help (x, y, "Ship Mode");
			break;
		case PLANE_MODE :
			Help (x, y, "Plane Mode");
			break;
		case NUKE_MODE 	:
			Help (x, y, "Nuke Mode");
			break;
		case FLEET_MODE :
			Help (x, y, "Fleet Mode");
			break;
		case WING_MODE  :
			Help (x, y, "Wing Mode");
			break;
		default		:
			Help (x, y, "No Help");
			break;
	}
}


void ChangeCommandMode (x, y)
int x, y;
{
	Pager pager;
	Strings strings;
	bool drawmap;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, mode_menu, MAX_MODES, 0);

	pager = InitPager (strings, "Which mode ?");
	SetInfoOnPager (pager, InfoOnCensusMode);
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);

	drawmap = (command_mode == PLAN_MODE);
	switch (i)
	{

	case NORMAL_MODE:
		Message ("Mode now is 'normal mode'");
		command_mode = NORMAL_MODE;
		break;

	case SHIP_MODE:
		Message ("Mode now is 'ship mode'");
		command_mode = SHIP_MODE;
		break;

	case PLANE_MODE:
		Message ("Mode now is 'plane mode'");
		command_mode = PLANE_MODE;
		break;

	case WING_MODE:
		Message ("mode now is 'wing 'mode'");
		command_mode = WING_MODE;
		break;

	case NUKE_MODE:
		Message ("Mode now is 'nuke mode'");
		command_mode = NUKE_MODE;
		break;

	case FLEET_MODE:
		Message ("Mode is now 'fleet mode'");
		command_mode = FLEET_MODE;
		break;
	
#ifdef TERMC_VERSION
	case INFO_MODE:
		Message ("Mode is now 'info mode'");
		command_mode = INFO_MODE;
		break;
#endif TERMC_VERSION

	case PLAN_MODE:
		Message ("Mode is now 'plan mode'");
		command_mode = PLAN_MODE;
		break;
	}

	Census ();
	FreeStrings (strings);
	FreePager (pager);
	if (command_mode == PLAN_MODE || drawmap)
		DrawMap ();
}

#define CC_CONNECT	0
#define CC_CONTIMEOUT	1
#define CC_DISCONNECT	2
#define CC_SILENTCON	3
#define CC_QUIT		4
#define CC_QUITNOSAVE	5

#define CC_NR		6

static char *ccom [] =
{
	"connect",
	"set connect timeout (now XXXX)",
	"disconnect",
	"turn silent (dis)connect on (now off)",
	"quit",
	"quit, no save data",
	(char *) 0
};

void Connections (x, y)
int x, y;
{
	Pager pager;
	Strings strings;
	char *new;
	bool cont;
	bool save_con;
	extern unsigned con_timeout;
	extern bool silent_con;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, ccom, CC_NR, 0);

	if (! silent_con)
		ChangeString (strings, CC_SILENTCON,
				       "turn silent (dis)connect on (now off)");

	ChangeString (strings, CC_CONTIMEOUT, con_timeout > MIN_CONTIMEOUT ?
			Fmt ("set connect timeout (now %4d)", con_timeout) :
			"set connect timeout (now off)");
	

	pager = InitPager (strings, "Connection");
	MapPagerFromTop (pager, map_win, x, y);

	cont = True;
	while (cont)
	{
		i = PagerMenu (pager);

		if (i < 0)
		{
			FreePager (pager);
			FreeStrings (strings);
			return;
		}

		if (i == CC_SILENTCON)
		{
			if (silent_con)
			{
				silent_con = False;
				ChangeString (strings, CC_SILENTCON,
				       "turn silent (dis)connect on (now off)");
			}
			else
			{
				silent_con = True;
				ChangeString (strings, CC_SILENTCON,
				       "turn silent (dis)connect off (now on)");
			}
			ShowPagerLine (pager, i);
		}
		else if (i == CC_CONTIMEOUT)
		{
			new = InputAtMessage (
				Fmt ("new connect timeout (off is <= %d) ?",
				MIN_CONTIMEOUT), 4, GS_PNUMBER);
			if (new == (char *) 0 || *new == '\0' || interrupt)
			{
				interrupt = False;
				Message ("Change connection timeout cancelled");
				continue;
			}
			con_timeout = atoi (new);
			ChangeString (strings, CC_CONTIMEOUT,
				con_timeout > MIN_CONTIMEOUT ?
			    Fmt ("set connect timeout (now %4d)", con_timeout) :
			    "set connect timeout (now off)");

			SetSignalsOn ();
			ResetConTimeout ();
			ShowPagerLine (pager, i);
		}
		else
			cont = False;
	}


	FreePager (pager);
	FreeStrings (strings);

	switch (i)
	{

	case CC_QUITNOSAVE:
		save_data = False;
		/* FALL THROUGH */

	case CC_QUIT:
		DoQuit ();
		break;

	case CC_DISCONNECT:
		if (EmpireStatus () == E_DEAD)
		{
			Message ("Already disconnected");
			Bell ();
			break;
		}
		save_con = silent_con;
		silent_con = False;
		Disconnect (-1);
		silent_con = save_con;
		break;

	case CC_CONNECT:
		if (EmpireStatus () != E_DEAD)
		{
			Message ("Already connected");
			Bell ();
			break;
		}
		save_con = silent_con;
		silent_con = False;
		Reconnect ();
		silent_con = save_con;
		break;
	}

	return;
}

#define DE_EDITSHIP	0
#define DE_EDITCOUNTRY	1
#define DE_ADDCOUNTRY	2
#define DE_NEWCAP	3

#define DE_MAX		4

static char *deity_menu [] =
{
	"edit ship",
	"edit country",
	"add  nation",
	"newcap",
	(char *) 0
};

static void DeityCommands (x, y)
int x, y;
{
	Strings strings;
	Pager pager;

	strings = InitStrings ();
	AddStringsID (strings, deity_menu, DE_MAX, 0);
	pager = InitPager (strings, "Deity commands");
	MapPagerFromTop (pager, map_win, x, y);

	switch (PagerMenu (pager))
	{

	case DE_EDITSHIP:
		DeityEditShips (x, y);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case DE_EDITCOUNTRY:
		DeityEditCountry (x, y);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case DE_ADDCOUNTRY:
		FreePager (pager);
		FreeStrings (strings);
		AddNation (x, y);
		break;

	case DE_NEWCAP:
		FreePager (pager);
		FreeStrings (strings);
		DoNewCap (x, y);
		break;
	}
}

/*******************************************************************************
*			Global Command Menu				       *
*******************************************************************************/

#define	GC_CENSUSMODE	0
#define	GC_COMMUN	1
#define GC_CONNECTIONS	2
#define	GC_DISPLAY	3
#define GC_MULTI	4
#define GC_PAGECOM	5
#define GC_INFO		6
#define	GC_RESCAN	7
#define GC_UTILITIES	8
#define GC_BUFFER	9

#define	GC_DEITY	10

#define GC_NR		11

static char *gcom [] =
{
	"census mode",
	"communications",
	"connection",
	"display",
	"multi (realm) commands",
	"page empire commands",
	"info",
	"re-scan",
	"utilities",
	"buffered commands",
	"deity",
	(char *) 0
};

void GlobalCommands (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	int r;

	strings = InitStrings ();
	AddStringsID (strings, gcom, GC_NR - 1, 0);

	if (deity)
		AddStringID (strings, gcom [GC_DEITY], GC_DEITY);

	pager = InitPager (strings, "Command ?");
	MapPagerFromTop (pager, map_win, x, y);
	r = PagerMenu (pager);

	switch (r)
	{

	case GC_DISPLAY:
		ChangeDisplay (x + 5, y + 5);
		break;

	case GC_CENSUSMODE:
		ChangeCommandMode (x + 5, y + 5);
		break;

	case GC_COMMUN:
		Commun (x + 2, y + 2);
		break;

	case GC_PAGECOM:
		WMPageCommand (x + 2, y + 2);
		break;

	case GC_MULTI:
		FreePager (pager);
		FreeStrings (strings);
		Multi (x + 2, y + 2);
		return;

	case GC_RESCAN:
		FreePager (pager);
		FreeStrings (strings);
		Rescan (x + 2, y + 2);
		return;

	case GC_INFO:
		InfoCommands (x + 2, y + 2);
		break;

	case GC_UTILITIES:
		FreePager (pager);
		FreeStrings (strings);
		Utils (x + 2, y + 2);
		Census ();
		return;

	case GC_CONNECTIONS:
		Connections (x + 2, y + 2);
		break;

	case GC_DEITY:
		DeityCommands (x + 5, y + 5);
		break;

	case GC_BUFFER:
		BufferMenu (x + 5, y + 5);
		break;
	}

	FreePager (pager);
	FreeStrings (strings);
	Census ();
}

#define MAX_COMMANDS 40

#define	CM_ASSAULT	0
#define CM_ATTACK	1
#define CM_BOARD	2
#define CM_BUILDSHIP	3
#define CM_BUILDPLANE	4
#define CM_BUILDBRIDGE	5
#define CM_BUILDNUKE	6
#define CM_CAPITOL	7
#define CM_COASTWATCH	8
#define CM_CONVERT	9
#define CM_DEMOBILIZE	10
#define CM_DESIGNATE	11
#define CM_DELIVER	12
#define CM_DISTR_LOC	13
#define CM_ENLIST	14
#define CM_EXPLORE	15
#define CM_SHOOT	16
#define CM_LANDFIRE	17
#define CM_LOOKOUT	18
#define CM_MOVE		19
#define CM_NAVIGATE	20
#define CM_LANDRADAR	21
#define CM_ORIGIN	22
#define CM_REDUMP	23
#define CM_SCRAP	24
#define CM_UPGRADE	25
#define CM_SHIPRADAR	26
#define CM_SHIPFIRE	27
#define CM_SPY		28
#define CM_FLY		29
#define CM_LAUNCH	30
#define CM_TRANSPORT	31
#define CM_BOMB		32
#define	CM_PARADROP	33
#define	CM_DROP		34
#define	CM_RECON	35
#define CM_FLEETADD	36
#define CM_WINGADD	37
#define CM_CHANGEOWNER	38
#define CM_SELL		39

static char *sct_command [] =
{
	"assault",
	"attack",
	"board ship",
	"build ship",
	"build plane",
	"build bridge",
	"build nuke",
	"capitol",
	"coastwatch",
	"convert",
	"demobilize",
	"designate",
	"deliver",
	"distribute",
	"enlist",
	"explore",
	"shoot",
	"fire",
	"lookout",
	"move",
	"navigate",
	"landradar",
	"origin",
	"redump sector",
	"scrap",
	"upgrade",
	"radar",
	"fire",
	"spy",
	"fly",
	"launch",
	"transport",
	"bomb",
	"paradrop",
	"drop",
	"recon",
	"fleet add",
	"wing add",
	"change owner",
	"sell",
	(char *) 0
};

void SectorCommands (x, y)
int x, y;
{
	char *ptr;
	int r;
	Sector nxt;
	Neighb neighb;
	char * what;

	Strings strings;
	Pager pager;

	extern int capitol_x, capitol_y;
	extern int last_layout;

	strings = InitStrings ();

#define ADD(X)	AddSortStringID (strings, sct_command [X], X)
/*
#define ADD(X)	AddStringID (strings, sct_command [X], X)
*/

		/*
		 *	First add all ship/fleet commands
		 */

	if (last_layout == SHIP_MODE || last_layout == FLEET_MODE)
	{
		if (SectorHasOwnedShips (cursct, 1))	/* could be enemy */
		{
			ADD (CM_NAVIGATE);

			if (s_des (cursct) == 'h' && (deity || (s_owned (cursct)
						     && s_eff (cursct) >= 60)))
			{
				ADD (CM_SCRAP);
				ADD (CM_UPGRADE);
				ADD (CM_FLEETADD);
			}
		}
	}

	if (last_layout == PLANE_MODE || last_layout == WING_MODE)
	{
		ADD (CM_WINGADD);
		ADD (CM_FLY);
		ADD (CM_TRANSPORT);
		ADD (CM_BOMB);
		ADD (CM_PARADROP);
		ADD (CM_DROP);
		ADD (CM_RECON);
	}

	if (last_layout == PLANE_MODE)
		ADD (CM_LAUNCH);

	ADD (CM_DESIGNATE);

	if (! s_owned (cursct) || deity)
		ADD (CM_CHANGEOWNER);

	
	if (s_owned (cursct) || deity)
	{
		if (s_des (cursct) == 'h' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDSHIP);

		if (s_des (cursct) == '*' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDPLANE);

		if (s_des (cursct) == '#' && s_eff (cursct) > 59)
			ADD (CM_BUILDBRIDGE);

		if (s_des (cursct) == 'n' && (deity || s_eff (cursct) >= 60))
			ADD (CM_BUILDNUKE);

		if (s_des (cursct) == 'c')
			ADD (CM_CAPITOL);

		if (s_occ (cursct) == '*')
			ADD(CM_CONVERT);
		
		ADD (CM_DELIVER);

		if (s_eff (cursct) > 60 && s_mil (cursct) > 0)
			ADD (CM_DEMOBILIZE);

		ADD (CM_DISTR_LOC);

		if (n_mil_res (nation) > 0 && s_civ (cursct) > 0)
			ADD (CM_ENLIST);

		ADD (CM_MOVE);
		ADD (CM_EXPLORE);

		ADD (CM_SHOOT);

		if (s_des (cursct) == 'f' && q_gun (cursct) > 0 &&
							q_she (cursct) > 0)
			ADD (CM_LANDFIRE);

		ADD (CM_COASTWATCH);
		
		if (s_des (cursct) == ')')
			ADD (CM_LANDRADAR);

		InitNeighbours (cursct, & neighb);
		while (NextNeighbour (& nxt, S_DESIG, neighb))
		{
			if ((deity || ! s_owned (nxt)) && s_des (nxt) != '.'
						&& s_des (nxt) != '\\')
			{
				ADD (CM_SPY);
				break;
			}
		}

		ADD (CM_ORIGIN);
		ADD (CM_SELL);
	}

	if ((deity || ! s_owned (cursct)) && s_des (cursct) != '.' &&
					s_des (cursct) != '\\')
	{
		
		if (IsCoast (cursct))
			ADD (CM_ASSAULT);

		ADD (CM_ATTACK);
	}

	if (last_layout != SHIP_MODE && last_layout != FLEET_MODE)
	{
		if (SectorHasOwnedShips (cursct, 1))	/* could be enemy */
		{
			ADD (CM_NAVIGATE);
			ADD (CM_FLEETADD);

			if (s_des (cursct) == 'h' && (deity || (s_owned (cursct)
						     && s_eff (cursct) >= 60)))
			{
				ADD (CM_SCRAP);
				ADD (CM_UPGRADE);
			}
		}
	}

	if (last_layout != PLANE_MODE && last_layout != WING_MODE &&
							s_pla (cursct) > 0)
	{
		ADD (CM_WINGADD);
		ADD (CM_FLY);
		ADD (CM_TRANSPORT);
		ADD (CM_BOMB);
		ADD (CM_PARADROP);
		ADD (CM_DROP);
		ADD (CM_RECON);
	}

	ADD (CM_REDUMP);
	
	pager = InitPager (strings, "Your command sir ?");
	MapPagerFromTop (pager, map_win, x + 2, y + 2);
	r = PagerMenu (pager);

	switch (r)
	{

	case CM_ASSAULT:
		FreePager (pager);
		FreeStrings (strings);
		Assault (x + 2, y + 2);
		break;

	case CM_ATTACK:
		FreePager (pager);
		FreeStrings (strings);
		Attack ();
		break;

	case CM_BUILDSHIP:
		BuildShip (x + 5, y + 5);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_BUILDPLANE:
		BuildPlane (x + 5, y + 5);
		FreePager (pager);
		FreeStrings (strings);
		return;

	case CM_BUILDBRIDGE:
		FreePager (pager);
		FreeStrings (strings);
		BuildBridge ();
		return;
	
	case CM_BUILDNUKE:
		FreePager (pager);
		FreeStrings (strings);
		BuildNuke (x + 5, x + 5);
		return;

	case CM_BOARD:
		Board (x + 2, y + 2);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_CAPITOL:
		FeedEmpire (Fmt ("capitol %s", CrdStr (cursct)), PRINT);
		ptr = ReadEmpire (PRINT);
		if (ptr == (char *) 0)
			return;
		Bell ();
		if (EmpireStatus () != E_PRINTING ||
				strncmp (ptr, "Capital now at", 14) != 0)
		{
			Message ("Capitol command failed");
			if (EmpireStatus () != E_PRINTING)
				PrintAtEmpire (ptr);
		}
		else {
			capitol_x = s_xcd (cursct);
			capitol_y = s_ycd (cursct);
			Message (ptr);
		}
		(void) WaitForPrompt (PRINT);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_COASTWATCH:
		FScanCoastWatch (CrdStr (cursct));
		FreePager (pager);
		FreeStrings (strings);
		DrawMap ();
		break;

	case CM_CONVERT:
		DeityChange (cursct);
		SingleConvert ();
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_DEMOBILIZE:
		DeityChange (cursct);
		SingleDemob ();
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_DESIGNATE:
		DeityChange (cursct);
		Design (cursct, x + 1, y + 1);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_DELIVER:
		DeityChange (cursct);
		FreePager (pager);
		FreeStrings (strings);
		Deliver (x, y);
		break;

	case CM_DISTR_LOC:
		DeityChange (cursct);
		FreePager (pager);
		FreeStrings (strings);
		Distribute (cursct, x, y);
		break;

	case CM_ENLIST:
		DeityChange (cursct);
		SingleEnlist ();
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_EXPLORE:
		DeityChange (cursct);
		FreePager (pager);
		FreeStrings (strings);
		Explore (x, y);
		break;

	case CM_SHOOT:
		DeityChange (cursct);
		FreePager (pager);
		FreeStrings (strings);
		SingleShoot ();
		break;

	case CM_LANDFIRE:
		FreePager (pager);
		FreeStrings (strings);
		FireFromSector ();
		break;

	case CM_LANDRADAR:
		FScanRadar (CrdStr (cursct));
		DrawMap ();
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_MOVE:
		FreePager (pager);
		FreeStrings (strings);
		Move (x, y);
		break;

	case CM_NAVIGATE:
		FreePager (pager);
		FreeStrings (strings);
		Navig (x, y);
		break;
	
	case CM_FLEETADD:
		FleetAdd (x, y);
		FreePager (pager);
		FreeStrings (strings);
		Census ();
		break;

	case CM_ORIGIN:
		FreePager (pager);
		FreeStrings (strings);
		ChangeOrigin (cursct);
		break;

	case CM_SCRAP:
		what = SelectShips (x, y, ST_SCRAP, "Scrap which ships ?");
		if (what != (char *) 0)
			ScrapShip (what);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_UPGRADE:
		what = SelectShips (x, y, ST_UPGRADE, "Upgrade which ships ?");
		if (what != (char *) 0)
			UpgradeShip (what);
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_SPY:
		FScanSpy (CrdStr (cursct));
		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_REDUMP:
		if (FScanDump (CrdStr (cursct), PRINT) == 0 &&
							KNOW_ALL (cursct))
		{
			PrintAtEmpire (Fmt ("Sector %s has been lost !!",
					CrdStr (cursct)));

			set_owner (cursct, UNKNOWN_CNUM);

			DEL_INFO (cursct);
			SET_INFO_RES (cursct);
		}

		if (s_shi (cursct) > 0)
			(void) DumpSctShips (cursct, PRINT);

		FreePager (pager);
		FreeStrings (strings);
		break;

	case CM_FLY:
		FreePager (pager);
		FreeStrings (strings);
		Fly (x, y);
		break;
	
	case CM_DROP:
		FreePager (pager);
		FreeStrings (strings);
		DropOff (x, y);
		break;

	case CM_PARADROP:
		FreePager (pager);
		FreeStrings (strings);
		DoParadrop (x, y);
		break;
	
	case CM_BOMB:
		FreePager (pager);
		FreeStrings (strings);
		Bomb (x, y);
		break;

	case CM_LAUNCH:
		FreePager (pager);
		FreeStrings (strings);
		DoLaunch (curplane);
		break;

	case CM_TRANSPORT:
		FreePager (pager);
		FreeStrings (strings);
		DoTransport (x, y);
		break;

	case CM_WINGADD:
		FreePager (pager);
		FreeStrings (strings);
		WingAdd (x, y);
		break;
        case CM_RECON:		/* mta */
		FreePager (pager);
		FreeStrings (strings);
		DoRecon (x, y);
		break;
	case CM_CHANGEOWNER: /* - heinola 9/11/91. */
		ChangeOwner (cursct);
		FreePager (pager);
		FreeStrings (strings);
		break;
	case CM_SELL:		/* jpo */
		FreePager (pager);
		FreeStrings (strings);
		SingleSell (x, y);
		break;
	default:
		FreePager (pager);
		FreeStrings (strings);
	}

	Census ();
	DrawSector (cursct);
}
