#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"

static int build_ba = 41,
           build_bh = 100,
           build_bw = 200,
           build_bc = 2000;
static double build_bt = 100.0;


void FScanBuildBridge ()
{
	int n;
	char * line;

	n = 0;
	FeedEmpire ("show build bridge", PRINT);
	PrintAtEmpire ("Xemp: scanning output");

	for (;;)
	{
		line = ReadEmpire (DONT_PRINT);
		if (EmpireStatus () != E_PRINTING)
			break;

		n += sscanf (line, "Bridges require %lf tech, %d hcm, %d wor",
				& build_bt, & build_bh, & build_bw);
		n += sscanf (line, "%d available workforce, and cost $%d",
				& build_ba, & build_bc);
	}

	PrintAtEmpire (line);
	(void) WaitForPrompt (PRINT);
	if (n != 5)
	{
		PrintAtEmpire ("Warning: can't find the build bridge values");
		(void) EmpireMore ();
	}
}

void SaveBridgeData (fp)
FILE * fp;
{
	fprintf (fp, "%d %lf %d %d %d\n",
			build_ba, build_bt, build_bc, build_bh, build_bw);
}

void RestoreBridgeData (fp)
FILE * fp;
{
	if (fscanf (fp, "%d %lf %d %d %d\n", & build_ba, & build_bt,
				& build_bc, & build_bh, & build_bw) != 5)
	{
		PrintAtEmpire ("Incorrect savefile, bad show bridge\n");
		EmpireMore ();
	}
}

void BuildBridge ()
{
	int x, y, button;
	Sector sct;

	if (cursct == (Sector) 0)
		return;
	
	if (! s_owned (cursct) || s_des (cursct) != '#')
	{
		Message ("You can only build bridges at (owned) bridge-heads");
		Bell ();
		return;
	}

	if (s_eff (cursct) < 60)
	{
		Message ("Should be at least 60%");
		Bell ();
		return;
	}

	if (s_ava (cursct) < build_ba)
	{
		Message (Fmt ("Not enough available workers (need %d)",
					build_ba));
		Bell ();
		return;
	}

	if (q_hcm (cursct) < build_bh)
	{
		Message (Fmt ("Not enough hcm's to build a bridge (need %d)",
						build_bh));
		Bell ();
		return;
	}

	if ((double) n_tech (nation) < build_bt)
	{
		Message (Fmt ("Technology of %.2f required to build bridges",
				build_bt));
		Bell ();
		return;
	}

	Message ("Select sector to build the bridge-head");
	MesBut ("View", "Cancel", "Build");

	for (;;)
	{
		if (! SelectSctCrd (& x, & y, & button) ||
							button == MIDDLE_BUTTON)
		{
			Message ("Build bridge cancelled");
			MesClearBut ();
			return;
		}

		sct = World (x, y, S_EXIST);
		if (sct == (Sector) 0 || NO_INFO (sct))
			continue;
		
		if (button == LEFT_BUTTON)
		{
			CensusSct (sct);
			continue;
		}

		if (! Adjacent (cursct, sct))
		{
			Message ("Should be adjacent to the bridge-head");
			Bell ();
			continue;
		}

		if (s_des (sct) != '.')
		{
			Message ("Only across water");
			Bell ();
			continue;
		}

		break;
	}

	MesClearBut ();

	FeedEmpire (Fmt ("build bridge %s", CrdStr (cursct)), PRINT);
	(void) WaitForPrompt (PRINT);
	if (EmpireStatus () == E_COMMAND)
	{
		Message ("Build failed !");
		Bell ();
		return;
	}

	FeedEmpire  (Fmt ("%c", GiveDirChar (cursct, sct)), PRINT);
	(void) WaitForPrompt (PRINT);
	
	set_des (sct, '=');
	DrawSector (sct);
	Message ("redumping bridge head");
	RedumpSector (cursct, PRINT);

	Message ("Now you should explore the bridge span");
}
