/*********************************************************************
  Title: emp_mux
  Author: Alan M. Levi (levi@cs.psu.edu)
  Last date of modification: March 10, 1993
*********************************************************************/
   
int listen_port = 4747; /* default port.  Change this for your own
			   protection. */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>

#include "main.h"
#include "client.h"


#define CMD_ENDED 6
char prompt[16*MAX_BUF_SIZE + 1];
char entire_line[16*MAX_BUF_SIZE + 1];

char s_n[3][80];
char *server_name;
u_short server_port;
char *country;
char *password;

int server_port_set = 0;
int server_name_set = 0;
int country_set = 0;
int password_set = 0;



char *server_responses[] = {
  "0 hello ",
  "0 country name",
};  

struct node {
  int echo;
  int sock;
  struct node *next;
  struct node *prev;
};

#define NODE struct node

NODE *client_sock_head = NULL;
int client_list_size = 0;

int listen_sock;
int server_sock;

int server_echo = 0;
int listen_echo = 0;
int default_client_echo = 0;

int auto_reconnect = 1;
int num_commands_since_last_reconnect = 30;
struct sockaddr_in server_addr, client_addr;
fd_set readfds;
fd_set temp_fds;

main(ac, av)
int ac;
char *av[];
{
  int i;
  char *t;

  if(server_name=getenv("EMPIREHOST"))
    server_name_set = 1;

  if(t=getenv("EMPIREPORT")) {
    server_port_set = 1;
    server_port = (u_short)atoi(t);
  }

  if(country = getenv("COUNTRY"))
    country_set = 1;

  if(password = getenv("PLAYER"))
    password_set = 1;

  {
    char *temp = getenv("LISTENPORT");
    listen_port = temp?atoi(temp):listen_port;
  }

  for(i=1;i<ac;i++) {
    if(!strncmp("-l", av[i], 2)) {
      i++;
      if((listen_port = atoi(av[i])) < 0) {
	fprintf(stderr, "invalid port number %s\n", av[i]);
	exit(0);
      }
    }
    else if(!strncmp("-p", av[i], 2)) {
      i++;
      server_port_set = 1;
      server_port = (u_short)atoi(av[i]);
    }
    else if(!strncmp("-h", av[i], 2)) {
      i++;
      server_name_set = 1;
      server_name = s_n[0];
      strcpy(server_name, av[i]);
    }
    else if(!strncmp("-P", av[i], 2)) {
      i++;
      password_set = 1;
      password = s_n[1];
      strcpy(password, av[i]);
    }
    else if(!strncmp("-c", av[i], 2)) {
      i++;
      country_set = 1;
      country = s_n[2];
      strcpy(country, av[i]);
    }
  }

  if(!(server_port_set && server_name_set && password_set && country_set)) {
    show_usage(av[0]);
    exit(0);
  }

  FD_ZERO(&readfds);
  FD_SET(0, &readfds); /* stdin */

  init_server_addr(av[0]);
/*  printf("server addr initialized.\n");*/
  server_login();
  printf("server initialization done.\n");
  init_client_addr();
  start_listening();
  printf("initialization done.\n");

  for(;;) {
    int n;
    descpy(&temp_fds, &readfds);
    printf("select in main...\n");
    while((n = select(FD_SETSIZE, &temp_fds, (fd_set *)NULL, (fd_set *)NULL,
		      (struct timeval *)NULL)) <= 0);
    
/*    printf("%d sockets ready for reading...\n", n);*/
    if(FD_ISSET(server_sock, &temp_fds)) { /* highest priority */
      (void)process_server_msg();
    }
    else {
      struct node *tn = client_sock_head;
      int n = 0;
      int csock = -1;

      while((n < client_list_size) && (csock < 0)) {
	if(FD_ISSET(tn->sock, &temp_fds))
	  csock = tn->sock;
	else
	  tn = tn->next;
	n++;
      }
      if(csock > 0)
	process_cmd(csock);
      else if(FD_ISSET(listen_sock, &temp_fds)) {
	client_login();
      }
      else if(FD_ISSET(0, &temp_fds)) {
	int ch;
	ch = getchar();
	my_parse((char)ch);
	while((char)getchar() != '\n');
      }
      else {
	fprintf(stderr, "hmm... perhaps the select values are screwed up.\n");
	/* hmmm... select values must be wrong. */
      }
    }
  }
}


void server_login()
{
  int t;
  char temp[80];
  struct sockaddr_in temp_addr;

  temp_addr = server_addr;

  temp_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  temp_addr.sin_port = htons(0);

  server_sock = socket(AF_INET, SOCK_STREAM, 0);
  FD_SET(server_sock, &readfds);

  if(server_sock < 0) {
    perror("socket");
    exit(0);
  }

  if(bind(server_sock, &temp_addr, sizeof(server_addr)) < 0) {
    perror("bind");
    exit(0);
  }

  if(connect(server_sock, (struct sockaddr_in *)&server_addr,
	     sizeof(struct sockaddr_in)) < 0) {
    perror("connect");
    exit(0);
  }


  if(!expect(server_sock, "2 Empire server ready")) {
    fprintf(stderr, "Error in server_login().  Empire server not ready.\n");
    exit(0);
  }

  put_line(server_sock, "user emp_mux\n", 10);
  expect(server_sock, "0 hello emp_mux\n");
  
  sprintf(temp, "coun %s\n", country);
  put_line(server_sock, temp, strlen(temp));

  sprintf(temp, "0 country name %s\n", country);
  expect(server_sock, temp);
  
  sprintf(temp, "pass %s\n", password);
  put_line(server_sock, temp, strlen(temp));
  expect(server_sock, "0 password ok\n");
  
  put_line(server_sock, "play\n", 5);

  while(!expect(server_sock, "6 "))
    if(!strncmp(entire_line, "3 ", 2))
      quit_safely();
    else if(!strncmp(entire_line, "1 ", 2)) {
      print_n_str(entire_line+2, strlen(entire_line+2));
    }
/*  printf("**PROMPT in main**: %s\n", entire_line);*/
 (void)strcpy(prompt, entire_line);
}

void client_login()
{
  char temp[80];
  char temp2[80];
  int t = sizeof(struct sockaddr_in);
  int sock;

  sock = accept(listen_sock, &client_addr, &t);
  insert_new_client(sock);
  FD_SET(sock, &readfds); /* listen sock */

/*
  init_client_addr();
  start_listening();
*/

  put_line(sock, "2 Empire server ready.\n", 23);

  while(!expect(sock, "user "));
  sscanf(another_buf, "user %s\n", temp);
  sprintf(temp2, "0 hello %s\n", temp);
  put_line(sock, temp2, strlen(temp2));

  while(!expect(sock, "coun "));
  sscanf(another_buf, "coun %s\n", temp);
  sprintf(temp2, "0 country name %s\n", temp);
  put_line(sock, temp2, strlen(temp2));
  
  while(!expect(sock, "pass "));
  put_line(sock, "0 password ok\n", 14);
  
  while(!expect(sock, "play"));
  put_line(sock, "2 2\n", 4);
  put_line(sock, prompt, strlen(prompt));
}

void leave()
{
  
}

int expect(sock, str)
int sock;
char *str;
{
  int size, retval;
  int len = strlen(str);
  int total = 0;

  size = get_line(sock, entire_line, MAX_BUF_SIZE, 0);
  total = size;
  while(((size == 0) || (total < len)) && (entire_line[total-1] != '\n')) {
    size = get_line(sock, entire_line + total, MAX_BUF_SIZE, 0);
    total += size;
  }
/*  (void)strncpy(entire_line, another_buf, size);*/
  entire_line[total] = '\0';
  retval = !strncmp(entire_line, str, len);
  while(entire_line[total-1] != '\n') {
    size = get_line(sock, entire_line + total, MAX_BUF_SIZE, 0);
    total += size;
  }

  if(total > (16 * MAX_BUF_SIZE)) {
    fprintf(stderr, "FATAL ERROR!  buffer exceeded.\n");
    fprintf(stderr, "****  %d extra characters written to buffer\n",
	    total - 16*MAX_BUF_SIZE);
  }

  return retval;
}

void put_line(s, str, n)
int s;
char *str;
int n;
{
  if(send(s, str, n, 0) < 0) {
    fprintf(stderr, "error in put_line. sock=%d\n", s);
    printf("-> socket #%2d | ", s);
    print_n_str(str, strlen(str));
  }
  else {
    if(should_echo(s)) {
      printf("-> socket #%2d | ", s);
      print_n_str(str, strlen(str));
    }
/*
    else
      printf("-> socket #%2d\n", s);
*/
  }
}

void init_client_addr()
{
  bzero((char *) &client_addr, sizeof(struct sockaddr_in));
  client_addr.sin_family = AF_INET;
  client_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  client_addr.sin_port = htons(listen_port);
}

void start_listening()
{

  listen_sock = socket(AF_INET, SOCK_STREAM, 0);
  if(listen_sock < 0) {
    perror("socket");
    exit(0);
  }
  
  if(bind(listen_sock, &client_addr, sizeof(struct sockaddr_in)) < 0) {
    perror("bind");
    exit(0);
  }

  if(listen(listen_sock, 5) < 0) {
    perror("listen");
  }
  FD_SET(listen_sock, &readfds); /* listen sock */
}

void insert_new_client(sock)
int sock;
{
  struct node *temp;

  client_list_size++;
  temp = (struct node *)malloc(sizeof(struct node));
  temp->echo = default_client_echo;
  temp->sock = sock;
  if(client_sock_head == NULL) {
    client_sock_head = temp;
    client_sock_head->next = client_sock_head;
    client_sock_head->prev = client_sock_head;
  }
  else {
    temp->next = client_sock_head;
    temp->prev = client_sock_head->prev;
    client_sock_head->prev->next = temp;
    client_sock_head->prev = temp;
  }
}

void delete_client(sock)
int sock;
{
  struct node *i, *temp;

  if(client_sock_head == NULL) {
    fprintf(stderr, "Error in delete_client\n");
    return;
  }

  client_list_size--;
  temp = client_sock_head->prev;
  for(i=client_sock_head;(i != temp) && (i->sock != sock);i = i->next);

  if(i->sock != sock) {
    fprintf(stderr, "Error 2 in delete_client\n");
    return;
  }

  if(i->next == i) {
    free(i);
    client_sock_head = NULL;
  }
  else {
    i->next->prev = i->prev;
    i->prev->next = i->next;
    if(i == client_sock_head)
      client_sock_head = i->next;
    free(i);
  }

}

void init_server_addr(x)
char *x;
{
  struct hostent *h;

  bzero((char *) &server_addr, sizeof(struct sockaddr_in));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port   = server_port;
/* perhaps remove htonl */
  if((server_addr.sin_addr.s_addr = inet_addr(server_name)) != -1)
    return;
  h = gethostbyname(server_name);
  if (h == (struct hostent *)NULL) {
    show_usage(x);
    printf("** Can't find host %s. **\n",server_name);
    exit(0);
  }
  bcopy((struct in_addr *) *(h->h_addr_list), 
	(char *) &server_addr.sin_addr, 
	sizeof(server_addr.sin_addr));

}

void descpy(d1, d2)
fd_set *d1;
fd_set *d2;
{
  int i, max;

  max = howmany(FD_SETSIZE, NFDBITS);

  for(i=0;i<max;i++) {
    d1->fds_bits[i] = d2->fds_bits[i];
  }
}

void parse()
{
  int c;
  printf("entering parser.\n");
/*  c = yyparse();*/
  printf("exiting parser.  retval = %d\n", c);
}


int find_sock(n)
int n;
{
  int i;
  struct node *t, *temp;

  if(client_sock_head == NULL)
    return -1;
  if(n > client_list_size)
    return -1;
  t = client_sock_head;
  for(i=0;(i<client_list_size) && (i<n);i++,t=t->next);
  return t->sock;
}

void client_logout(sock)
int sock;
{
  put_line(sock, "1 Bye-bye\n", 10);
  put_line(sock, "3 so long...\n", 13);
  close(sock);
  
  delete_client(sock);
  FD_CLR(sock, &readfds);
}

void print_n_str(str, n)
char *str;
int n;
{
  int i;
  for(i=0;(i<n) && (str[i] != '\0');i++)
    putchar(str[i]);
}

void quit_safely()
{
  while(client_sock_head) {
    close(client_sock_head->sock);
    delete_client(client_sock_head->sock);
  }
  close(listen_sock);
  close(server_sock);
  fprintf(stderr, "quitting safely.  bye...\n");
  exit(0);
}

void toggle_connection_output(sock)
int sock;
{
  if(sock == server_sock)
    server_echo = !server_echo;
  else {
    int i;
    struct node *t, *temp;
    
    if(client_sock_head == NULL)
      return;
    t = client_sock_head;
    for(i=0;(i<client_list_size) && (t->sock != sock);i++,t=t->next);
    if(t->sock == sock)
      t->echo = !(t->echo);
  }
}

int should_echo(sock)
int sock;
{
  if(sock == server_sock)
    return server_echo;
  else if(sock == listen_sock)
    return listen_echo;
  else {
    int i;
    struct node *t, *temp;
    
    if(client_sock_head == NULL)
      return;
    t = client_sock_head;
    for(i=0;(i<client_list_size) && (t->sock != sock);i++,t=t->next);
    if(t->sock == sock)
      return t->echo;
  }
  fprintf(stderr, "Error in should_echo.  Socket (%d) not found\n", sock);
  return 1;
}

void my_strncat(s1, s2, n)
char *s1;
char *s2;
int n;
{
  int i, j;
  for(i=0; s1[i] != '\0';i++);

  for(j=0;(j<n) && (s2[j] != '\0');j++) {
    s1[i+j] = s2[j];
  }
  s1[i+j] = '\0';
}

void list_all_clients()
{
  int i = 0;
  struct node *temp = client_sock_head;

  if(client_sock_head == NULL) {
    printf("no clients connected\n");
    return;
  }
  printf("**********\nClients:\n");
  printf("number\tsock\techo\n");
  while(i < client_list_size) {
    printf("%d\t%d\t%s\n", i, temp->sock, (temp->echo?"yes":"no"));
    i++;
    temp = temp->next;
  }
}

void server_reconnect(forced)
int forced;
{
  int old_server_sock = server_sock;

  if(!forced && (num_commands_since_last_reconnect < 20))
    return;

  printf("%creconnecting to server...\n",7);
  put_line(server_sock, "quit\n", 5);
  while(!expect(server_sock, "1 Bye-bye"))
    printf("waiting to disconnect from server...\n");
  while(!expect(server_sock, "3 so long..."))
    printf("waiting to disconnect from server...\n");
  close(server_sock);

  init_server_addr();
  server_login();

  if(old_server_sock != server_sock) {
    FD_CLR(old_server_sock, &readfds);
    FD_SET(server_sock, &readfds);
  }
  printf("reconnected to server.%c\n",7);
  num_commands_since_last_reconnect = 0;
}

void my_parse(ch)
char ch;
{
  switch(ch) {
  case 'q':
    quit_safely();
    break;
  case 'r':
    server_reconnect(1);
    break;
  default:
    fprintf(stderr, "invalid command.  Valid commands are:\n");
    fprintf(stderr, "q     quit\n");
    fprintf(stderr, "r     reconnect to server\n");
    break;
  }
}

void show_usage(x)
char *x;
{
  fprintf(stderr, "Usage:\n\t%s -h hostname -p portnum -c country -P password\n",x);
  fprintf(stderr, "\t[-l listenport]\n");
  fprintf(stderr, "listenport defaults to 4747\n");
  fprintf(stderr, "Other arguments may be specified as environment vars\n");
  fprintf(stderr, "Environment variables recognized: EMPIRHOST,EMPIREPORT,COUNTRY,\n");
  fprintf(stderr, "\tLISTENPORT and PLAYER\n");
}
