/*************************************************************
 *  $Id: gencoms.c,v 1.4 91/05/17 12:10:52 dhay Exp $
 *
 *  gencoms.c
 *
 *  Some general commands.
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1991.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <ctype.h>

/* From print.c */
void prt(), eprt();

/* From the GNU readline stuff. */
int write_history();

/* From games.c */
void list_games();

/******************************************
 * cmd_echo
 *
 * The "echo" command.
 */
    void
cmd_echo(buf, sub)
    char *buf;
    int sub;
{
    while (isspace(*buf)) buf++;
    prt("%s\n", buf);
}

/******************************************
 * cmd_beep
 *
 * Beep a bit.
 */
    void
cmd_beep(buf, sub)
    char *buf;
    int sub;
{
    eprt("");
}

/******************************************
 * cmd_games
 *
 * Show the configured games.
 */
    void
cmd_games(buf, sub)
    char *buf;
    int sub;
{
    char *cp;

    while (isspace(*buf)) buf++;
    cp = buf;
    if (*cp) {
	while (*cp && !isspace(*cp)) cp++;
	*cp = '\0';
    }

    list_games(buf);
}

/******************************************
 * cmd_history
 *
 */
    void
cmd_history(buf, sub)
    char *buf;
    int sub;
{
    /* Need some way of adding line numbers. */
    write_history("/dev/tty");
}

/******************************************
 * cmd_system
 *
 */
    void
cmd_system(buf, sub)
    char *buf;
    int sub;
{
    int ret;

    ret = system(buf);
    if ((ret % 256) != 0)
	eprt("Problem in 'system' call, %d returned\n", (ret%256));
}
